/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.vdb;

import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.vdb.api.ModelInfo;
import com.metamatrix.common.vdb.api.VDBArchive;
import com.metamatrix.common.vdb.api.VDBDefn;
import com.metamatrix.common.vdb.api.VDBInfo;
import com.metamatrix.common.vdb.api.VDBStream;
import com.metamatrix.common.vdb.api.VDBStreamImpl;
import com.metamatrix.console.ConsolePlugin;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.ConfigurationManager;
import com.metamatrix.console.models.ConnectorManager;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.models.RuntimeMgmtManager;
import com.metamatrix.console.models.VdbManager;
import com.metamatrix.console.notification.DataEntitlementChangeNotification;
import com.metamatrix.console.ui.layout.ConsoleMainFrame;
import com.metamatrix.console.ui.layout.WorkspaceController;
import com.metamatrix.console.ui.util.BasicWizardSubpanelContainer;
import com.metamatrix.console.ui.util.WizardInterfaceImpl;
import com.metamatrix.console.ui.views.vdb.AllMaterializationFilesDisplayInfo;
import com.metamatrix.console.ui.views.vdb.BindingNameAndExistingUUID;
import com.metamatrix.console.ui.views.vdb.BindingsAlreadyExistDlg;
import com.metamatrix.console.ui.views.vdb.CreateVDBPanelParent;
import com.metamatrix.console.ui.views.vdb.ImportFileSelectionPanel;
import com.metamatrix.console.ui.views.vdb.ModelVisibilityInfo;
import com.metamatrix.console.ui.views.vdb.SingleMaterializationFileDisplayInfo;
import com.metamatrix.console.ui.views.vdb.VDBWizardModelVisibilityPanel;
import com.metamatrix.console.ui.views.vdb.VdbWizardConfirmPanel;
import com.metamatrix.console.ui.views.vdb.VdbWizardEditConnBindPanel;
import com.metamatrix.console.ui.views.vdb.VdbWizardEntitlementsPanel;
import com.metamatrix.console.ui.views.vdb.VdbWizardEntitlementsSelectPanel;
import com.metamatrix.console.ui.views.vdb.VdbWizardIdPanel;
import com.metamatrix.console.ui.views.vdb.VdbWizardSaveMaterializationFilesPanel;
import com.metamatrix.console.ui.views.vdb.VdbWizardUserAndPasswordPanel;
import com.metamatrix.console.ui.views.vdb.VdbWizardWrittenMaterializationFilesPanel;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.core.util.FileUtils;
import com.metamatrix.core.vdb.VDBStatus;
import com.metamatrix.metadata.runtime.api.VirtualDatabase;
import com.metamatrix.metadata.runtime.api.VirtualDatabaseID;
import com.metamatrix.metadata.runtime.exception.VirtualDatabaseDoesNotExistException;
import com.metamatrix.metadata.runtime.exception.VirtualDatabaseException;
import com.metamatrix.platform.admin.api.EntitlementMigrationReport;
import com.metamatrix.server.admin.api.MaterializationLoadScripts;
import com.metamatrix.server.admin.api.RuntimeMetadataAdminAPI;
import com.metamatrix.toolbox.preference.UserPreferences;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.vdb.runtime.BasicModelInfo;
import com.metamatrix.vdb.runtime.BasicVDBDefn;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JPanel;

public class CreateVDBPanel
extends WizardInterfaceImpl {
    private static final String CONNECTION_PROPERTIES_FILE_DESC = ConsolePlugin.Util.getString("VdbWizardSaveMaterializationFilesPanel.connectionPropertiesFile");
    private static final String CREATE_SCRIPT_FILE_DESC = ConsolePlugin.Util.getString("VdbWizardSaveMaterializationFilesPanel.createScriptFile");
    private static final String LOAD_SCRIPT_FILE_DESC = ConsolePlugin.Util.getString("VdbWizardSaveMaterializationFilesPanel.loadScriptFile");
    private static final String SWAP_SCRIPT_FILE_DESC = ConsolePlugin.Util.getString("VdbWizardSaveMaterializationFilesPanel.swapScriptFile");
    private static final String TRUNCATE_SCRIPT_FILE_DESC = ConsolePlugin.Util.getString("VdbWizardSaveMaterializationFilesPanel.truncateScriptFile");
    private static final int NUM_MATERIALIZATION_FILES = 5;
    private static final int ID_STEP_NUM = 2;
    static final String[] VDB_IMPORT_EXTENSIONS = new String[]{"def", "vdb"};
    static final String VDB_TYPE_FILE_DESC = "VDB Import Types (*.def, *.vdb)";
    private static final int IMPORT_INITIALIZED_NONE = -1;
    private static final int IMPORT_INITIALIZED_NEW_VDB = -2;
    private static final int IMPORT_INITIALIZED_NEW_VERSION = -3;
    ImportFileSelectionPanel selectorPanel;
    VdbWizardEditConnBindPanel pnlEditConnBind = null;
    VdbWizardConfirmPanel pnlConfirm = null;
    VdbWizardIdPanel pnlID = null;
    VdbWizardEntitlementsPanel pnlEntitlements = null;
    VdbWizardEntitlementsSelectPanel pnlEntitlementsSelect = null;
    VDBWizardModelVisibilityPanel visPanel = null;
    private VdbWizardUserAndPasswordPanel upPanel = null;
    private VdbWizardSaveMaterializationFilesPanel savePanel = null;
    private VdbWizardWrittenMaterializationFilesPanel matFilesPanel = null;
    private boolean importing = true;
    private boolean creatingNewVDBVersion = false;
    private VirtualDatabase sourceVirtualDatabase;
    private MaterializationLoadScripts scripts = null;
    private int importInitializedType = -1;
    String sVdbName = "";
    String sDescription = "";
    ModelVisibilityInfo[] visInfo = null;
    BasicVDBDefn vdbDefn = null;
    Map mapConnBind = null;
    Map existingBindingsOnImport = null;
    CreateVDBPanelParent dlgParent = null;
    VirtualDatabase newVirtualDatabase = null;
    VDBDefn newVDBDefn = null;
    boolean nextFlag = true;
    short siStatus = 0;
    private EntitlementMigrationReport emrEntitlementReport = null;
    private ModelInfo materializationTableModel;
    private ConnectorBinding materializationConnectorBinding;
    private boolean attemptedCreatingVDB = false;
    private ConnectionInfo connection = null;
    private boolean vdbSelectionChanged = true;
    private String oldVDBPath = "";

    public static Map modelVisibilityMap(ModelVisibilityInfo[] visInf) {
        HashMap<String, Short> map = new HashMap<String, Short>();
        if (visInf != null) {
            for (int i = 0; i < visInf.length; ++i) {
                String modelName = visInf[i].getModelName();
                short visibilityType = visInf[i].isVisible() ? (short)0 : 2;
                map.put(modelName, new Short(visibilityType));
            }
        }
        return map;
    }

    public static Map modelMultiSourceMap(ModelVisibilityInfo[] visInf) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        if (visInf != null) {
            for (int i = 0; i < visInf.length; ++i) {
                String modelName = visInf[i].getModelName();
                Boolean sourceEnabled = new Boolean(visInf[i].isMultipleSourcesSelected());
                map.put(modelName, sourceEnabled);
            }
        }
        return map;
    }

    public CreateVDBPanel(CreateVDBPanelParent dlgParent, VirtualDatabase vdbSourceVdb, ConnectionInfo connection) {
        this.dlgParent = dlgParent;
        this.sourceVirtualDatabase = vdbSourceVdb;
        this.connection = connection;
        this.init();
    }

    private RuntimeMetadataAdminAPI getRuntimeMetadataAdminAPI() {
        return ModelManager.getRuntimeMetadataAPI(this.connection);
    }

    private VdbManager getVdbManager() {
        return ModelManager.getVdbManager(this.connection);
    }

    private ConnectorManager getConnectorManager() {
        return ModelManager.getConnectorManager(this.connection);
    }

    private ConfigurationManager getConfigurationManager() {
        return ModelManager.getConfigurationManager(this.connection);
    }

    private RuntimeMgmtManager getRuntimeMgmtManager() {
        return ModelManager.getRuntimeMgmtManager(this.connection);
    }

    private void init() {
        int iPages = this.getPageCount();
        for (int x = 0; x < iPages; ++x) {
            this.removePage(x);
        }
        String initialDirectory = (String)UserPreferences.getInstance().getValue("metamatrix.console.directory");
        this.selectorPanel = new ImportFileSelectionPanel(this, initialDirectory, 1);
        this.addPage(this.selectorPanel);
        this.pnlID = new VdbWizardIdPanel(1, this);
        this.addPage(this.pnlID);
        VdbWizardIdPanel extra = new VdbWizardIdPanel(1, this);
        this.addPage(extra);
        this.renumberPages();
        this.setListeners();
    }

    private void initImportNewVersion() {
        if (this.importInitializedType != -3) {
            int iPages;
            for (int x = iPages = this.getPageCount(); x > 2; --x) {
                this.removePage(x - 1);
            }
            this.visPanel = new VDBWizardModelVisibilityPanel(1, this);
            this.pnlEditConnBind = new VdbWizardEditConnBindPanel(1, this.sourceVirtualDatabase, this, this.connection);
            this.pnlEntitlementsSelect = new VdbWizardEntitlementsSelectPanel(this.sourceVirtualDatabase, this.connection, this, 1);
            this.pnlConfirm = new VdbWizardConfirmPanel(this.sourceVirtualDatabase, this, 1);
            this.pnlEntitlements = new VdbWizardEntitlementsPanel(this.sourceVirtualDatabase, this, this.connection, 1);
            this.addPage(this.visPanel);
            this.addPage(this.pnlEditConnBind);
            this.addPage(this.pnlEntitlementsSelect);
            this.addPage(this.pnlConfirm);
            this.pnlEntitlementsSelect.getViewEntitlementsReportCbx().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    CreateVDBPanel.this.processViewEntitlementControl();
                }
            });
            this.renumberPages();
            this.getNextButton().setEnabled(false);
        }
        this.initImportCommon();
        this.importInitializedType = -3;
    }

    private void initImportNewVDB() {
        if (this.importInitializedType != -2) {
            int iPages;
            for (int x = iPages = this.getPageCount(); x > 2; --x) {
                this.removePage(x - 1);
            }
            this.visPanel = new VDBWizardModelVisibilityPanel(1, this);
            this.addPage(this.visPanel);
            this.pnlEditConnBind = new VdbWizardEditConnBindPanel(1, this, this.connection);
            this.addPage(this.pnlEditConnBind);
            boolean hasRoles = true;
            if (this.vdbDefn != null) {
                hasRoles = this.vdbDefn.getDataRoles() != null;
            }
            this.pnlEntitlementsSelect = new VdbWizardEntitlementsSelectPanel(this, 1);
            if (hasRoles) {
                this.addPage(this.pnlEntitlementsSelect);
            }
            this.pnlConfirm = new VdbWizardConfirmPanel(this, 1);
            this.addPage(this.pnlConfirm);
            this.pnlEntitlements = new VdbWizardEntitlementsPanel(null, this, this.connection, 1);
            this.pnlEntitlementsSelect.getViewEntitlementsReportCbx().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    CreateVDBPanel.this.processViewEntitlementControl();
                }
            });
            this.renumberPages();
            this.getNextButton().setEnabled(false);
        }
        this.initImportCommon();
        this.importInitializedType = -2;
    }

    private void initImportCommon() {
        ModelVisibilityInfo[] vInfo = this.convertModelTableRowsToModelVisibilityInfo((VDBInfo)this.vdbDefn);
        if (this.vdbSelectionChanged) {
            this.visPanel.populateTable(vInfo);
            Collection mdls = this.vdbDefn.getModels();
            this.pnlEditConnBind.setVDB((VDBDefn)this.vdbDefn);
            this.pnlEditConnBind.setModels(mdls);
            this.pnlEditConnBind.loadAdditionalBindings();
            this.mapConnBind = null;
        }
        if (this.sourceVirtualDatabase != null) {
            this.pnlEditConnBind.useBindingsFromPreviousVDB();
        }
        if (this.vdbDefn != null && this.pnlEntitlementsSelect != null) {
            this.pnlEntitlementsSelect.setShowVdbRolesImportOptionEnabled(this.vdbDefn.getDataRoles() != null);
        }
    }

    private void setListeners() {
        this.getCancelButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                CreateVDBPanel.this.processCancelButton();
            }
        });
        this.getFinishButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                CreateVDBPanel.this.processFinishButton();
            }
        });
        if (this.pnlEntitlementsSelect != null) {
            this.pnlEntitlementsSelect.getViewEntitlementsReportCbx().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    CreateVDBPanel.this.processViewEntitlementControl();
                }
            });
        }
    }

    private void renumberPages() {
        Component[] thePages = this.getPages();
        for (int i = 0; i < thePages.length; ++i) {
            if (!(thePages[i] instanceof BasicWizardSubpanelContainer)) continue;
            BasicWizardSubpanelContainer bwsc = (BasicWizardSubpanelContainer)thePages[i];
            bwsc.replaceStepNum(i + 1);
        }
    }

    private void processViewEntitlementControl() {
        if (this.pnlEntitlementsSelect.isSelectedViewEntitlementsReport()) {
            this.addPage(this.pnlEntitlements);
        } else {
            this.removePage(this.pnlEntitlements);
        }
        this.renumberPages();
    }

    private void processCancelButton() {
        this.dlgParent.processCancelButton();
    }

    private void processFinishButton() {
        if (!this.attemptedCreatingVDB) {
            try {
                this.createVDB();
            }
            catch (Exception e) {
                LogManager.logError((String)"VIRTUAL_DATABASE", (Throwable)e, (String)"VDB creation failed");
                ExceptionUtility.showMessage("ERROR!  Failed while creating a VDB", e);
            }
        }
        this.dlgParent.processFinishButton();
    }

    public AbstractButton getWizardNextButton() {
        return this.getNextButton();
    }

    public void enableNextButton(boolean b) {
        ButtonWidget btnNext = null;
        btnNext = this.getNextButton();
        if (btnNext != null) {
            btnNext.setEnabled(b);
        } else {
            btnNext = this.getFinishButton();
            if (btnNext != null) {
                btnNext.setEnabled(b);
            }
        }
    }

    public VirtualDatabase getNewVdb() {
        return this.newVirtualDatabase;
    }

    private EntitlementMigrationReport getMigrationReport() {
        return this.emrEntitlementReport;
    }

    private List getNewConnectorBindings() {
        HashMap bindings = new HashMap(this.newVDBDefn.getConnectorBindings());
        for (BindingNameAndExistingUUID bnaeu : this.existingBindingsOnImport.values()) {
            String name = bnaeu.getBindingName();
            bindings.remove(name);
        }
        return new ArrayList(bindings.values());
    }

    private void createMaterializationFiles() {
        try {
            this.validateConnBindForMaterialization();
        }
        catch (Exception ex) {
            // empty catch block
        }
        boolean proceeding = true;
        Exception error = null;
        String connectionPropsFileName = null;
        String createScriptFileName = null;
        String loadScriptFileName = null;
        String swapScriptFileName = null;
        String truncateScriptFileName = null;
        String directory = null;
        try {
            String host = this.getVdbManager().getConnection().getHost();
            String port = this.getVdbManager().getConnection().getPort();
            String loginUserName = this.upPanel.getLoginUserName();
            String loginPassword = this.upPanel.getLoginPassword();
            String dataBaseUserName = this.upPanel.getDataBaseUserName();
            String dataBasePassword = this.upPanel.getDataBasePassword();
            if (this.newVirtualDatabase != null) {
                VirtualDatabaseID id = (VirtualDatabaseID)this.newVirtualDatabase.getID();
                String versStr = id.getVersion();
                this.vdbDefn.setVersion(versStr);
            }
            this.scripts = this.getVdbManager().getMaterializationScripts(this.materializationConnectorBinding, (VDBDefn)this.vdbDefn, host, port, dataBaseUserName, dataBasePassword, loginUserName, loginPassword);
        }
        catch (Exception ex) {
            String msg = "Error obtaining materialization information";
            LogManager.logError((String)"VIRTUAL_DATABASE", (Throwable)ex, (String)msg);
            error = ex;
            proceeding = false;
        }
        if (proceeding) {
            directory = this.savePanel.getDirectoryName();
            if (!directory.endsWith(File.separator)) {
                directory = directory + File.separator;
            }
            connectionPropsFileName = directory + this.scripts.getConnectionPropsFileName();
            InputStream connectionPropsInputStream = this.scripts.getConnectionPropsFileContents();
            File target = new File(connectionPropsFileName);
            proceeding = true;
            if (target.exists()) {
                proceeding = true;
            } else {
                try {
                    target.createNewFile();
                }
                catch (IOException ex) {
                    error = ex;
                    proceeding = false;
                }
            }
            if (proceeding) {
                boolean exported = false;
                if (!target.canWrite()) {
                    StaticUtilities.displayModalDialogWithOK("Cannot write to target file", "Unable to write to target file " + connectionPropsFileName + ".");
                    proceeding = false;
                }
                if (proceeding) {
                    try {
                        FileUtils.write((InputStream)connectionPropsInputStream, (File)target);
                        exported = true;
                    }
                    catch (Exception ex) {
                        LogManager.logError((String)"VIRTUAL_DATABASE", (Throwable)ex, (String)"Error writing connection properties file.");
                        error = ex;
                        proceeding = false;
                    }
                }
                if (exported) {
                    String directoryForModule = this.savePanel.getDirectoryName();
                    UserPreferences.getInstance().setValue("metamatrix.console.materializationdirectory", directoryForModule);
                    UserPreferences.getInstance().saveChanges();
                }
            }
            if (proceeding) {
                createScriptFileName = directory + this.scripts.getCreateScriptFileName();
                InputStream createScriptInputStream = this.scripts.getCreateScriptFile();
                target = new File(createScriptFileName);
                if (target.exists()) {
                    proceeding = true;
                } else {
                    try {
                        target.createNewFile();
                    }
                    catch (IOException ex) {
                        error = ex;
                        proceeding = false;
                    }
                }
                if (proceeding) {
                    if (!target.canWrite()) {
                        StaticUtilities.displayModalDialogWithOK("Cannot write to target file", "Unable to write to target file " + createScriptFileName + ".");
                        proceeding = false;
                    }
                    if (proceeding) {
                        try {
                            FileUtils.write((InputStream)createScriptInputStream, (File)target);
                        }
                        catch (Exception ex) {
                            LogManager.logError((String)"VIRTUAL_DATABASE", (Throwable)ex, (String)"Error writing DDL Script file.");
                            error = ex;
                            proceeding = false;
                        }
                    }
                }
                if (proceeding) {
                    loadScriptFileName = directory + this.scripts.getLoadScriptFileName();
                    InputStream loadScriptInputStream = this.scripts.getLoadScriptFile();
                    target = new File(loadScriptFileName);
                    if (!target.exists()) {
                        try {
                            target.createNewFile();
                        }
                        catch (IOException ex) {
                            error = ex;
                            proceeding = false;
                        }
                    }
                    if (proceeding) {
                        if (!target.canWrite()) {
                            StaticUtilities.displayModalDialogWithOK("Cannot write to target file", "Unable to write to target file " + loadScriptFileName + ".");
                            proceeding = false;
                        }
                        if (proceeding) {
                            try {
                                FileUtils.write((InputStream)loadScriptInputStream, (File)target);
                            }
                            catch (Exception ex) {
                                LogManager.logError((String)"VIRTUAL_DATABASE", (Throwable)ex, (String)"Error writing Load Script file.");
                                error = ex;
                                proceeding = false;
                            }
                        }
                    }
                    if (proceeding) {
                        swapScriptFileName = directory + this.scripts.getSwapScriptFileName();
                        InputStream swapScriptInputStream = this.scripts.getSwapScriptFile();
                        target = new File(swapScriptFileName);
                        if (target.exists()) {
                            proceeding = true;
                        } else {
                            try {
                                target.createNewFile();
                            }
                            catch (IOException ex) {
                                StaticUtilities.displayModalDialogWithOK("Cannot create target file", "Unable to create target file " + swapScriptFileName + ".  Must select another file name or cancel.");
                                proceeding = false;
                            }
                        }
                        if (proceeding) {
                            if (!target.canWrite()) {
                                StaticUtilities.displayModalDialogWithOK("Cannot write to target file", "Unable to write to target file " + swapScriptFileName + ".");
                                proceeding = false;
                            }
                            if (proceeding) {
                                try {
                                    FileUtils.write((InputStream)swapScriptInputStream, (File)target);
                                }
                                catch (Exception ex) {
                                    LogManager.logError((String)"VIRTUAL_DATABASE", (Throwable)ex, (String)"Error writing Load Script file.");
                                    error = ex;
                                    proceeding = false;
                                }
                            }
                        }
                        if (proceeding) {
                            truncateScriptFileName = directory + this.scripts.getTruncateScriptFileName();
                            InputStream truncateScriptInputStream = this.scripts.getTruncateScriptFile();
                            target = new File(truncateScriptFileName);
                            if (target.exists()) {
                                proceeding = true;
                            } else {
                                try {
                                    target.createNewFile();
                                }
                                catch (IOException ex) {
                                    StaticUtilities.displayModalDialogWithOK("Cannot create target file", "Unable to create target file " + truncateScriptFileName + ".  Must select another file name or cancel.");
                                    proceeding = false;
                                }
                            }
                            if (proceeding) {
                                if (!target.canWrite()) {
                                    StaticUtilities.displayModalDialogWithOK("Cannot write to target file", "Unable to write to target file " + truncateScriptFileName + ".");
                                    proceeding = false;
                                }
                                if (proceeding) {
                                    try {
                                        FileUtils.write((InputStream)truncateScriptInputStream, (File)target);
                                    }
                                    catch (Exception ex) {
                                        LogManager.logError((String)"VIRTUAL_DATABASE", (Throwable)ex, (String)"Error writing Truncate Script file.");
                                        error = ex;
                                        proceeding = false;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        Object materializationFileCreationResult = null;
        if (error != null) {
            materializationFileCreationResult = error;
        } else {
            SingleMaterializationFileDisplayInfo[] files = new SingleMaterializationFileDisplayInfo[]{new SingleMaterializationFileDisplayInfo(CONNECTION_PROPERTIES_FILE_DESC, this.scripts.getConnectionPropsFileName()), new SingleMaterializationFileDisplayInfo(CREATE_SCRIPT_FILE_DESC, this.scripts.getCreateScriptFileName()), new SingleMaterializationFileDisplayInfo(LOAD_SCRIPT_FILE_DESC, this.scripts.getLoadScriptFileName()), new SingleMaterializationFileDisplayInfo(SWAP_SCRIPT_FILE_DESC, this.scripts.getSwapScriptFileName()), new SingleMaterializationFileDisplayInfo(TRUNCATE_SCRIPT_FILE_DESC, this.scripts.getTruncateScriptFileName())};
            AllMaterializationFilesDisplayInfo allFiles = new AllMaterializationFilesDisplayInfo(directory, files);
            materializationFileCreationResult = allFiles;
        }
        this.matFilesPanel.setResults(materializationFileCreationResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createVDB() throws Exception {
        this.attemptedCreatingVDB = true;
        if (this.sVdbName == null || this.sVdbName.equals("")) {
            ExceptionUtility.showMessage("ERROR!  could not create vdb because name is missing", new Exception("VDB Name Must Be Specified"));
        } else {
            Map visMap = CreateVDBPanel.modelVisibilityMap(this.visInfo);
            Map multiSourceMap = CreateVDBPanel.modelMultiSourceMap(this.visInfo);
            try {
                this.newVDBDefn = this.createDEF(this.vdbDefn, this.sVdbName, visMap, this.reviseMapForExistingUUIDSubstitution(this.mapConnBind, this.existingBindingsOnImport), multiSourceMap, this.pnlConfirm.getStatus(), this.getConnectorManager().getAllConnectorBindings());
                boolean importRoles = true;
                if (this.creatingNewVDBVersion) {
                    importRoles = this.pnlEntitlementsSelect.isSelectedImportEntitlementsFromVdb();
                }
                if (this.importing) {
                    importRoles = this.pnlEntitlementsSelect.isSelectedImportEntitlementsFromVdb();
                }
                VDBArchive vdbArchive = null;
                Object[] results = null;
                try {
                    vdbArchive = new VDBArchive(this.newVDBDefn.getVDBStream().getInputStream());
                    vdbArchive.updateConfigurationDef((BasicVDBDefn)this.newVDBDefn);
                    vdbArchive.setStatus(this.pnlConfirm.getStatus());
                    results = this.getVdbManager().importVDB(vdbArchive, importRoles);
                }
                finally {
                    if (vdbArchive != null) {
                        vdbArchive.close();
                    }
                }
                this.newVirtualDatabase = (VirtualDatabase)results[0];
                this.emrEntitlementReport = (EntitlementMigrationReport)results[1];
                boolean decryptable = true;
                List bindings = this.getNewConnectorBindings();
                decryptable = this.getConfigurationManager().checkDecryptable(bindings);
                try {
                    if (decryptable && this.pnlConfirm.isSyncActive()) {
                        this.getRuntimeMgmtManager().synchronizeServer();
                    }
                }
                catch (Exception e) {
                    LogManager.logError((String)"VIRTUAL_DATABASE", (Throwable)e, (String)"Synchronize failed");
                    ExceptionUtility.showMessage("ERROR!  Synchronize Failed", e);
                }
                if (this.creatingNewVDBVersion) {
                    try {
                        if (this.pnlEntitlementsSelect.isSelectedMigrateEntitlements()) {
                            this.emrEntitlementReport = this.getVdbManager().migrateEntitlements(this.sourceVirtualDatabase, this.newVirtualDatabase);
                            WorkspaceController.getInstance().handleUpdateNotification(this.getVdbManager().getConnection(), new DataEntitlementChangeNotification());
                        }
                    }
                    catch (Exception e) {
                        LogManager.logError((String)"VIRTUAL_DATABASE", (Throwable)e, (String)"Migrating roles failed");
                        ExceptionUtility.showMessage("ERROR!  Migrate Roles Failed", e);
                    }
                    this.newVirtualDatabase = this.getVdbManager().getVirtualDatabase((VirtualDatabaseID)this.newVirtualDatabase.getID());
                }
                if (importRoles) {
                    WorkspaceController.getInstance().handleUpdateNotification(this.getVdbManager().getConnection(), new DataEntitlementChangeNotification());
                }
                this.getConfigurationManager().refresh();
            }
            catch (Exception e) {
                ExceptionUtility.showMessage("ERROR!  VDB Not created", e.getMessage(), e);
            }
            if (this.materializationTableModel != null) {
                this.createMaterializationFiles();
            }
        }
    }

    private VDBDefn createDEF(BasicVDBDefn entry, String newName, Map visibilities, Map modelsToBindings, Map multiSourceEnabled, short status, Collection configbindings) throws Exception {
        Assertion.isNotNull((Object)entry, (String)"RMCVersionEntry must not be null");
        Assertion.isNotNull((Object)newName, (String)"Name for the new VDB must not be null");
        Assertion.isNotNull((Object)visibilities, (String)"Visibilities for models in new VDB must not be null");
        HashMap<String, ConnectorBinding> uuidsToConfigBindings = new HashMap<String, ConnectorBinding>(configbindings.size());
        for (ConnectorBinding cb : configbindings) {
            uuidsToConfigBindings.put(cb.getRoutingUUID(), cb);
        }
        Collection models = entry.getModels();
        for (BasicModelInfo mdefn : models) {
            Object s;
            Object o = visibilities.get(mdefn.getName());
            if (o instanceof Short) {
                s = (Short)o;
                mdefn.setVisibility(((Short)s).shortValue());
            } else {
                s = (String)o;
                if (((String)s).equalsIgnoreCase("Public")) {
                    mdefn.setIsVisible(true);
                } else {
                    mdefn.setIsVisible(false);
                }
            }
            if (modelsToBindings != null && modelsToBindings.containsKey(mdefn.getName())) {
                List bindings = (List)modelsToBindings.get(mdefn.getName());
                ArrayList<String> names = new ArrayList<String>(bindings.size());
                for (String uuid : bindings) {
                    ConnectorBinding cb = (ConnectorBinding)uuidsToConfigBindings.get(uuid);
                    if (cb == null) {
                        cb = entry.getConnectorBindingByRouting(uuid);
                    }
                    if (cb == null) continue;
                    names.add(cb.getFullName());
                }
                mdefn.setConnectorBindingNames(names);
            }
            if (multiSourceEnabled == null || !multiSourceEnabled.containsKey(mdefn.getName())) continue;
            Boolean enabled = (Boolean)multiSourceEnabled.get(mdefn.getName());
            mdefn.enableMutliSourceBindings(enabled.booleanValue());
        }
        entry.removeUnmappedBindings();
        entry.setModelInfos(models);
        entry.setStatus(status);
        entry.setName(newName);
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void showNextPage() {
        try {
            StaticUtilities.startWait(this.dlgParent.getContentPane());
            JPanel pnlCurrPage = (JPanel)this.getCurrentPage();
            boolean proceeding = true;
            if (pnlCurrPage.equals(this.selectorPanel)) {
                proceeding = this.navigateFromSelectorPanel();
            } else if (pnlCurrPage.equals(this.pnlID)) {
                proceeding = this.navigateFromIDPanel();
            } else if (pnlCurrPage.equals(this.visPanel)) {
                proceeding = this.navigateFromVisibilityPanel();
            } else if (pnlCurrPage.equals(this.pnlEditConnBind)) {
                proceeding = this.navigateFromEditConnectorBindingsPanel();
            } else if (pnlCurrPage.equals(this.upPanel)) {
                proceeding = this.navigateFromUserPasswordPanel();
            } else if (pnlCurrPage.equals(this.savePanel)) {
                proceeding = this.navigateFromSavePanel();
            } else if (pnlCurrPage.equals(this.pnlEntitlementsSelect)) {
                proceeding = this.navigateFromEntitlementsSelectPanel();
            } else if (pnlCurrPage.equals(this.pnlConfirm)) {
                proceeding = this.navigateFromConfirmPanel();
            }
            if (!proceeding) {
                return;
            }
        }
        catch (Exception e) {
            ExceptionUtility.showMessage("ERROR!  failed navigating the wizard", e);
        }
        finally {
            StaticUtilities.endWait(this.dlgParent.getContentPane());
        }
        super.showNextPage();
    }

    private boolean navigateFromSelectorPanel() throws Exception {
        boolean result = this.checkSelectorPanelResults();
        if (!result) {
            return false;
        }
        this.pnlID.setVdbName(this.vdbDefn.getName());
        this.pnlID.setDescription(this.vdbDefn.getDescription());
        this.pnlID.putDataIntoPanel();
        boolean proceeding = true;
        proceeding = this.findExistingBindings(true);
        if (!proceeding) {
            this.processCancelButton();
        }
        return true;
    }

    private boolean findExistingBindings(boolean promptWhenDuplicates) {
        this.existingBindingsOnImport = null;
        try {
            this.existingBindingsOnImport = this.getExistingBindingUUIDsForVDB((VDBDefn)this.vdbDefn);
        }
        catch (Exception ex) {
            String msg = "Error retrieving existing connector bindings.";
            LogManager.logError((String)"VIRTUAL_DATABASE", (Throwable)ex, (String)msg);
            ExceptionUtility.showMessage(msg, ex);
        }
        if (this.existingBindingsOnImport != null && this.existingBindingsOnImport.size() > 0) {
            String[] bindingNames = new String[this.existingBindingsOnImport.size()];
            Iterator ib = this.existingBindingsOnImport.entrySet().iterator();
            int i = 0;
            while (ib.hasNext()) {
                Map.Entry me = ib.next();
                BindingNameAndExistingUUID item = (BindingNameAndExistingUUID)me.getValue();
                bindingNames[i] = item.getBindingName();
                ++i;
            }
            if (promptWhenDuplicates) {
                BindingsAlreadyExistDlg dlg = new BindingsAlreadyExistDlg((Frame)ConsoleMainFrame.getInstance(), bindingNames);
                dlg.show();
                return dlg.proceeding();
            }
        }
        return true;
    }

    private boolean navigateFromIDPanel() {
        this.pnlID.getDataFromPanel();
        this.sVdbName = this.pnlID.getVdbName();
        this.sDescription = this.pnlID.getDescription();
        this.vdbDefn.setDescription(this.sDescription);
        if (this.importing) {
            this.sourceVirtualDatabase = this.getLatestVDB(this.sVdbName);
            boolean bl = this.creatingNewVDBVersion = this.sourceVirtualDatabase != null;
            if (this.creatingNewVDBVersion) {
                this.initImportNewVersion();
            } else {
                this.initImportNewVDB();
            }
        } else {
            this.initImportCommon();
        }
        return true;
    }

    private boolean navigateFromVisibilityPanel() {
        this.visInfo = this.visPanel.getUpdatedVisibilityInfo();
        this.pnlEditConnBind.updateMultiSource(CreateVDBPanel.modelMultiSourceMap(this.visInfo));
        this.pnlEditConnBind.updateSelectionForModelsTable();
        return true;
    }

    private boolean navigateFromEditConnectorBindingsPanel() {
        String modelName;
        boolean proceeding = true;
        this.materializationTableModel = this.getVdbManager().getMaterializationTableModel((VDBDefn)this.vdbDefn);
        if (this.materializationTableModel != null && !this.pnlEditConnBind.hasBindingAssigned(modelName = this.materializationTableModel.getName())) {
            proceeding = false;
            String hdr = "Materialization model connector binding needed";
            String msg = "Must assign connector binding to materialization model " + modelName + " before proceeding.";
            StaticUtilities.displayModalDialogWithOK(hdr, msg, 2);
        }
        if (proceeding) {
            this.mapConnBind = this.pnlEditConnBind.getModelsToConnBindsMap();
            this.siStatus = this.determinePotentialVdbsStatus(this.mapConnBind);
            this.pnlConfirm.setVdbName(this.sVdbName);
            this.pnlConfirm.setStatus(this.siStatus);
            if (this.pnlEntitlementsSelect != null) {
                this.pnlEntitlementsSelect.setVdbName(this.sVdbName);
                this.pnlEntitlementsSelect.setStatus(this.siStatus);
                this.pnlEntitlementsSelect.putDataIntoPanel();
                this.pnlConfirm.setMigrateEntitlementsRequested(this.pnlEntitlementsSelect.isSelectedMigrateEntitlements());
            } else {
                this.pnlConfirm.setMigrateEntitlementsRequested(false);
            }
            this.pnlConfirm.putDataIntoPanel();
            if (this.materializationTableModel != null) {
                try {
                    this.validateConnBindForMaterialization();
                }
                catch (Exception ex) {
                    LogManager.logError((String)"VIRTUAL_DATABASE", (Throwable)ex, (String)"Error validating materialization connector binding.");
                    ExceptionUtility.showMessage("Error validating materialization connector binding", ex);
                    return false;
                }
                if (this.upPanel == null) {
                    this.upPanel = new VdbWizardUserAndPasswordPanel(this, 1);
                }
                if (this.savePanel == null) {
                    String initialDirectory = (String)UserPreferences.getInstance().getValue("metamatrix.console.materializationdirectory");
                    this.savePanel = new VdbWizardSaveMaterializationFilesPanel(this, 1, initialDirectory);
                }
                if (this.matFilesPanel == null) {
                    this.matFilesPanel = new VdbWizardWrittenMaterializationFilesPanel(this, 1, true);
                }
                this.removePage(this.upPanel);
                this.removePage(this.savePanel);
                if (this.pnlEntitlementsSelect != null) {
                    this.removePage(this.pnlEntitlementsSelect);
                }
                this.removePage(this.pnlConfirm);
                this.removePage(this.matFilesPanel);
                this.addPage(this.upPanel);
                this.addPage(this.savePanel);
                if (this.pnlEntitlementsSelect != null) {
                    this.addPage(this.pnlEntitlementsSelect);
                }
                this.addPage(this.pnlConfirm);
                this.addPage(this.matFilesPanel);
                this.renumberPages();
                this.getForwardButton().setEnabled(false);
            } else {
                if (this.upPanel != null) {
                    this.removePage(this.upPanel);
                }
                if (this.savePanel != null) {
                    this.removePage(this.savePanel);
                }
                if (this.matFilesPanel != null) {
                    this.removePage(this.matFilesPanel);
                }
                this.renumberPages();
            }
        }
        return proceeding;
    }

    private boolean navigateFromUserPasswordPanel() {
        return true;
    }

    private boolean navigateFromSavePanel() {
        this.getForwardButton().setEnabled(false);
        return true;
    }

    private boolean navigateFromEntitlementsSelectPanel() {
        this.pnlConfirm.setVdbName(this.sVdbName);
        this.pnlConfirm.setStatus(this.siStatus);
        this.pnlConfirm.setMigrateEntitlementsRequested(this.pnlEntitlementsSelect.isSelectedMigrateEntitlements());
        this.pnlConfirm.putDataIntoPanel();
        return true;
    }

    private boolean navigateFromConfirmPanel() {
        try {
            this.createVDB();
        }
        catch (Exception e) {
            LogManager.logError((String)"VIRTUAL_DATABASE", (Throwable)e, (String)"VDB creation failed");
            ExceptionUtility.showMessage("ERROR!  Failed while creating a VDB", e);
        }
        if (this.pnlEntitlements != null) {
            this.pnlEntitlements.setNewVdb(this.getNewVdb());
            this.pnlEntitlements.setEntitlementMigrationReport(this.getMigrationReport());
        }
        this.getBackButton().setVisible(false);
        this.getCancelButton().setVisible(false);
        return true;
    }

    @Override
    public void showPreviousPage() {
        super.showPreviousPage();
        this.enableNextButton(true);
    }

    private Map getExistingBindingUUIDsForVDB(VDBDefn rve) throws Exception {
        HashMap<String, BindingNameAndExistingUUID> existingBindingsInVDB = new HashMap<String, BindingNameAndExistingUUID>();
        for (Map.Entry me : rve.getConnectorBindings().entrySet()) {
            String bindingName = (String)me.getKey();
            ConnectorBinding cb = this.getConnectorManager().getConnectorBindingByName(bindingName);
            if (cb == null) continue;
            String uuid = cb.getRoutingUUID();
            ConnectorBinding cbFromImport = (ConnectorBinding)me.getValue();
            String uuidOnImport = cbFromImport.getRoutingUUID();
            BindingNameAndExistingUUID item = new BindingNameAndExistingUUID(bindingName, uuid);
            existingBindingsInVDB.put(uuidOnImport, item);
        }
        return existingBindingsInVDB;
    }

    private Map reviseMapForExistingUUIDSubstitution(Map fromImport, Map existing) {
        HashMap outputMap;
        if (existing == null || existing.size() == 0) {
            outputMap = fromImport;
        } else {
            outputMap = new HashMap();
            for (Map.Entry me : fromImport.entrySet()) {
                String modelName = (String)me.getKey();
                List bindingUUIDsOnImport = (List)me.getValue();
                ArrayList<String> newList = new ArrayList<String>(bindingUUIDsOnImport.size());
                for (String uuidFromImport : bindingUUIDsOnImport) {
                    String uuidToUse = null;
                    BindingNameAndExistingUUID replacement = (BindingNameAndExistingUUID)existing.get(uuidFromImport);
                    uuidToUse = replacement == null ? uuidFromImport : replacement.getExistingUUID();
                    newList.add(uuidToUse);
                }
                outputMap.put(modelName, newList);
            }
        }
        return outputMap;
    }

    public boolean checkSelectorPanelResults() {
        boolean goingToNextPage = true;
        String fileName = this.selectorPanel.getSelectedFileFullName();
        this.vdbSelectionChanged = !fileName.equals(this.oldVDBPath);
        this.oldVDBPath = fileName;
        File file = new File(fileName);
        if (!file.exists()) {
            StaticUtilities.displayModalDialogWithOK("Unable to open file", "Unable to open file " + fileName + ".  Must select " + "a different file or cancel.");
            goingToNextPage = false;
        } else if (!file.canRead()) {
            StaticUtilities.displayModalDialogWithOK("Unable to read file", "Unable to open file " + fileName + ".  Must select " + "a different file or cancel.");
            goingToNextPage = false;
        } else {
            try {
                String vdbDirectoryName = this.selectorPanel.getDirectoryName();
                String vdbFileName = this.selectorPanel.getSelectedFileName();
                UserPreferences.getInstance().setValue("metamatrix.console.directory", vdbDirectoryName);
                UserPreferences.getInstance().saveChanges();
                String vdbF = vdbFileName.toLowerCase();
                if (vdbF.endsWith(VDB_IMPORT_EXTENSIONS[1])) {
                    goingToNextPage = this.importVDB(file, vdbFileName);
                } else if (vdbF.endsWith(VDB_IMPORT_EXTENSIONS[0])) {
                    goingToNextPage = this.importDefinition(vdbFileName, vdbDirectoryName);
                } else {
                    StaticUtilities.displayModalDialogWithOK("Selection Error", "File selected must be of VDB Import Types (*.def, *.vdb)");
                    goingToNextPage = false;
                }
            }
            catch (VirtualDatabaseException vex) {
                StaticUtilities.displayModalDialogWithOK("VDB Exceptions", vex.getMessage());
                String msg1 = "Unable to import VDB.";
                String msg2 = "File " + fileName + " may not contain a VDB in the correct format, " + "or VDB definition file may be missing.  See details.";
                ExceptionUtility.showMessage(msg1, msg2, vex);
                goingToNextPage = false;
            }
            catch (Exception ex) {
                String msg1 = "Unable to complete VDB Creation.";
                String msg2 = "File " + fileName + " may not contain a VDB in the correct format, " + "or VDB definition file may be missing.  See details.";
                ExceptionUtility.showMessage(msg1, msg2, ex);
                goingToNextPage = false;
            }
        }
        return goingToNextPage;
    }

    private boolean validateConnBindForMaterialization() throws Exception {
        String modelName = this.materializationTableModel.getName();
        Map map = this.pnlEditConnBind.getModelsToConnBindsMap();
        this.materializationConnectorBinding = null;
        List uuids = (List)map.get(modelName);
        if (uuids != null && uuids.size() > 0) {
            String uuid = (String)uuids.get(0);
            String connBindingName = (String)this.getConnectorManager().getUUIDConnectorBindingsMap(false).get(uuid);
            this.materializationConnectorBinding = this.getConnectorManager().getConnectorBindingByName(connBindingName);
        }
        return this.getRuntimeMetadataAdminAPI().validateConnectorBindingForMaterialization(this.materializationConnectorBinding);
    }

    private VirtualDatabase getLatestVDB(String vdbName) {
        try {
            VirtualDatabase vdb = this.getVdbManager().getLatestVDBVersion(vdbName);
            return vdb;
        }
        catch (VirtualDatabaseDoesNotExistException dne) {
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String msg = "An error occurred retrieving VDB version information";
            LogManager.logError((String)"Information Retrieval Error", (Throwable)ex, (String)msg);
            ExceptionUtility.showMessage(msg, ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean importVDB(File file, String newVDBName) throws Exception {
        VDBArchive vdb = null;
        try {
            vdb = new VDBArchive(file);
            vdb.setName(newVDBName);
            this.vdbDefn = vdb.getConfigurationDef();
            this.vdbDefn.setVDBStream((VDBStream)new VDBStreamImpl(file));
            if (vdb.getVDBValidityErrors() != null) {
                StaticUtilities.displayModalDialogWithOK("VDB.DEF Processing Error", "VDB " + vdb.getName() + " is at a nondeployable severity state of " + VDBStatus.VDB_STATUS_NAMES[vdb.getStatus()]);
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (vdb != null) {
                vdb.close();
            }
        }
    }

    protected boolean importDefinition(String fileName, String directory) throws Exception {
        if (fileName == null || directory == null) {
            StaticUtilities.displayModalDialogWithOK("VDB.DEF Processing Error", "VDB File name or the directory was not able to be obtained from selected file.");
            return false;
        }
        this.vdbDefn = VDBArchive.readFromDef((InputStream)new FileInputStream(new File(directory, fileName)));
        if (this.vdbDefn.doesVDBHaveValidityError()) {
            StaticUtilities.displayModalDialogWithOK("VDB.DEF Processing Error", "VDB " + this.vdbDefn.getName() + " is at a nondeployable severity state of " + VDBStatus.VDB_STATUS_NAMES[this.vdbDefn.getStatus()]);
            return false;
        }
        return true;
    }

    private ModelVisibilityInfo[] convertModelTableRowsToModelVisibilityInfo(VDBInfo info) {
        ModelVisibilityInfo[] visInfo = null;
        Collection mdls = info.getModels();
        int numRows = mdls.size();
        visInfo = new ModelVisibilityInfo[numRows];
        int i = 0;
        for (ModelInfo me : mdls) {
            int numBindings = me.getConnectorBindingNames().size();
            boolean multipleSourceEditable = me.supportsMultiSourceBindings() && numBindings <= 1;
            visInfo[i] = new ModelVisibilityInfo(me.getName(), me.getModelTypeName(), me.isVisible(), me.supportsMultiSourceBindings(), multipleSourceEditable, me.isMultiSourceBindingEnabled());
            ++i;
        }
        return visInfo;
    }

    private short determinePotentialVdbsStatus(Map mapConnBind) {
        short siStatus = 0;
        boolean bHasMissingValues = false;
        boolean bHasNoBindings = false;
        boolean requiresBindings = false;
        for (ModelInfo mi : this.vdbDefn.getModels()) {
            if (!mi.requiresConnectorBinding()) continue;
            requiresBindings = true;
            break;
        }
        if (!requiresBindings) {
            return 2;
        }
        int connBind = 0;
        for (List list : mapConnBind.values()) {
            if (list == null || list.size() == 0) {
                bHasMissingValues = true;
                continue;
            }
            connBind += list.size();
        }
        if (connBind == 0) {
            bHasNoBindings = true;
        }
        siStatus = bHasNoBindings || bHasMissingValues ? (short)1 : 2;
        return siStatus;
    }
}

