/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.vdb;

import com.metamatrix.console.ui.layout.ConsoleMainFrame;
import com.metamatrix.console.util.StaticUtilities;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

class DeleteConfirmationDialogForVDBWithEntitlements
extends JDialog {
    private boolean yesPressed = false;
    private JScrollPane entScrollPane;
    private JPanel entPanel;

    public DeleteConfirmationDialogForVDBWithEntitlements(String vdbName, int vdbVersion, List entitlements) {
        super(ConsoleMainFrame.getInstance(), "Confirm Deletion", true);
        this.doLayoutStuff(vdbName, vdbVersion, entitlements);
        this.pack();
        Dimension curSize = this.getSize();
        Dimension newSize = new Dimension(curSize.width, Math.min(curSize.height, (int)((double)Toolkit.getDefaultToolkit().getScreenSize().height * 0.4)));
        this.setSize(newSize);
        this.entScrollPane.getVerticalScrollBar().setUnitIncrement(this.entPanel.getHeight() / entitlements.size());
        this.setLocation(StaticUtilities.centerFrame(this.getSize()));
    }

    public boolean confirmed() {
        return this.yesPressed;
    }

    private void doLayoutStuff(String vdbName, int vdbVersion, List entitlements) {
        GridBagLayout layout = new GridBagLayout();
        this.getContentPane().setLayout(layout);
        JLabel topLabel = new JLabel("Delete VDB " + vdbName + ", Version " + vdbVersion + "?");
        JLabel entLabel = new JLabel("Deleting will cause deletion of the following roles for VDB " + vdbName + ", Version " + vdbVersion + ":");
        int numEntitlements = entitlements.size();
        this.entPanel = new JPanel(new GridLayout(numEntitlements, 1));
        for (String entName : entitlements) {
            this.entPanel.add(new JLabel(entName));
        }
        this.entScrollPane = new JScrollPane(this.entPanel);
        JLabel bottomLabel = new JLabel("Proceed with deletion?");
        JButton yesButton = new JButton("  Yes  ");
        yesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                DeleteConfirmationDialogForVDBWithEntitlements.this.yesButtonPressed();
            }
        });
        JButton noButton = new JButton("No");
        noButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                DeleteConfirmationDialogForVDBWithEntitlements.this.noButtonPressed();
            }
        });
        JPanel buttonsPanel = new JPanel(new GridLayout(1, 2, 10, 0));
        buttonsPanel.add(yesButton);
        buttonsPanel.add(noButton);
        this.getContentPane().add(topLabel);
        this.getContentPane().add(entLabel);
        this.getContentPane().add(this.entScrollPane);
        this.getContentPane().add(bottomLabel);
        this.getContentPane().add(buttonsPanel);
        layout.setConstraints(topLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 20, 5, 20), 0, 0));
        layout.setConstraints(entLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 20, 5, 20), 0, 0));
        layout.setConstraints(this.entScrollPane, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 30, 10, 30), 0, 0));
        layout.setConstraints(bottomLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 20, 5, 20), 0, 0));
        layout.setConstraints(buttonsPanel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 20, 10, 20), 0, 0));
    }

    private void yesButtonPressed() {
        this.yesPressed = true;
        this.dispose();
    }

    private void noButtonPressed() {
        this.dispose();
    }
}

