/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.vdb;

import com.metamatrix.console.ui.views.entitlements.DataNodePermissions;
import com.metamatrix.console.ui.views.vdb.DetailTableModel;
import com.metamatrix.console.ui.views.vdb.EntitlementMigrationDetailInfo;
import com.metamatrix.toolbox.ui.widget.TableWidget;
import com.metamatrix.toolbox.ui.widget.table.DefaultTableModel;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class EntitlementMigrationDetailPanel
extends JPanel {
    public static final int NODE_COLUMN_NUM = 0;
    public static final int RESULT_COLUMN_NUM = 1;
    public static final int CREATE_COLUMN_NUM = 2;
    public static final int READ_COLUMN_NUM = 3;
    public static final int UPDATE_COLUMN_NUM = 4;
    public static final int DELETE_COLUMN_NUM = 5;
    private EntitlementMigrationDetailInfo[] details;
    private JButton saveButton = new JButton("Save to File");
    private JButton cancelButton;
    private TableWidget table;

    public EntitlementMigrationDetailPanel(EntitlementMigrationDetailInfo[] det, boolean showCancelButton) {
        this.details = det;
        this.init(showCancelButton);
    }

    private void init(boolean showCancelButton) {
        Vector<String> columns = new Vector<String>(Arrays.asList("Node", "Result", "Create", "Read", "Update", "Delete"));
        DetailTableModel tableModel = new DetailTableModel(columns);
        this.table = new TableWidget(tableModel);
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        JScrollPane tableSP = new JScrollPane(this.table);
        this.add(tableSP);
        layout.setConstraints(tableSP, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                EntitlementMigrationDetailPanel.this.savePressed();
            }
        });
        layout.setConstraints(this.saveButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 10), 0, 0));
        if (showCancelButton) {
            JPanel buttonsPanel = new JPanel();
            this.add(buttonsPanel);
            layout.setConstraints(buttonsPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            buttonsPanel.setLayout(new FlowLayout());
            buttonsPanel.add(this.saveButton);
            this.cancelButton = new JButton("Cancel");
            buttonsPanel.add(this.cancelButton);
        } else {
            this.add(this.saveButton);
            layout.setConstraints(this.saveButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        }
        this.insertData();
    }

    public AbstractButton getCancelButton() {
        return this.cancelButton;
    }

    private void insertData() {
        for (int i = 0; i < this.details.length; ++i) {
            Vector<Object> rowData = new Vector<Object>();
            rowData.add(this.details[i].getNodeName());
            switch (this.details[i].getMigrationResult()) {
                case 1: {
                    rowData.add("Matched");
                    break;
                }
                case 2: {
                    rowData.add("Dropped");
                    break;
                }
                case 3: {
                    rowData.add("New");
                    break;
                }
                default: {
                    throw new RuntimeException("Illegal value of " + this.details[i].getMigrationResult() + " for migration result in EntitlementMigrationDetailPanel");
                }
            }
            boolean create = this.details[i].getPermissions().hasCreate();
            rowData.add(new Boolean(create));
            boolean read = this.details[i].getPermissions().hasRead();
            rowData.add(new Boolean(read));
            boolean update = this.details[i].getPermissions().hasUpdate();
            rowData.add(new Boolean(update));
            boolean delete = this.details[i].getPermissions().hasDelete();
            rowData.add(new Boolean(delete));
            ((DefaultTableModel)this.table.getModel()).addRow(rowData);
        }
    }

    private void savePressed() {
    }

    public static EntitlementMigrationDetailInfo[] getMigrationData() {
        EntitlementMigrationDetailInfo[] info = new EntitlementMigrationDetailInfo[]{new EntitlementMigrationDetailInfo("TableA", 1, new DataNodePermissions(false, true, false, false)), new EntitlementMigrationDetailInfo("TableA.column1", 2, new DataNodePermissions(false, false, false, false)), new EntitlementMigrationDetailInfo("TableA.column2", 2, new DataNodePermissions(false, false, false, false)), new EntitlementMigrationDetailInfo("TableA.column3", 1, new DataNodePermissions(true, true, true, true)), new EntitlementMigrationDetailInfo("TableA.column4", 1, new DataNodePermissions(false, true, false, false)), new EntitlementMigrationDetailInfo("TableA.column5", 1, new DataNodePermissions(false, true, false, false)), new EntitlementMigrationDetailInfo("TableA.column6", 1, new DataNodePermissions(false, true, false, false)), new EntitlementMigrationDetailInfo("TableA.column7", 1, new DataNodePermissions(false, true, false, false)), new EntitlementMigrationDetailInfo("TableB.column1", 3, new DataNodePermissions(true, true, true, true)), new EntitlementMigrationDetailInfo("TableB.column2", 3, new DataNodePermissions(true, true, true, true))};
        return info;
    }
}

