/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.vdb;

import com.metamatrix.console.ui.util.ActionFireableButtonWidget;
import com.metamatrix.console.ui.views.vdb.DetailButtonActionListener;
import com.metamatrix.console.ui.views.vdb.EntitlementMigrationDetailInfo;
import com.metamatrix.console.ui.views.vdb.EntitlementMigrationDetailPanel;
import com.metamatrix.console.ui.views.vdb.EntitlementMigrationInfoSource;
import com.metamatrix.console.ui.views.vdb.EntitlementMigrationSummaryInfo;
import com.metamatrix.console.ui.views.vdb.MigrationSummaryTableWidget;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.toolbox.ui.widget.table.DefaultTableModel;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class EntitlementMigrationReportSummaryPanel
extends JPanel {
    public static final int NAME_COLUMN_NUM = 0;
    public static final int MATCHED_COLUMN_NUM = 1;
    public static final int DROPPED_COLUMN_NUM = 2;
    public static final int NEW_COLUMN_NUM = 3;
    public static final int DETAILS_COLUMN_NUM = 4;
    private ActionFireableButtonWidget[] detailButtons;
    private JButton saveButton;
    private EntitlementMigrationSummaryInfo[] summaryInfo;
    private JTable table;
    private EntitlementMigrationInfoSource infoSource;
    private String sourceVDB;
    private int sourceVDBVersion;
    private String targetVDB;
    private int targetVDBVersion;

    public EntitlementMigrationReportSummaryPanel(EntitlementMigrationSummaryInfo[] info, EntitlementMigrationInfoSource source, String sVDB, int sVDBVersion, String tVDB, int tVDBVersion) {
        this.summaryInfo = info;
        this.infoSource = source;
        this.sourceVDB = sVDB;
        this.sourceVDBVersion = sVDBVersion;
        this.targetVDB = tVDB;
        this.targetVDBVersion = tVDBVersion;
        this.init();
    }

    private void init() {
        DefaultTableModel model = new DefaultTableModel((Vector)new Vector<String>(Arrays.asList("Role Name", "# Matched", "# Dropped", "# New", "")), 0);
        this.table = new MigrationSummaryTableWidget(this, model);
        JScrollPane tableSP = new JScrollPane(this.table);
        this.add(tableSP);
        this.saveButton = new JButton("Save All Details to File");
        this.add(this.saveButton);
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        layout.setConstraints(tableSP, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        layout.setConstraints(this.saveButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 5, 10), 0, 0));
        this.insertData();
    }

    private void insertData() {
        this.detailButtons = new ActionFireableButtonWidget[this.summaryInfo.length];
        for (int i = 0; i < this.summaryInfo.length; ++i) {
            Vector<Object> v = new Vector<Object>(5);
            v.add(this.summaryInfo[i].getEntitlementName());
            v.add(new Integer(this.summaryInfo[i].getNumMatched()));
            v.add(new Integer(this.summaryInfo[i].getNumDropped()));
            v.add(new Integer(this.summaryInfo[i].getNumNew()));
            this.detailButtons[i] = new ActionFireableButtonWidget("Details");
            v.add(this.detailButtons[i]);
            this.detailButtons[i].addActionListener(new DetailButtonActionListener(this, i));
            ((DefaultTableModel)this.table.getModel()).addRow(v);
        }
    }

    public void detailsRequestedForEntitlement(int subscript) {
        String entName = this.summaryInfo[subscript].getEntitlementName();
        EntitlementMigrationDetailInfo[] details = null;
        boolean continuing = true;
        try {
            details = this.infoSource.getDetails(this.sourceVDB, this.sourceVDBVersion, this.targetVDB, this.targetVDBVersion, entName);
        }
        catch (Exception ex) {
            continuing = false;
            ExceptionUtility.showMessage("Get Role Migration Details", ex);
        }
        if (continuing) {
            final JDialog detailsDialog = new JDialog();
            detailsDialog.setModal(true);
            EntitlementMigrationDetailPanel detPanel = new EntitlementMigrationDetailPanel(details, true);
            detailsDialog.getContentPane().add(detPanel);
            detailsDialog.pack();
            detailsDialog.setTitle("Migration Details for Role " + entName);
            detailsDialog.setLocation(StaticUtilities.centerFrame(detailsDialog.getSize()));
            detPanel.getCancelButton().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    detailsDialog.dispose();
                }
            });
            detailsDialog.show();
        }
    }

    public ActionFireableButtonWidget getDetailButtonAt(int index) {
        return this.detailButtons[index];
    }
}

