/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.vdb;

import com.metamatrix.common.tree.TreeNode;
import com.metamatrix.common.tree.directory.DirectoryEntry;
import com.metamatrix.common.tree.directory.DirectoryEntryFilter;
import com.metamatrix.common.tree.directory.DirectoryEntryView;
import com.metamatrix.common.tree.directory.FileSystemEntry;
import com.metamatrix.common.tree.directory.FileSystemFilter;
import com.metamatrix.common.tree.directory.FileSystemView;
import com.metamatrix.console.ui.util.BasicWizardSubpanelContainer;
import com.metamatrix.console.ui.util.MDCPOpenStateListener;
import com.metamatrix.console.ui.util.ModifiedDirectoryChooserPanel;
import com.metamatrix.console.ui.util.WizardInterface;
import com.metamatrix.console.ui.views.vdb.CreateVDBPanel;
import com.metamatrix.console.util.StaticUtilities;
import javax.swing.AbstractButton;

class ImportFileSelectionPanel
extends BasicWizardSubpanelContainer
implements MDCPOpenStateListener {
    private ModifiedDirectoryChooserPanel chooser;

    public ImportFileSelectionPanel(WizardInterface wizardInterface, String initialDirectory, int stepNum) {
        super(wizardInterface);
        FileSystemView view = new FileSystemView();
        if (initialDirectory != null && initialDirectory.length() > 0) {
            try {
                DirectoryEntry dirEntry = view.lookup(initialDirectory);
                view.setHome((TreeNode)dirEntry);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        this.chooser = new ModifiedDirectoryChooserPanel((DirectoryEntryView)view, 0, (DirectoryEntryFilter[])this.getFileFilters(view), this);
        this.chooser.setShowAcceptButton(false);
        this.chooser.setShowCancelButton(false);
        this.chooser.setShowDetailsButton(false);
        this.chooser.setShowFilterComboBox(false);
        this.chooser.setShowNewFolderButton(false);
        this.chooser.setShowPassThruFilter(false);
        super.setStepText(stepNum, "Select VDB Archive (.VDB) or Definition (.DEF) file to be imported");
        super.setMainContent(this.chooser);
    }

    @Override
    public void fileSelectionIsValid(boolean flag) {
        AbstractButton forwardButton = this.getWizardInterface().getForwardButton();
        forwardButton.setEnabled(flag);
    }

    public String getSelectedFileFullName() {
        String name = null;
        FileSystemEntry fse = (FileSystemEntry)this.chooser.getSelectedTreeNode();
        if (fse != null) {
            name = fse.getFullName();
        }
        return name;
    }

    public String getDirectoryName() {
        String fullName = this.getSelectedFileFullName();
        String directoryName = StaticUtilities.getDirectoryName(fullName);
        return directoryName;
    }

    public String getSelectedFileName() {
        String fullName = this.getSelectedFileFullName();
        String fileName = StaticUtilities.getFileName(fullName);
        return fileName;
    }

    private FileSystemFilter[] getFileFilters(FileSystemView fsv) {
        FileSystemFilter[] filters = null;
        FileSystemFilter filter = new FileSystemFilter(fsv, CreateVDBPanel.VDB_IMPORT_EXTENSIONS, "VDB Import Types (*.def, *.vdb)");
        filters = new FileSystemFilter[]{filter};
        return filters;
    }
}

