/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.vdb;

import com.metamatrix.common.log.LogManager;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.ui.util.BasicWizardSubpanelContainer;
import com.metamatrix.console.ui.util.WizardInterfaceImpl;
import com.metamatrix.console.ui.views.vdb.CreateVDBPanelParent;
import com.metamatrix.console.ui.views.vdb.ImportRolesFileSelectionPanel;
import com.metamatrix.console.ui.views.vdb.VdbRoleOptionsPanel;
import com.metamatrix.console.ui.views.vdb.VdbWizardEntitlementsPanel;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.core.util.FileUtil;
import com.metamatrix.metadata.runtime.api.VirtualDatabase;
import com.metamatrix.platform.admin.api.EntitlementMigrationReport;
import com.metamatrix.toolbox.preference.UserPreferences;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.JPanel;

public class ImportVdbRolesPanel
extends WizardInterfaceImpl {
    static final String[] VDB_IMPORT_ROLES_EXTENSIONS = new String[]{"xml"};
    static final String VDB_ROLES_TYPE_FILE_DESC = "VDB Roles Import Types (*.xml)";
    ImportRolesFileSelectionPanel selectorPanel;
    VdbRoleOptionsPanel roleOptionsPanel;
    VdbWizardEntitlementsPanel roleReportPanel;
    private VirtualDatabase vdb;
    private CreateVDBPanelParent dlgParent = null;
    private ConnectionInfo connection = null;
    private EntitlementMigrationReport migrationReport = null;

    public ImportVdbRolesPanel(CreateVDBPanelParent dlgParent, VirtualDatabase vdbSourceVdb, ConnectionInfo connection) {
        this.dlgParent = dlgParent;
        this.vdb = vdbSourceVdb;
        this.connection = connection;
        this.init();
    }

    private void init() {
        int iPages = this.getPageCount();
        for (int x = 0; x < iPages; ++x) {
            this.removePage(x);
        }
        String initialDirectory = (String)UserPreferences.getInstance().getValue("metamatrix.console.directory");
        this.selectorPanel = new ImportRolesFileSelectionPanel(this, initialDirectory, 1);
        this.addPage(this.selectorPanel);
        this.roleOptionsPanel = new VdbRoleOptionsPanel(this.vdb, this, 2);
        this.addPage(this.roleOptionsPanel);
        this.roleReportPanel = new VdbWizardEntitlementsPanel(this.vdb, this, this.connection, 3);
        this.addPage(this.roleReportPanel);
        this.renumberPages();
        this.setListeners();
        this.getNextButton().setEnabled(false);
    }

    private void setListeners() {
        this.getCancelButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ImportVdbRolesPanel.this.processCancelButton();
            }
        });
        this.getFinishButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ImportVdbRolesPanel.this.processFinishButton();
            }
        });
    }

    private void renumberPages() {
        Component[] thePages = this.getPages();
        for (int i = 0; i < thePages.length; ++i) {
            if (!(thePages[i] instanceof BasicWizardSubpanelContainer)) continue;
            BasicWizardSubpanelContainer bwsc = (BasicWizardSubpanelContainer)thePages[i];
            bwsc.replaceStepNum(i + 1);
        }
    }

    private void processCancelButton() {
        this.dlgParent.processCancelButton();
    }

    private void processFinishButton() {
        this.dlgParent.processFinishButton();
    }

    public AbstractButton getWizardNextButton() {
        return this.getNextButton();
    }

    public void enableNextButton(boolean b) {
        ButtonWidget btnNext = null;
        btnNext = this.getNextButton();
        if (btnNext != null) {
            btnNext.setEnabled(b);
        } else {
            btnNext = this.getFinishButton();
            if (btnNext != null) {
                btnNext.setEnabled(b);
            }
        }
    }

    public VirtualDatabase getVdb() {
        return this.vdb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void showNextPage() {
        try {
            StaticUtilities.startWait(this.dlgParent.getContentPane());
            JPanel pnlCurrPage = (JPanel)this.getCurrentPage();
            boolean proceeding = true;
            if (pnlCurrPage.equals(this.selectorPanel)) {
                proceeding = this.navigateFromSelectorPanel();
            } else if (pnlCurrPage.equals(this.roleOptionsPanel)) {
                proceeding = this.navigateFromRoleOptionsPanel();
            }
            if (!proceeding) {
                return;
            }
        }
        catch (Exception e) {
            ExceptionUtility.showMessage("ERROR!  failed navigating the wizard", e);
        }
        finally {
            StaticUtilities.endWait(this.dlgParent.getContentPane());
        }
        super.showNextPage();
    }

    private boolean navigateFromSelectorPanel() throws Exception {
        boolean result = this.checkSelectorPanelResults();
        if (!result) {
            return false;
        }
        boolean proceeding = true;
        if (!proceeding) {
            this.processCancelButton();
        }
        return true;
    }

    private boolean navigateFromRoleOptionsPanel() {
        try {
            String fileName = this.selectorPanel.getSelectedFileFullName();
            boolean overwriteExisting = this.roleOptionsPanel.isSelectedOverwriteExistingRoles();
            char[] dataRoleContents = ImportVdbRolesPanel.readFileToCharArray(fileName);
            this.migrationReport = ModelManager.getVdbManager(this.connection).importEntitlements(this.vdb, dataRoleContents, overwriteExisting);
        }
        catch (Exception e) {
            LogManager.logError((String)"VIRTUAL_DATABASE", (Throwable)e, (String)"Error importing VDB Roles.");
            ExceptionUtility.showMessage("Error importing VDB Roles", e);
        }
        this.roleReportPanel.setNewVdb(this.vdb);
        this.roleReportPanel.setEntitlementMigrationReport(this.migrationReport);
        this.getBackButton().setVisible(false);
        this.getCancelButton().setVisible(false);
        return true;
    }

    private static char[] readFileToCharArray(String fileName) {
        FileUtil util = new FileUtil(fileName);
        return util.read().toCharArray();
    }

    @Override
    public void showPreviousPage() {
        super.showPreviousPage();
        this.enableNextButton(true);
    }

    public boolean checkSelectorPanelResults() {
        boolean goingToNextPage = true;
        String fileName = this.selectorPanel.getSelectedFileFullName();
        if (fileName == null || fileName.trim().length() == 0) {
            return false;
        }
        File file = new File(fileName);
        if (!file.exists()) {
            StaticUtilities.displayModalDialogWithOK("Unable to open file", "Unable to open file " + fileName + ".  Must select " + "a different file or cancel.");
            goingToNextPage = false;
        } else if (!file.canRead()) {
            StaticUtilities.displayModalDialogWithOK("Unable to read file", "Unable to read file " + fileName + ".  Must select " + "a different file or cancel.");
            goingToNextPage = false;
        } else {
            String vdbDirectoryName = this.selectorPanel.getDirectoryName();
            UserPreferences.getInstance().setValue("metamatrix.console.directory", vdbDirectoryName);
            UserPreferences.getInstance().saveChanges();
        }
        return goingToNextPage;
    }
}

