/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.vdb;

import com.metamatrix.console.ui.views.vdb.AllMaterializationFilesDisplayInfo;
import com.metamatrix.console.ui.views.vdb.SingleMaterializationFileDisplayInfo;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

class MaterializationInfoPanel
extends JPanel {
    private static final int HORIZONTAL_INSETS = 10;
    private JLabel dir;
    private JPanel filesPanel;

    public MaterializationInfoPanel(AllMaterializationFilesDisplayInfo info, boolean alreadyWritten) {
        this.init(info, alreadyWritten);
    }

    private void init(AllMaterializationFilesDisplayInfo info, boolean alreadyWritten) {
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        String header = alreadyWritten ? "The following materialization files were written to folder " : "The following materialization files will be written to folder ";
        LabelWidget hdr = new LabelWidget(header);
        this.add(hdr);
        layout.setConstraints(hdr, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 5, 0), 0, 0));
        this.dir = new LabelWidget();
        this.add(this.dir);
        layout.setConstraints(this.dir, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 30, 0, 0), 0, 0));
        this.filesPanel = new JPanel();
        this.add(this.filesPanel);
        layout.setConstraints(this.filesPanel, new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 11, 2, new Insets(10, 15, 10, 15), 0, 0));
        this.filesPanel.setBorder(BorderFactory.createEtchedBorder());
        this.setInfo(info);
    }

    public void setInfo(AllMaterializationFilesDisplayInfo info) {
        this.dir.setText(info.getFolderName() + ':');
        this.filesPanel.removeAll();
        GridBagLayout filesLayout = new GridBagLayout();
        this.filesPanel.setLayout(filesLayout);
        SingleMaterializationFileDisplayInfo[] files = info.getFiles();
        for (int i = 0; i < files.length; ++i) {
            String desc = files[i].getDescription();
            String name = files[i].getName();
            if (desc != null) {
                LabelWidget descLbl = new LabelWidget(desc + ':');
                this.filesPanel.add(descLbl);
                filesLayout.setConstraints(descLbl, new GridBagConstraints(0, i, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 10, 2, 10), 0, 0));
            }
            LabelWidget nameLbl = new LabelWidget(name);
            this.filesPanel.add(nameLbl);
            filesLayout.setConstraints(nameLbl, new GridBagConstraints(1, i, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 10, 2, 10), 0, 0));
        }
    }
}

