/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.vdb;

import com.metamatrix.admin.api.objects.VDB;
import com.metamatrix.admin.api.server.ServerAdmin;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.console.ConsolePlugin;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.ui.layout.ConsoleMainFrame;
import com.metamatrix.console.ui.views.vdb.MaterializationWizardDialog;
import com.metamatrix.console.ui.views.vdb.VdbDisplayer;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.metadata.runtime.api.VirtualDatabase;
import com.metamatrix.metadata.runtime.api.VirtualDatabaseID;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class MaterializationPanel
extends JPanel
implements VdbDisplayer {
    private static final String SAVE_BTN_LABEL = ConsolePlugin.Util.getString("MaterializationPanel.save");
    private static final String NO_MATERIALIZATION_TEXT = ConsolePlugin.Util.getString("MaterializationPanel.noMaterialization");
    private static final String UNEXPECTED_ERROR = ConsolePlugin.Util.getString("MaterializationPanel.unexpectedError");
    private static final String UNEXPECTED_NUMBER_OF_VDBS = "MaterializationPanel.unexpectedNumberOfVDBs";
    private VirtualDatabase virtualDatabase;
    private JButton saveButton;
    private JPanel buttonsPanel;
    private ConnectionInfo connection;

    public MaterializationPanel(ConnectionInfo connection) {
        this.connection = connection;
        this.createButtons();
    }

    private void createButtons() {
        this.saveButton = new ButtonWidget(SAVE_BTN_LABEL);
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                MaterializationPanel.this.savePressed();
            }
        });
        this.buttonsPanel = new JPanel(new GridLayout(1, 2, 5, 0));
        this.buttonsPanel.add(this.saveButton);
    }

    private void savePressed() {
        VirtualDatabaseID id = (VirtualDatabaseID)this.virtualDatabase.getID();
        String version = id.getVersion();
        MaterializationWizardDialog dialog = new MaterializationWizardDialog(ConsoleMainFrame.getInstance(), this.virtualDatabase.getName(), version, this.connection);
        dialog.show();
    }

    @Override
    public void setVirtualDatabase(VirtualDatabase virtualDatabase) {
        if (this.virtualDatabase != virtualDatabase) {
            this.virtualDatabase = virtualDatabase;
            this.removeAll();
            if (virtualDatabase != null) {
                GridBagLayout layout = new GridBagLayout();
                this.setLayout(layout);
                if (this.hasMaterializedViews(virtualDatabase)) {
                    JPanel spacerPanel = new JPanel();
                    this.add(spacerPanel);
                    layout.setConstraints(spacerPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(4, 4, 4, 4), 0, 0));
                    this.add(this.buttonsPanel);
                    layout.setConstraints(this.buttonsPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 4, 4, 4), 0, 0));
                } else {
                    JTextArea noMaterializationTextArea = new JTextArea(NO_MATERIALIZATION_TEXT);
                    noMaterializationTextArea.setEditable(false);
                    noMaterializationTextArea.setLineWrap(true);
                    noMaterializationTextArea.setWrapStyleWord(true);
                    noMaterializationTextArea.setBackground(this.getBackground());
                    this.add(noMaterializationTextArea);
                    layout.setConstraints(noMaterializationTextArea, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
                }
            }
        }
    }

    private boolean hasMaterializedViews(VirtualDatabase virtualDatabase) {
        ServerAdmin admin = null;
        try {
            admin = this.connection.getServerAdmin();
            String identifier = virtualDatabase.getName() + '|' + virtualDatabase.getVirtualDatabaseID().getVersion();
            Collection vdbs = admin.getVDBs(identifier);
            if (vdbs == null || vdbs.size() != 1) {
                String message = ConsolePlugin.Util.getString(UNEXPECTED_NUMBER_OF_VDBS, new Object[]{identifier, Integer.toString(vdbs == null ? 0 : vdbs.size())});
                throw new Exception(message);
            }
            VDB vdb = (VDB)vdbs.iterator().next();
            return vdb.hasMaterializedViews();
        }
        catch (Exception e) {
            LogManager.logError((String)"VIRTUAL_DATABASE", (Throwable)e, (String)UNEXPECTED_ERROR);
            ExceptionUtility.showMessage(UNEXPECTED_ERROR, e);
            return false;
        }
    }
}

