/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.vdb;

import com.metamatrix.admin.api.objects.AdminOptions;
import com.metamatrix.admin.api.objects.ScriptsContainer;
import com.metamatrix.admin.api.server.ServerAdmin;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.console.ConsolePlugin;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.ui.util.WizardInterfaceImpl;
import com.metamatrix.console.ui.views.vdb.AllMaterializationFilesDisplayInfo;
import com.metamatrix.console.ui.views.vdb.MaterializationWizardDialog;
import com.metamatrix.console.ui.views.vdb.SingleMaterializationFileDisplayInfo;
import com.metamatrix.console.ui.views.vdb.VdbWizardSaveMaterializationFilesPanel;
import com.metamatrix.console.ui.views.vdb.VdbWizardUserAndPasswordPanel;
import com.metamatrix.console.ui.views.vdb.VdbWizardWrittenMaterializationFilesPanel;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.toolbox.preference.UserPreferences;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.JPanel;

public class MaterializationWizard
extends WizardInterfaceImpl {
    private static final int NUM_MATERIALIZATION_FILES = 5;
    private VdbWizardUserAndPasswordPanel userPasswordPanel = null;
    private VdbWizardSaveMaterializationFilesPanel savePanel = null;
    private VdbWizardWrittenMaterializationFilesPanel writtenFilesPanel = null;
    private String vdbName;
    private String vdbVersion;
    private ScriptsContainer scripts = null;
    MaterializationWizardDialog parentDialog = null;
    private ConnectionInfo connection = null;

    public MaterializationWizard(MaterializationWizardDialog parentDialog, String vdbName, String vdbVersion, ConnectionInfo connection) {
        this.parentDialog = parentDialog;
        this.vdbName = vdbName;
        this.vdbVersion = vdbVersion;
        this.connection = connection;
        this.init();
    }

    private void init() {
        this.userPasswordPanel = new VdbWizardUserAndPasswordPanel(this, 1);
        String initialDirectory = (String)UserPreferences.getInstance().getValue("metamatrix.console.materializationdirectory");
        this.savePanel = new VdbWizardSaveMaterializationFilesPanel(this, 2, initialDirectory);
        this.writtenFilesPanel = new VdbWizardWrittenMaterializationFilesPanel(this, 3, false);
        this.addPage(this.userPasswordPanel);
        this.addPage(this.savePanel);
        this.addPage(this.writtenFilesPanel);
        this.getForwardButton().setEnabled(false);
        this.setListeners();
    }

    private void setListeners() {
        this.getCancelButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                MaterializationWizard.this.processCancelButton();
            }
        });
        this.getFinishButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                MaterializationWizard.this.processFinishButton();
            }
        });
    }

    private void processCancelButton() {
        this.parentDialog.processCancelButton();
    }

    private void processFinishButton() {
        boolean proceed = this.saveScripts();
        if (proceed) {
            this.parentDialog.processFinishButton();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void showNextPage() {
        boolean proceed = true;
        try {
            StaticUtilities.startWait(this.parentDialog.getContentPane());
            JPanel currentPanel = (JPanel)this.getCurrentPage();
            if (currentPanel.equals(this.savePanel)) {
                proceed = this.generateScripts();
            }
        }
        finally {
            StaticUtilities.endWait(this.parentDialog.getContentPane());
        }
        if (proceed) {
            super.showNextPage();
        }
    }

    private boolean generateScripts() {
        AllMaterializationFilesDisplayInfo allFiles;
        ServerAdmin admin = null;
        String directory = null;
        try {
            admin = this.connection.getServerAdmin();
            String loginUserName = this.userPasswordPanel.getLoginUserName();
            String loginPassword = this.userPasswordPanel.getLoginPassword();
            String dataBaseUserName = this.userPasswordPanel.getDataBaseUserName();
            String dataBasePassword = this.userPasswordPanel.getDataBasePassword();
            this.scripts = admin.generateMaterializationScripts(this.vdbName, this.vdbVersion, loginUserName, loginPassword, dataBaseUserName, dataBasePassword);
            directory = this.savePanel.getDirectoryName();
        }
        catch (Exception ex) {
            String msg = ConsolePlugin.Util.getString("MaterializationWizard.errorGenerating");
            LogManager.logError((String)"VIRTUAL_DATABASE", (Throwable)ex, (String)msg);
            ExceptionUtility.showMessage(msg, ex.getMessage(), ex);
            return false;
        }
        AllMaterializationFilesDisplayInfo materializationFileCreationResult = null;
        SingleMaterializationFileDisplayInfo[] files = new SingleMaterializationFileDisplayInfo[5];
        TreeSet fileNames = new TreeSet(this.scripts.getFileNames());
        Iterator iter = fileNames.iterator();
        for (int i = 0; i < 5; ++i) {
            files[i] = new SingleMaterializationFileDisplayInfo(null, (String)iter.next());
        }
        materializationFileCreationResult = allFiles = new AllMaterializationFilesDisplayInfo(directory, files);
        this.writtenFilesPanel.setResults(materializationFileCreationResult);
        return true;
    }

    private boolean saveScripts() {
        try {
            String directory = this.savePanel.getDirectoryName();
            boolean overwrite = this.writtenFilesPanel.getOverwrite();
            AdminOptions options = overwrite ? new AdminOptions(1) : new AdminOptions(4);
            this.scripts.saveAllToDirectory(directory, options);
            UserPreferences.getInstance().setValue("metamatrix.console.materializationdirectory", directory);
            UserPreferences.getInstance().saveChanges();
            return true;
        }
        catch (Exception ex) {
            String msg = ConsolePlugin.Util.getString("MaterializationWizard.errorSaving");
            LogManager.logError((String)"VIRTUAL_DATABASE", (Throwable)ex, (String)msg);
            ExceptionUtility.showMessage(msg, ex.getMessage(), ex);
            return false;
        }
    }
}

