/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.vdb;

import com.metamatrix.console.ConsolePlugin;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.ui.views.vdb.MaterializationWizard;
import com.metamatrix.console.util.StaticUtilities;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class MaterializationWizardDialog
extends JDialog {
    MaterializationWizard wizard = null;
    private ConnectionInfo connection = null;

    public MaterializationWizardDialog(JFrame parentFrame, String vdbName, String vdbVersion, ConnectionInfo connection) {
        super(parentFrame);
        this.connection = connection;
        this.setModal(true);
        this.initThis(vdbName, vdbVersion);
        this.pack();
        this.setLocation(StaticUtilities.centerFrame(this.getSize()));
    }

    private void initThis(String vdbName, String vdbVersion) {
        this.getRootPane().setPreferredSize(new Dimension(650, 650));
        this.setTitle(ConsolePlugin.Util.getString("MaterializationWizardDialog.title"));
        this.setModal(true);
        JPanel content = (JPanel)this.getContentPane();
        content.setLayout(new GridLayout(1, 1));
        content.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                MaterializationWizardDialog.this.dispose();
            }
        });
        this.wizard = new MaterializationWizard(this, vdbName, vdbVersion, this.connection);
        content.add(this.wizard);
    }

    public void processFinishButton() {
        this.dispose();
    }

    public void processCancelButton() {
        this.dispose();
    }
}

