/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.vdb;

import com.metamatrix.console.ui.util.ActionFireableButtonWidget;
import com.metamatrix.console.ui.views.vdb.EntitlementMigrationReportSummaryPanel;
import com.metamatrix.toolbox.ui.widget.TableWidget;
import com.metamatrix.toolbox.ui.widget.table.EnhancedTableModel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

class MigrationSummaryTableWidget
extends TableWidget
implements TableCellRenderer {
    private EntitlementMigrationReportSummaryPanel panel;
    private DefaultTableCellRenderer defaultRenderer = new DefaultTableCellRenderer();

    public MigrationSummaryTableWidget(EntitlementMigrationReportSummaryPanel pnl, EnhancedTableModel model) {
        super(model);
        this.panel = pnl;
        this.init();
    }

    private void init() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent ev) {
                Point point = ev.getPoint();
                int row = MigrationSummaryTableWidget.this.detailsButtonRow(point);
                if (row >= 0) {
                    ActionFireableButtonWidget button = MigrationSummaryTableWidget.this.panel.getDetailButtonAt(row);
                    button.fireActionPerformed(new ActionEvent(this, -1, ""));
                }
            }
        });
        this.setRowHeight(30);
    }

    public Class getColumnClass(int index) {
        System.err.println("in table's getColumnClass() method");
        return super.getColumnClass(index);
    }

    private int detailsButtonRow(Point point) {
        int row = -1;
        int col = this.columnAtPoint(point);
        if (col == 4) {
            row = this.rowAtPoint(point);
        }
        return row;
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        return this;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (column == 4) {
            ActionFireableButtonWidget button = this.panel.getDetailButtonAt(row);
            JPanel buttonPanel = new JPanel();
            GridBagLayout bl = new GridBagLayout();
            buttonPanel.setLayout(bl);
            buttonPanel.add(button);
            bl.setConstraints(button, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 4, 4, 4), 0, 0));
            return buttonPanel;
        }
        return this.defaultRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
    }
}

