/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.vdb;

import com.metamatrix.console.ui.views.vdb.VDBConnectorBindingNames;
import com.metamatrix.toolbox.ui.widget.table.DefaultTableModel;
import java.util.Vector;

class ModelTableModel
extends DefaultTableModel {
    private VDBConnectorBindingNames[] rowData = new VDBConnectorBindingNames[0];

    public ModelTableModel(Vector colNames) {
        super(colNames);
    }

    public void populate(VDBConnectorBindingNames[] rows) {
        this.depopulate();
        this.rowData = rows;
        for (int i = 0; i < this.rowData.length; ++i) {
            Object[] rowArray = new Object[]{this.rowData[i].getModelName(), this.rowData[i]};
            this.addRow(rowArray);
        }
    }

    private void depopulate() {
        int numRows = this.getRowCount();
        for (int i = numRows - 1; i >= 0; --i) {
            this.removeRow(i);
        }
        this.rowData = new VDBConnectorBindingNames[0];
    }

    public void reviseRow(VDBConnectorBindingNames row, int rowIndex) {
        if (rowIndex >= 0) {
            this.setValueAt(row, rowIndex, 1);
            this.rowData[rowIndex] = row;
        }
    }

    public void reviseRow(VDBConnectorBindingNames row) {
        int rowIndex = this.indexForModel(row.getModelName());
        this.reviseRow(row, rowIndex);
    }

    public int indexForModel(String modelName) {
        int index = -1;
        int i = 0;
        while (index < 0 && i < this.rowData.length) {
            if (modelName.equals(this.rowData[i].getModelName())) {
                index = i;
                continue;
            }
            ++i;
        }
        return index;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        boolean editable = false;
        if (row >= 0 && row < this.getRowCount() && col == 1 && this.rowData[row].isMultiSource()) {
            editable = true;
        }
        return editable;
    }

    public boolean isRowMultiSource(int row) {
        boolean multiSource = false;
        if (row >= 0 && row < this.getRowCount()) {
            multiSource = this.rowData[row].isMultiSource();
        }
        return multiSource;
    }

    public boolean isAssigned(int row) {
        boolean assigned = false;
        if (row >= 0 && row < this.getRowCount()) {
            assigned = this.rowData[row].getBindings().length > 0;
        }
        return assigned;
    }

    public VDBConnectorBindingNames getObjectForRow(int row) {
        VDBConnectorBindingNames result = null;
        if (row >= 0 && row < this.getRowCount()) {
            result = this.rowData[row];
        }
        return result;
    }

    public VDBConnectorBindingNames[] getRowData() {
        return this.rowData;
    }
}

