/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.vdb;

import com.metamatrix.common.config.api.ServiceComponentDefn;
import com.metamatrix.metadata.runtime.api.Model;
import com.metamatrix.metadata.runtime.api.ModelID;
import com.metamatrix.vdb.runtime.BasicModelInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ModelWrapper {
    private BasicModelInfo theModelInfo = null;
    private Model theModel = null;
    private boolean bContentIsModel = false;
    private boolean bContentIsModelInfo = false;
    private Collection scdConnectorBindings = new ArrayList();

    public ModelWrapper(BasicModelInfo info) {
        this.theModelInfo = info;
        this.bContentIsModelInfo = true;
    }

    public ModelWrapper(Model theModel) {
        this.theModel = theModel;
        this.bContentIsModel = true;
    }

    public String getName() {
        String sResult = "";
        if (this.bContentIsModel) {
            sResult = this.theModel.getName();
        } else if (this.bContentIsModelInfo) {
            sResult = this.theModelInfo.getName();
        }
        return sResult;
    }

    public String getVersion() {
        String sResult = "";
        if (this.bContentIsModel) {
            ModelID mdlId = (ModelID)this.theModel.getID();
            sResult = mdlId.getVersion();
        } else if (this.bContentIsModelInfo) {
            sResult = this.theModelInfo.getVersion();
        }
        return sResult;
    }

    public List getConnectorBindingNames() {
        List result = new ArrayList(0);
        if (this.bContentIsModel) {
            result = this.theModel.getConnectorBindingNames();
        } else if (this.bContentIsModelInfo) {
            // empty if block
        }
        return result;
    }

    public boolean requiresConnectorBinding() {
        boolean bResult = false;
        if (this.bContentIsModel) {
            bResult = this.theModel.requireConnectorBinding();
        } else if (this.bContentIsModelInfo) {
            bResult = this.theModelInfo.requiresConnectorBinding();
        }
        return bResult;
    }

    public void setConnectorBindings(Collection scdConnectorBindings) {
        this.scdConnectorBindings = scdConnectorBindings;
        if (this.bContentIsModelInfo) {
            int size = this.scdConnectorBindings.size();
            ArrayList<String> bindingNames = new ArrayList<String>(size);
            ArrayList<String> bindingUUIDs = new ArrayList<String>(size);
            for (ServiceComponentDefn scd : this.scdConnectorBindings) {
                bindingNames.add(scd.getName());
                bindingUUIDs.add(scd.getRoutingUUID());
            }
            this.theModelInfo.setConnectorBindingNames(bindingNames);
        }
    }

    public Collection getConnectorBindings() {
        return this.scdConnectorBindings;
    }

    public boolean supportsMultiSourceBindings() {
        boolean result = false;
        if (this.bContentIsModel) {
            result = this.theModel.supportsMultiSourceBindings();
        } else if (this.bContentIsModelInfo) {
            result = this.theModelInfo.supportsMultiSourceBindings();
        }
        return result;
    }

    public boolean isMultiSourceBindingsEnabled() {
        boolean result = false;
        if (this.bContentIsModel) {
            result = this.theModel.isMultiSourceBindingEnabled();
        } else if (this.bContentIsModelInfo) {
            result = this.theModelInfo.isMultiSourceBindingEnabled();
        }
        return result;
    }
}

