/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.vdb;

import com.metamatrix.console.ui.views.vdb.ModelVisibilityInfo;
import com.metamatrix.console.ui.views.vdb.VisibilityTableModel;
import com.metamatrix.toolbox.ui.widget.TableWidget;

public class NewVDBWizardModelVisibilityTable
extends TableWidget {
    public static final int NUM_COLUMNS = 4;
    public static final int NAME_COLUMN_NUM = 0;
    public static final String NAME = "Name";
    public static final int TYPE_COLUMN_NUM = 1;
    public static final int VISIBILITY_COLUMN_NUM = 2;
    public static final int MULTIPLE_SOURCE_COLUMN_NUM = 3;
    ModelVisibilityInfo[] info;
    VisibilityTableModel model;

    public NewVDBWizardModelVisibilityTable(ModelVisibilityInfo[] inf) {
        this.info = inf;
        if (this.info == null) {
            this.info = new ModelVisibilityInfo[0];
        }
        this.init();
    }

    public NewVDBWizardModelVisibilityTable() {
        this((ModelVisibilityInfo[])null);
    }

    private void init() {
        this.model = new VisibilityTableModel(this.info);
        this.setModel(this.model);
        this.getColumnModel().setColumnMargin(8);
    }

    public void populateTable(ModelVisibilityInfo[] inf) {
        this.info = inf;
        this.model.populateModel(this.info);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        boolean editable = false;
        if (column == 2) {
            editable = true;
        } else if (column == 3) {
            editable = this.info[row].isMultipleSourceEligible() && this.info[row].isMultipleSourceFlagEditable();
        }
        return editable;
    }

    public ModelVisibilityInfo[] getUpdatedVisibilityInfo() {
        ModelVisibilityInfo[] updatedInfo = new ModelVisibilityInfo[this.info.length];
        for (int i = 0; i < updatedInfo.length; ++i) {
            updatedInfo[i] = new ModelVisibilityInfo(this.info[i].getModelName(), this.info[i].getModelType(), this.model.publicCheckedForRow(i), this.info[i].isMultipleSourceEligible(), this.info[i].isMultipleSourceFlagEditable(), this.model.multipleSourceCheckedForRow(i));
        }
        return updatedInfo;
    }

    public boolean publicCheckedForRow(int rowNum) {
        return this.model.publicCheckedForRow(rowNum);
    }

    public boolean anyPublic() {
        return this.model.anyPublic();
    }

    public boolean isMultiSourceEligible(int rowNum) {
        return this.info[rowNum].isMultipleSourceEligible();
    }
}

