/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.vdb;

import com.metamatrix.common.tree.TreeNode;
import com.metamatrix.common.tree.directory.DirectoryEntryFilter;
import com.metamatrix.common.tree.directory.DirectoryEntryView;
import com.metamatrix.common.tree.directory.FileSystemEntry;
import com.metamatrix.common.tree.directory.FileSystemFilter;
import com.metamatrix.common.tree.directory.FileSystemView;
import com.metamatrix.console.ui.util.BasicWizardSubpanelContainer;
import com.metamatrix.console.ui.util.WizardInterface;
import com.metamatrix.console.ui.views.vdb.VDBExporter;
import com.metamatrix.toolbox.ui.widget.DirectoryChooserPanel;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;

class TargetSelectorPanel
extends BasicWizardSubpanelContainer {
    private String vdbName;
    private DirectoryChooserPanel chooser;
    private FileSystemView fileSystemView;

    public TargetSelectorPanel(String name, WizardInterface wizardInterface, String initialDirectory) {
        super(wizardInterface);
        this.vdbName = name;
        this.fileSystemView = new FileSystemView();
        if (initialDirectory != null && initialDirectory.length() > 0) {
            try {
                this.fileSystemView.setHome((TreeNode)this.fileSystemView.lookup(initialDirectory));
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        this.chooser = new DirectoryChooserPanel((DirectoryEntryView)this.fileSystemView, 1, (DirectoryEntryFilter[])this.getFileFilters(this.fileSystemView));
        this.chooser.setShowAcceptButton(false);
        this.chooser.setShowCancelButton(false);
        this.chooser.setShowDetailsButton(false);
        this.chooser.setShowFilterComboBox(false);
        this.chooser.setShowNewFolderButton(false);
        this.chooser.setShowPassThruFilter(false);
        this.chooser.setInitialFilename(this.vdbName + ".vdb");
        this.chooser.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ev) {
                JTextComponent textField = (JTextComponent)ev.getSource();
                String textEntered = textField.getText().trim();
                TargetSelectorPanel.this.chooserStateChanged(textEntered);
            }
        });
        super.setStepText(1, "Select destination file for VDB.");
        super.setMainContent(this.chooser);
    }

    private void chooserStateChanged(String textEntered) {
        boolean enabling = textEntered.length() > 0;
        AbstractButton forwardButton = this.getWizardInterface().getForwardButton();
        forwardButton.setEnabled(enabling);
    }

    public String getSelectedFileName() {
        String name = null;
        String fileNameEntered = this.chooser.getNameFieldText().trim();
        if (fileNameEntered != null && fileNameEntered.length() > 0) {
            String directory = this.chooser.getParentDirectoryEntry().toString();
            if (!directory.endsWith(File.separator)) {
                directory = directory + File.separator;
            }
            name = directory + fileNameEntered;
        } else {
            FileSystemEntry fse = (FileSystemEntry)this.chooser.getSelectedTreeNode();
            if (fse != null) {
                name = fse.getFullName();
            }
        }
        return name;
    }

    public String getDirectoryName() {
        String directoryName = null;
        String fullName = this.getSelectedFileName();
        if (fullName != null) {
            int index = fullName.lastIndexOf(File.separatorChar);
            directoryName = fullName.substring(0, index);
        }
        return directoryName;
    }

    private FileSystemFilter[] getFileFilters(FileSystemView fsv) {
        FileSystemFilter[] filters = null;
        FileSystemFilter filter = new FileSystemFilter(fsv, VDBExporter.VDB_EXPORT_EXTENSIONS, "VDB Export Types (*.vdb)");
        filters = new FileSystemFilter[]{filter};
        return filters;
    }
}

