/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.vdb;

import com.metamatrix.console.ConsolePlugin;
import com.metamatrix.console.ui.views.vdb.UDDIConfigurationsHandler;
import com.metamatrix.console.util.SavedUDDIRegistryInfo;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import com.metamatrix.toolbox.ui.widget.TableWidget;
import com.metamatrix.toolbox.ui.widget.TextFieldWidget;
import com.metamatrix.toolbox.ui.widget.TitledBorder;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;

public class UDDIConfigurationsDialog
extends JDialog {
    private static final String TITLE = ConsolePlugin.Util.getString("UDDIConfigurationsDialog.title");
    private static final String SELECT_A_CONFIGURATION = ConsolePlugin.Util.getString("UDDIConfigurationsDialog.selectAConfiguration");
    private static final String CONFIGURATIONS_COL_HDR = ConsolePlugin.Util.getString("UDDIConfigurationsDialog.configurationsColHdr");
    private static final String ADD = ConsolePlugin.Util.getString("General.AddWithEllipsis");
    private static final String REMOVE = ConsolePlugin.Util.getString("General.Remove");
    private static final String CONFIG_NAME = ConsolePlugin.Util.getString("UDDIConfigurationsDialog.configName") + ':';
    private static final String HOST = ConsolePlugin.Util.getString("UDDIConfigurationsDialog.host") + ':';
    private static final String PORT = ConsolePlugin.Util.getString("UDDIConfigurationsDialog.port") + ':';
    private static final String USER_NAME = ConsolePlugin.Util.getString("UDDIConfigurationsDialog.userName") + ':';
    private static final String NOTE_LINE_1 = ConsolePlugin.Util.getString("UDDIConfigurationsDialog.noteLine1");
    private static final String NOTE_LINE_2 = ConsolePlugin.Util.getString("UDDIConfigurationsDialog.noteLine2");
    private static final String OK = ConsolePlugin.Util.getString("General.OK");
    private static final String CANCEL = ConsolePlugin.Util.getString("General.Cancel");
    private static final int NO_STATE = 1;
    private static final int EDITING = 2;
    private static final int ADDING = 3;
    private static final int REMOVING = 4;
    private static final int LEFT_INSET = 4;
    private static final int RIGHT_INSET = 4;
    private UDDIConfigurationsHandler handler;
    private SavedUDDIRegistryInfo[] items;
    private JTable configsTable;
    private JButton addButton;
    private JButton removeButton;
    private JButton okButton;
    private JButton cancelButton;
    private JTextField nameField;
    private JTextField hostField;
    private JTextField portField;
    private JTextField userField;
    private SavedUDDIRegistryInfo removedItem = null;
    private int curState = 1;

    public UDDIConfigurationsDialog(JFrame parentFrame, UDDIConfigurationsHandler handler, SavedUDDIRegistryInfo[] items) {
        super(parentFrame, TITLE, true);
        this.handler = handler;
        this.items = items;
        this.createComponent();
        this.insertItemsIntoTable();
    }

    private void createComponent() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent ev) {
                UDDIConfigurationsDialog.this.cancelPressed();
            }
        });
        GridBagLayout layout = new GridBagLayout();
        this.getContentPane().setLayout(layout);
        LabelWidget selectLabel = new LabelWidget(SELECT_A_CONFIGURATION);
        this.getContentPane().add(selectLabel);
        layout.setConstraints(selectLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 4, 0, 4), 0, 0));
        ArrayList<String> colHdrs = new ArrayList<String>(1);
        colHdrs.add(CONFIGURATIONS_COL_HDR);
        this.configsTable = new TableWidget(colHdrs);
        this.configsTable.setSelectionMode(0);
        this.configsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent ev) {
                if (!ev.getValueIsAdjusting()) {
                    UDDIConfigurationsDialog.this.selectionChanged();
                }
            }
        });
        JPanel configsPanel = new JPanel();
        this.getContentPane().add(configsPanel);
        layout.setConstraints(configsPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 4, 0, 4), 0, 0));
        GridBagLayout configsLayout = new GridBagLayout();
        configsPanel.setLayout(configsLayout);
        JScrollPane listScrollPane = new JScrollPane(this.configsTable);
        configsPanel.add(listScrollPane);
        configsLayout.setConstraints(listScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel buttonsColumn = new JPanel(new GridLayout(2, 1, 0, 4));
        configsPanel.add(buttonsColumn);
        configsLayout.setConstraints(buttonsColumn, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 4, 2, 2), 0, 0));
        this.addButton = new ButtonWidget(ADD);
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                UDDIConfigurationsDialog.this.addPressed();
            }
        });
        buttonsColumn.add(this.addButton);
        this.removeButton = new ButtonWidget(REMOVE);
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                UDDIConfigurationsDialog.this.removePressed();
            }
        });
        this.removeButton.setEnabled(false);
        JPanel textFieldsPanel = new JPanel();
        this.getContentPane().add(textFieldsPanel);
        layout.setConstraints(textFieldsPanel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(30, 20, 10, 20), 0, 0));
        GridBagLayout textFieldsLayout = new GridBagLayout();
        textFieldsPanel.setLayout(textFieldsLayout);
        LabelWidget nameLabel = new LabelWidget(CONFIG_NAME);
        textFieldsPanel.add(nameLabel);
        textFieldsLayout.setConstraints(nameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        LabelWidget hostLabel = new LabelWidget(HOST);
        textFieldsPanel.add(hostLabel);
        textFieldsLayout.setConstraints(hostLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        LabelWidget portLabel = new LabelWidget(PORT);
        textFieldsPanel.add(portLabel);
        textFieldsLayout.setConstraints(portLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        LabelWidget userLabel = new LabelWidget(USER_NAME);
        textFieldsPanel.add(userLabel);
        textFieldsLayout.setConstraints(userLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        DocumentListener docListener = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent ev) {
                UDDIConfigurationsDialog.this.textFieldChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent ev) {
                UDDIConfigurationsDialog.this.textFieldChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent ev) {
                UDDIConfigurationsDialog.this.textFieldChanged();
            }
        };
        this.nameField = new TextFieldWidget();
        this.nameField.getDocument().addDocumentListener(docListener);
        this.nameField.setEnabled(false);
        textFieldsPanel.add(this.nameField);
        textFieldsLayout.setConstraints(this.nameField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 2, 0, 0), 0, 0));
        this.hostField = new TextFieldWidget();
        this.hostField.getDocument().addDocumentListener(docListener);
        this.hostField.setEnabled(false);
        textFieldsPanel.add(this.hostField);
        textFieldsLayout.setConstraints(this.hostField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 2, 0, 0), 0, 0));
        this.portField = new TextFieldWidget();
        this.portField.getDocument().addDocumentListener(docListener);
        this.portField.setEnabled(false);
        textFieldsPanel.add(this.portField);
        textFieldsLayout.setConstraints(this.portField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 2, 0, 0), 0, 0));
        this.userField = new TextFieldWidget();
        this.userField.getDocument().addDocumentListener(docListener);
        this.userField.setEnabled(false);
        textFieldsPanel.add(this.userField);
        textFieldsLayout.setConstraints(this.userField, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 2, 0, 0), 0, 0));
        JPanel notePanel = new JPanel();
        this.getContentPane().add(notePanel);
        layout.setConstraints(notePanel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        notePanel.setBorder(new TitledBorder(""));
        GridBagLayout noteLayout = new GridBagLayout();
        notePanel.setLayout(noteLayout);
        LabelWidget note1Label = new LabelWidget(NOTE_LINE_1);
        notePanel.add(note1Label);
        noteLayout.setConstraints(note1Label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 0, 2), 0, 0));
        LabelWidget note2Label = new LabelWidget(NOTE_LINE_2);
        notePanel.add(note2Label);
        layout.setConstraints(note2Label, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 2, 2), 0, 0));
        JPanel buttonsPanel = new JPanel(new GridLayout(1, 2, 10, 0));
        this.getContentPane().add(buttonsPanel);
        layout.setConstraints(buttonsPanel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.okButton = new ButtonWidget(OK);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                UDDIConfigurationsDialog.this.okPressed();
            }
        });
        this.okButton.setEnabled(false);
        buttonsPanel.add(this.okButton);
        this.cancelButton = new ButtonWidget(CANCEL);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                UDDIConfigurationsDialog.this.cancelPressed();
            }
        });
        buttonsPanel.add(this.cancelButton);
        this.pack();
        this.setLocation(StaticUtilities.centerFrame(this.getSize()));
    }

    private void insertItemsIntoTable() {
        DefaultTableModel model = (DefaultTableModel)this.configsTable.getModel();
        for (int i = 0; i < this.items.length; ++i) {
            String curName = this.items[i].getName();
            Object[] rowVals = new Object[]{curName};
            model.addRow(rowVals);
        }
    }

    private void selectionChanged() {
        this.removedItem = null;
        SavedUDDIRegistryInfo item = this.getSelectedItem();
        this.displayItem(item);
        if (item == null) {
            this.curState = 1;
            this.removeButton.setEnabled(false);
            this.okButton.setEnabled(false);
            this.disableText();
        } else {
            this.curState = 2;
            this.removeButton.setEnabled(true);
            this.okButton.setEnabled(true);
            this.enableText(false);
        }
    }

    private void textFieldChanged() {
        boolean newConfig = this.curState == 3;
        String configName = this.nameField.getText().trim();
        String host = this.hostField.getText().trim();
        String port = this.portField.getText().trim();
        String user = this.userField.getText().trim();
        boolean entriesValid = this.isValidConfig(configName, host, port, user, newConfig);
        this.okButton.setEnabled(entriesValid);
    }

    private void addPressed() {
        this.removedItem = null;
        this.clearText();
        this.enableText(true);
        this.addButton.setEnabled(false);
        this.removeButton.setEnabled(false);
        this.okButton.setEnabled(false);
        this.clearSelection();
        this.curState = 3;
    }

    private void removePressed() {
        this.curState = 4;
        this.removeButton.setEnabled(false);
        this.addButton.setEnabled(false);
        this.okButton.setEnabled(true);
        this.removedItem = this.getSelectedItem();
        this.clearText();
        this.disableText();
    }

    private void cancelPressed() {
        this.dispose();
    }

    private void okPressed() {
        this.dispose();
        switch (this.curState) {
            case 2: {
                SavedUDDIRegistryInfo item = this.getSelectedItem();
                String configName = item.getName();
                String host = this.hostField.getText().trim();
                String port = this.portField.getText().trim();
                String user = this.userField.getText().trim();
                SavedUDDIRegistryInfo editedItem = new SavedUDDIRegistryInfo(configName, user, host, port);
                if (item.equals(editedItem)) {
                    this.handler.unchangedConfiguration(item);
                    break;
                }
                this.handler.editedConfiguration(editedItem);
                break;
            }
            case 3: {
                String configName = this.nameField.getText().trim();
                String host = this.hostField.getText().trim();
                String port = this.portField.getText().trim();
                String user = this.userField.getText().trim();
                SavedUDDIRegistryInfo newItem = new SavedUDDIRegistryInfo(configName, user, host, port);
                this.handler.addedConfiguration(newItem);
                break;
            }
            case 4: {
                this.handler.removedConfiguration(this.removedItem);
            }
        }
    }

    private boolean isExistingConfigName(String configName) {
        boolean found = false;
        int i = 0;
        while (!found && i < this.items.length) {
            String curName = this.items[i].getName();
            if (configName.equals(curName)) {
                found = true;
                continue;
            }
            ++i;
        }
        return found;
    }

    private boolean isValidConfig(String configName, String host, String port, String userName, boolean newConfig) {
        boolean valid = false;
        if (configName.length() > 0 && host.length() > 0 && port.length() > 0 && userName.length() > 0) {
            if (newConfig) {
                if (!this.isExistingConfigName(configName)) {
                    valid = true;
                }
            } else {
                valid = true;
            }
        }
        return valid;
    }

    private void clearText() {
        String empty = "";
        this.nameField.setText(empty);
        this.hostField.setText(empty);
        this.portField.setText(empty);
        this.userField.setText(empty);
    }

    private void enableText(boolean includingName) {
        this.hostField.setEnabled(true);
        this.portField.setEnabled(true);
        this.userField.setEnabled(true);
        if (includingName) {
            this.nameField.setEnabled(true);
        }
    }

    private void disableText() {
        this.nameField.setEnabled(false);
        this.hostField.setEnabled(false);
        this.portField.setEnabled(false);
        this.userField.setEnabled(false);
    }

    private SavedUDDIRegistryInfo getSelectedItem() {
        SavedUDDIRegistryInfo selectedItem = null;
        int selectedIndex = this.configsTable.getSelectedRow();
        if (selectedIndex >= 0) {
            selectedItem = this.items[selectedIndex];
        }
        return selectedItem;
    }

    private void displayItem(SavedUDDIRegistryInfo item) {
        if (item == null) {
            this.clearText();
        } else {
            this.nameField.setText(item.getName());
            this.hostField.setText(item.getHost());
            this.portField.setText(item.getPort());
            this.userField.setText(item.getUserName());
        }
    }

    private void clearSelection() {
        this.configsTable.clearSelection();
    }
}

