/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.vdb;

import com.metamatrix.console.ConsolePlugin;
import com.metamatrix.console.ui.views.vdb.BindingsColEditor;
import com.metamatrix.console.ui.views.vdb.BindingsColRenderer;
import com.metamatrix.console.ui.views.vdb.ConnectorBindingNameAndUUID;
import com.metamatrix.console.ui.views.vdb.ModelTableModel;
import com.metamatrix.console.ui.views.vdb.MultiSourceModelBindingEditRequestHandler;
import com.metamatrix.console.ui.views.vdb.VDBConnectorBindingNames;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.TableWidget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JScrollPane;

public class VDBConnectorBindingAssignmentModelTable
extends TableWidget {
    public static final int NUM_COLUMNS = 2;
    public static final String MODEL_NAME = ConsolePlugin.Util.getString("VDBConnectorBindingAssignmentModelTable.ModelName");
    public static final int MODEL_NAME_COL_NUM = 0;
    public static final String CONNECTOR_BINDING = ConsolePlugin.Util.getString("VDBConnectorBindingAssignmentModelTable.ConnectorBinding");
    public static final int CONNECTOR_BINDING_COL_NUM = 1;
    public static final int ROW_HEIGHT;
    public static final String SOURCE;
    public static final String SOURCES;
    public static final String EDIT;
    private ModelTableModel model = null;
    private JButton editorComponent;
    private BindingsColEditor editor = null;
    private MultiSourceModelBindingEditRequestHandler editRequestHandler;
    private JScrollPane containerScrollPane;

    public static String getBindingsText(VDBConnectorBindingNames bindingInfo) {
        String labelText = "";
        int numSources = bindingInfo.getBindings().length;
        if (bindingInfo.isMultiSource()) {
            String src = numSources == 1 ? SOURCE : SOURCES;
            labelText = EDIT + ' ' + '(' + new Integer(numSources).toString() + ' ' + src + ')';
        } else if (numSources == 1) {
            labelText = bindingInfo.getBindings()[0].getBindingName();
        }
        return labelText;
    }

    public VDBConnectorBindingAssignmentModelTable(MultiSourceModelBindingEditRequestHandler handler) {
        this.editRequestHandler = handler;
        Vector<String> colNames = new Vector<String>();
        colNames.add(MODEL_NAME);
        colNames.add(CONNECTOR_BINDING);
        this.model = new ModelTableModel(colNames);
        this.setModel(this.model);
        this.setDefaultRenderer(VDBConnectorBindingNames.class, new BindingsColRenderer());
        this.editorComponent = new ButtonWidget();
        this.editorComponent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                VDBConnectorBindingAssignmentModelTable.this.editPressed(ev);
            }
        });
        this.editor = new BindingsColEditor(this.editorComponent);
        this.setDefaultEditor(VDBConnectorBindingNames.class, this.editor);
        this.setRowHeight(ROW_HEIGHT);
    }

    public void setContainerScrollPane(JScrollPane scrollPane) {
        this.containerScrollPane = scrollPane;
    }

    public Class getColumnClass(int colIndex) {
        Class<Object> cls = Object.class;
        if (colIndex == 0) {
            cls = String.class;
        } else if (colIndex == 1) {
            cls = VDBConnectorBindingNames.class;
        }
        return cls;
    }

    public void populate(VDBConnectorBindingNames[] rowData) {
        this.model.populate(rowData);
        this.sizeColumnsToFitViewport(this.containerScrollPane);
    }

    public void updateMultiSource(Map multiSourceInfo) {
        VDBConnectorBindingNames[] rows = this.model.getRowData();
        for (Map.Entry me : multiSourceInfo.entrySet()) {
            String modelName = (String)me.getKey();
            boolean multiSourceSelected = (Boolean)me.getValue();
            int rowIndex = this.model.indexForModel(modelName);
            if (rowIndex < 0) continue;
            VDBConnectorBindingNames row = rows[rowIndex];
            if (multiSourceSelected) {
                if (row.isMultiSource()) continue;
                row = row.copy();
                row.setMultiSource(true);
                this.reviseRow(row, rowIndex);
                continue;
            }
            if (!row.isMultiSource()) continue;
            row = row.copy();
            row.setMultiSource(false);
            ConnectorBindingNameAndUUID[] bindings = row.getBindings();
            if (bindings.length > 1) {
                ConnectorBindingNameAndUUID[] newBindings = new ConnectorBindingNameAndUUID[]{bindings[0]};
                row.setBindings(newBindings);
            }
            this.reviseRow(row, rowIndex);
        }
    }

    public void reviseRow(VDBConnectorBindingNames rowData, int rowIndex) {
        this.model.reviseRow(rowData, rowIndex);
    }

    public void reviseRow(VDBConnectorBindingNames rowData) {
        this.model.reviseRow(rowData);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        int modelRow = this.convertRowIndexToModel(row);
        return this.model.isCellEditable(modelRow, col);
    }

    private void editPressed(ActionEvent ev) {
        VDBConnectorBindingNames bindingsInfo = (VDBConnectorBindingNames)this.editor.getCellEditorValue();
        this.editRequestHandler.editRequested(bindingsInfo);
    }

    public boolean isRowMultiSource(int rowIndex) {
        return this.model.isRowMultiSource(rowIndex);
    }

    public boolean isAssigned(int rowIndex) {
        return this.model.isAssigned(rowIndex);
    }

    public VDBConnectorBindingNames getObjectForRow(int rowIndex) {
        return this.model.getObjectForRow(rowIndex);
    }

    static {
        SOURCE = ConsolePlugin.Util.getString("VDBConnectorBindingAssignmentModelTable.sourceSingular");
        SOURCES = ConsolePlugin.Util.getString("VDBConnectorBindingAssignmentModelTable.sourcePlural");
        EDIT = ConsolePlugin.Util.getString("General.Edit...");
        ROW_HEIGHT = new ButtonWidget((String)"Testing").getPreferredSize().height;
    }
}

