/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.vdb;

import com.metamatrix.api.exception.MetaMatrixException;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.models.VdbManager;
import com.metamatrix.console.ui.layout.ConsoleMainFrame;
import com.metamatrix.console.ui.views.vdb.ExporterWizardPanel;
import com.metamatrix.console.ui.views.vdb.ExporterWizardPanelDialog;
import com.metamatrix.console.ui.views.vdb.TargetSelectorPanel;
import com.metamatrix.console.util.DialogUtility;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.metadata.runtime.api.VirtualDatabase;
import com.metamatrix.metadata.runtime.api.VirtualDatabaseID;
import com.metamatrix.toolbox.preference.UserPreferences;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;

public class VDBExporter {
    static final String[] VDB_EXPORT_EXTENSIONS = new String[]{"vdb"};
    static final String VDB_TYPE_FILE_DESC = "VDB Export Types (*.vdb)";
    private ConnectionInfo connection;
    private VirtualDatabase vdb;
    private String vdbName;
    private int vdbVersion;
    private TargetSelectorPanel selectorPanel = null;
    private boolean finished = false;
    private ExporterWizardPanelDialog dialog = null;

    public VDBExporter(VirtualDatabase vdb, ConnectionInfo connection) {
        this.vdb = vdb;
        this.connection = connection;
        this.vdbName = this.vdb.getName();
        VirtualDatabaseID id = (VirtualDatabaseID)this.vdb.getID();
        String versionStr = id.getVersion();
        this.vdbVersion = new Integer(versionStr);
    }

    private VdbManager getVdbManager() {
        return ModelManager.getVdbManager(this.connection);
    }

    public boolean go() {
        boolean exported = false;
        ExporterWizardPanel wizardPanel = new ExporterWizardPanel(this);
        String initialDirectory = (String)UserPreferences.getInstance().getValue("metamatrix.console.directory");
        this.selectorPanel = new TargetSelectorPanel(this.vdbName, wizardPanel, initialDirectory);
        wizardPanel.addPage(this.selectorPanel);
        wizardPanel.getFinishButton().setEnabled(true);
        wizardPanel.getCancelButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                VDBExporter.this.cancelPressed();
            }
        });
        wizardPanel.getFinishButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                VDBExporter.this.finishPressed();
            }
        });
        this.dialog = new ExporterWizardPanelDialog(this, wizardPanel);
        this.dialog.show();
        if (this.finished) {
            String fullFileName = this.selectorPanel.getSelectedFileName();
            File target = new File(fullFileName);
            boolean proceeding = true;
            if (target.exists()) {
                String hdr = "File already exists";
                String msg = "File " + fullFileName + " already exists.  Exporting " + "will overwrite its current contents.  Proceed and " + "overwrite contents of file?";
                int response = DialogUtility.displayYesNoDialog(ConsoleMainFrame.getInstance(), hdr, msg);
                proceeding = response == 0;
            } else {
                try {
                    target.createNewFile();
                }
                catch (IOException ex) {
                    StaticUtilities.displayModalDialogWithOK("Cannot create target file", "Unable to create target file " + fullFileName + ".  Must select another file name or cancel.");
                    proceeding = false;
                }
            }
            if (proceeding) {
                if (!target.canWrite()) {
                    StaticUtilities.displayModalDialogWithOK("Cannot write to target file", "Unable to write to target file " + fullFileName + ".  Must select another file name or cancel.");
                    proceeding = false;
                }
                if (proceeding) {
                    try {
                        String fileName = StaticUtilities.getFileName(fullFileName);
                        String directoryName = StaticUtilities.getDirectoryName(fullFileName);
                        this.getVdbManager().exportVDB(this.vdb, fileName, directoryName);
                        StaticUtilities.displayModalDialogWithOK("Export successful", "VDB " + this.vdbName + " version " + this.vdbVersion + " successfully exported to file " + fullFileName + ".");
                        exported = true;
                    }
                    catch (Exception ex) {
                        MetaMatrixException mex = ExceptionUtility.containsExceptionHavingCode(ex, "ERR.018.001.0021");
                        if (mex != null) {
                            String msg = "Export unsuccessful.  One or more model files for the VDB were not found.";
                            StaticUtilities.displayModalDialogWithOK("Model File not Found", msg, 0);
                        }
                        LogManager.logError((String)"VIRTUAL_DATABASE", (Throwable)ex, (String)"Error exporting VDB.");
                        ExceptionUtility.showMessage("Error exporting to file", ex);
                    }
                    if (exported) {
                        String directoryForModule = this.selectorPanel.getDirectoryName();
                        UserPreferences.getInstance().setValue("metamatrix.console.directory", directoryForModule);
                        UserPreferences.getInstance().saveChanges();
                    }
                }
            }
        }
        this.selectorPanel = null;
        wizardPanel = null;
        return exported;
    }

    public void dialogWindowClosing() {
    }

    public boolean showNextPage() {
        boolean continuing = true;
        return continuing;
    }

    public void showPreviousPage() {
    }

    private void cancelPressed() {
        this.dialog.cancelPressed();
    }

    private void finishPressed() {
        this.dialog.finishPressed();
        this.finished = true;
    }
}

