/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.vdb;

import com.metamatrix.common.log.LogManager;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.models.VdbManager;
import com.metamatrix.console.ui.views.vdb.DataNodesTreeModel;
import com.metamatrix.console.ui.views.vdb.VDBMetadataTreeNode;
import com.metamatrix.console.ui.views.vdb.VdbDisplayer;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.metadata.runtime.api.VirtualDatabase;
import com.metamatrix.metadata.runtime.api.VirtualDatabaseID;
import com.metamatrix.platform.admin.api.PermissionDataNodeTreeView;
import com.metamatrix.platform.admin.api.PermissionTreeView;
import com.metamatrix.toolbox.ui.widget.TreeWidget;
import java.awt.GridLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class VDBMetadataTreePanel
extends JPanel
implements VdbDisplayer {
    private VirtualDatabase vdb = null;
    private TreeWidget tree;
    private DataNodesTreeModel treeModel;
    private VDBMetadataTreeNode root;
    private ConnectionInfo connection = null;

    public VDBMetadataTreePanel(ConnectionInfo connection) {
        this.connection = connection;
        this.initialize();
    }

    private VdbManager getVdbManager() {
        return ModelManager.getVdbManager(this.connection);
    }

    @Override
    public void setVirtualDatabase(VirtualDatabase vdb) {
        boolean same;
        if (this.vdb == null) {
            same = vdb == null;
        } else {
            boolean bl = same = this.vdb == vdb;
        }
        if (!same) {
            this.vdb = vdb;
            if (vdb == null) {
                this.setTreeEmpty();
            } else {
                this.setTreeFromVDB();
            }
        }
    }

    private void initialize() {
        this.root = new VDBMetadataTreeNode("root", null);
        this.treeModel = new DataNodesTreeModel(this.root);
        this.tree = new TreeWidget(this.treeModel);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.setCellRenderer(DataNodesTreeModel.createCellRenderer());
        this.setLayout(new GridLayout(1, 1));
        this.add(new JScrollPane(this.tree));
    }

    private void setTreeEmpty() {
        this.root.removeAllChildren();
        this.treeModel.reload();
    }

    private void setTreeFromVDB() {
        PermissionDataNodeTreeView treeView = null;
        try {
            String vdbName = this.vdb.getName();
            VirtualDatabaseID id = (VirtualDatabaseID)this.vdb.getID();
            String vdbVersion = id.getVersion();
            treeView = this.getVdbManager().getTreeViewForVDB(vdbName, vdbVersion);
            this.root.removeAllChildren();
            this.treeModel = DataNodesTreeModel.createDefaultTreeModelFromTreeView((PermissionTreeView)treeView, this.treeModel, this.root);
            this.treeModel.reload();
        }
        catch (Exception ex) {
            String msg = "Error retrieving VDB metadata tree.";
            LogManager.logError((String)"VIRTUAL_DATABASE", (Throwable)ex, (String)msg);
            ExceptionUtility.showMessage(msg, ex);
        }
    }
}

