/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.vdb;

import com.metamatrix.metadata.runtime.api.Model;
import com.metamatrix.toolbox.ui.widget.table.DefaultTableModel;
import java.util.Arrays;
import java.util.Collection;
import java.util.Vector;

class VDBModelsPanelTableModel
extends DefaultTableModel {
    public static final String MODEL_NAME = "Model Name";
    public static final String TYPE = "Type";
    public static final String PUBLIC = "Visible";
    public static final String MULTIPLE_SOURCE = "Multiple Source";
    private static final int NUM_COLUMNS = 5;
    private static final int MODEL_NUM_COL_NUM = 0;
    private static final int TYPE_COL_NUM = 1;
    private static final int PUBLIC_COL_NUM = 2;
    private static final int MULTIPLE_SOURCE_COL_NUM = 3;
    private static final String[] COLUMN_NAMES = new String[]{"Model Name", "Type", "Visible", "Multiple Source"};

    public VDBModelsPanelTableModel() {
        super(new Vector<String>(Arrays.asList(COLUMN_NAMES)));
    }

    public void populate(Collection models) {
        this.depopulate();
        if (models != null) {
            for (Model model : models) {
                Object[] values = new Object[5];
                values[0] = model.getName();
                String modelType = model.getModelTypeName();
                values[1] = modelType;
                boolean isPublic = model.isVisible();
                values[2] = new Boolean(isPublic);
                boolean isMultipleSource = model.isMultiSourceBindingEnabled();
                values[3] = new Boolean(isMultipleSource);
                this.addRow(values);
            }
        }
    }

    private void depopulate() {
        int numRows = this.getRowCount();
        for (int i = numRows - 1; i >= 0; --i) {
            this.removeRow(i);
        }
    }

    public Class getColumnClass(int colIndex) {
        Class cls;
        switch (colIndex) {
            case 2: 
            case 3: {
                cls = Boolean.class;
                break;
            }
            default: {
                cls = String.class;
            }
        }
        return cls;
    }
}

