/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.vdb;

import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.console.ConsolePlugin;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.ui.views.connectorbinding.NewBindingWizardController;
import com.metamatrix.console.ui.views.vdb.ConnectorBindingNameAndUUID;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.console.util.StringComparator;
import com.metamatrix.toolbox.ui.widget.AccumulatorPanel;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class VDBMultiConnectorBindingAssignmentDlg
extends JDialog {
    private static final String TITLE = ConsolePlugin.Util.getString("VDBMultiConnectorBindingAssignmentDlg.title");
    private static final String OK = ConsolePlugin.Util.getString("General.OK");
    private static final String CANCEL = ConsolePlugin.Util.getString("General.Cancel");
    private static final String NEW = ConsolePlugin.Util.getString("General.New...");
    private ConnectionInfo connection = null;
    private Map bindingNameToUUIDMap;
    private boolean canceled = false;
    private ConnectorBindingNameAndUUID[] selectedBindings = new ConnectorBindingNameAndUUID[0];
    private AccumulatorPanel accumulator;

    public VDBMultiConnectorBindingAssignmentDlg(Frame parent, String modelName, List availableBindings, List assignedBindings, Map bindingNameToUUIDMap, ConnectionInfo connection) {
        super(parent);
        this.bindingNameToUUIDMap = bindingNameToUUIDMap;
        this.connection = connection;
        this.setTitle(TITLE + ' ' + modelName);
        this.setModal(true);
        this.createComponent(availableBindings, assignedBindings);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent ev) {
                VDBMultiConnectorBindingAssignmentDlg.this.cancelPressed();
            }
        });
    }

    private void createComponent(List availableBindings, List assignedBindings) {
        GridBagLayout layout = new GridBagLayout();
        this.getContentPane().setLayout(layout);
        ButtonWidget newButton = new ButtonWidget(NEW);
        newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                VDBMultiConnectorBindingAssignmentDlg.this.newButtonPressed();
            }
        });
        JButton[] buttonArray = new JButton[]{newButton};
        this.accumulator = new AccumulatorPanel(availableBindings, assignedBindings, buttonArray, new StringComparator(true));
        this.accumulator.getAcceptButton().setVisible(false);
        this.accumulator.getResetButton().setVisible(false);
        this.accumulator.getCancelButton().setVisible(false);
        this.getContentPane().add(this.accumulator);
        layout.setConstraints(this.accumulator, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        JPanel buttonsPanel = new JPanel();
        GridLayout buttonsPanelLayout = new GridLayout(1, 2, 10, 0);
        buttonsPanel.setLayout(buttonsPanelLayout);
        ButtonWidget okButton = new ButtonWidget(OK);
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                VDBMultiConnectorBindingAssignmentDlg.this.okPressed();
            }
        });
        ButtonWidget cancelButton = new ButtonWidget(CANCEL);
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                VDBMultiConnectorBindingAssignmentDlg.this.cancelPressed();
            }
        });
        buttonsPanel.add(okButton);
        buttonsPanel.add(cancelButton);
        this.getContentPane().add(buttonsPanel);
        layout.setConstraints(buttonsPanel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(8, 8, 4, 8), 0, 0));
        this.pack();
        Dimension oldSize = this.getSize();
        Dimension newSize = new Dimension(oldSize.width, (int)Math.min((double)oldSize.height, (double)Toolkit.getDefaultToolkit().getScreenSize().height * 0.8));
        this.setSize(newSize);
        this.setLocation(StaticUtilities.centerFrame(this.getSize()));
    }

    private void cancelPressed() {
        this.canceled = true;
        this.dispose();
    }

    private void okPressed() {
        this.setSelectedBindings();
        this.dispose();
    }

    private void newButtonPressed() {
        NewBindingWizardController controller = new NewBindingWizardController(this.connection);
        ConnectorBinding connectorBinding = (ConnectorBinding)controller.runWizard();
        if (connectorBinding != null) {
            this.accumulator.addAvailableValue(connectorBinding.getName());
            this.bindingNameToUUIDMap.put(connectorBinding.getName(), connectorBinding.getRoutingUUID());
        }
    }

    private void setSelectedBindings() {
        List values = this.accumulator.getValues();
        this.selectedBindings = new ConnectorBindingNameAndUUID[values.size()];
        Iterator it = values.iterator();
        int i = 0;
        while (it.hasNext()) {
            String bindingName = (String)it.next();
            String bindingUUID = (String)this.bindingNameToUUIDMap.get(bindingName);
            this.selectedBindings[i] = new ConnectorBindingNameAndUUID(bindingName, bindingUUID);
            ++i;
        }
    }

    public ConnectorBindingNameAndUUID[] getSelectedBindings() {
        return this.selectedBindings;
    }

    public boolean wasCanceled() {
        return this.canceled;
    }
}

