/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.vdb;

import com.metamatrix.admin.api.exception.AdminException;
import com.metamatrix.admin.api.server.ServerAdmin;
import com.metamatrix.api.exception.security.LogonException;
import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.ui.layout.ConsoleMainFrame;
import com.metamatrix.console.ui.views.vdb.RolesExporterWizardPanel;
import com.metamatrix.console.ui.views.vdb.RolesExporterWizardPanelDialog;
import com.metamatrix.console.ui.views.vdb.RolesTargetSelectorPanel;
import com.metamatrix.console.util.DialogUtility;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.core.util.FileUtil;
import com.metamatrix.metadata.runtime.api.VirtualDatabase;
import com.metamatrix.metadata.runtime.api.VirtualDatabaseID;
import com.metamatrix.toolbox.preference.UserPreferences;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;

public class VDBRolesExporter {
    static final String VDB_ROLES_DEFAULT_EXT = "xml";
    static final String[] VDB_ROLES_EXPORT_EXTENSIONS = new String[]{"xml"};
    static final String VDB_ROLES_TYPE_FILE_DESC = "VDB Roles Export Types (*.xml)";
    private ConnectionInfo connection;
    private VirtualDatabase vdb;
    private String vdbName;
    private String vdbVersionStr;
    private int vdbVersion;
    private RolesTargetSelectorPanel selectorPanel = null;
    private boolean finished = false;
    private RolesExporterWizardPanelDialog dialog = null;

    public VDBRolesExporter(VirtualDatabase vdb, ConnectionInfo connection) {
        this.vdb = vdb;
        this.connection = connection;
        this.vdbName = this.vdb.getName();
        VirtualDatabaseID id = (VirtualDatabaseID)this.vdb.getID();
        this.vdbVersionStr = id.getVersion();
        this.vdbVersion = new Integer(this.vdbVersionStr);
    }

    public boolean go() {
        boolean exported = false;
        RolesExporterWizardPanel wizardPanel = new RolesExporterWizardPanel(this);
        String initialDirectory = (String)UserPreferences.getInstance().getValue("metamatrix.console.directory");
        this.selectorPanel = new RolesTargetSelectorPanel(this.vdbName, this.vdbVersion, wizardPanel, initialDirectory);
        wizardPanel.addPage(this.selectorPanel);
        wizardPanel.getFinishButton().setEnabled(true);
        wizardPanel.getCancelButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                VDBRolesExporter.this.cancelPressed();
            }
        });
        wizardPanel.getFinishButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                VDBRolesExporter.this.finishPressed();
            }
        });
        this.dialog = new RolesExporterWizardPanelDialog(this, wizardPanel);
        this.dialog.show();
        if (this.finished) {
            String fullFileName = this.selectorPanel.getSelectedFileFullName();
            File target = new File(fullFileName);
            boolean proceeding = true;
            if (target.exists()) {
                String hdr = "File already exists";
                String msg = "File " + fullFileName + " already exists.  Exporting " + "will overwrite its current contents.  Proceed and " + "overwrite contents of file?";
                int response = DialogUtility.displayYesNoDialog(ConsoleMainFrame.getInstance(), hdr, msg);
                proceeding = response == 0;
            } else {
                try {
                    target.createNewFile();
                }
                catch (IOException ex) {
                    StaticUtilities.displayModalDialogWithOK("Cannot create target file", "Unable to create target file " + fullFileName + ".  Must select another file name or cancel.");
                    proceeding = false;
                }
            }
            if (proceeding) {
                if (!target.canWrite()) {
                    StaticUtilities.displayModalDialogWithOK("Cannot write to target file", "Unable to write to target file " + fullFileName + ".  Must select another file name or cancel.");
                    proceeding = false;
                }
                if (proceeding) {
                    try {
                        this.exportVdbRoles(this.vdbName, this.vdbVersionStr, fullFileName);
                        StaticUtilities.displayModalDialogWithOK("Export Roles successful", "Roles for VDB " + this.vdbName + " version " + this.vdbVersion + " successfully exported to file " + fullFileName + ".");
                        exported = true;
                    }
                    catch (Exception ex) {
                        LogManager.logError((String)"VIRTUAL_DATABASE", (Throwable)ex, (String)"Error exporting VDB Roles.");
                        ExceptionUtility.showMessage("Error exporting VDB Roles", ex);
                    }
                    if (exported) {
                        String directoryForModule = this.selectorPanel.getDirectoryName();
                        UserPreferences.getInstance().setValue("metamatrix.console.directory", directoryForModule);
                        UserPreferences.getInstance().saveChanges();
                    }
                }
            }
        }
        this.selectorPanel = null;
        wizardPanel = null;
        return exported;
    }

    public void dialogWindowClosing() {
    }

    public boolean showNextPage() {
        boolean continuing = true;
        return continuing;
    }

    public void showPreviousPage() {
    }

    private void cancelPressed() {
        this.dialog.cancelPressed();
    }

    private void finishPressed() {
        this.dialog.finishPressed();
        this.finished = true;
    }

    private void exportVdbRoles(String vdbName, String vdbVersion, String fullFileName) throws LogonException, AdminException, CommunicationException {
        ServerAdmin admin = this.connection.getServerAdmin();
        char[] chars = admin.exportDataRoles(vdbName, vdbVersion);
        if (chars == null) {
            // empty if block
        }
        FileUtil util = new FileUtil(fullFileName);
        util.write(new String(chars));
    }
}

