/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.vdb;

import com.metamatrix.console.ui.util.BasicWizardSubpanelContainer;
import com.metamatrix.console.ui.util.WizardInterface;
import com.metamatrix.console.ui.views.vdb.ModelVisibilityInfo;
import com.metamatrix.console.ui.views.vdb.NewVDBWizardModelVisibilityTable;
import com.metamatrix.console.util.StaticUtilities;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class VDBWizardModelVisibilityPanel
extends BasicWizardSubpanelContainer {
    private NewVDBWizardModelVisibilityTable table;
    private boolean[] currentVisibilityCheckBoxesState = null;
    private boolean tablePopulated = false;
    private ModelVisibilityInfo[] infoPopulatedFrom = null;
    private int panelOrder;

    public VDBWizardModelVisibilityPanel(int step, WizardInterface wizardInterface) {
        super(wizardInterface);
        this.panelOrder = step;
        JPanel panel = this.init();
        super.setMainContent(panel);
        String[] paragraphs = new String[]{"Check or uncheck the \"Visible\" column to set the visibility for each model.  Only models checked as \"Visible\"can be used in queries.  Check or uncheck the \"Multiple Source\" column to indicate whether or not a model may have multiple data sources.", "Note: Visibility and multiple-source availability cannot be changed for a model once a Virtual Database has been created."};
        super.setStepText(this.panelOrder, true, "Set Model Properties", paragraphs);
        this.table.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent ev) {
                VDBWizardModelVisibilityPanel.this.tableWasChanged();
            }
        });
    }

    private JPanel init() {
        JPanel panel = new JPanel();
        this.table = new NewVDBWizardModelVisibilityTable();
        JScrollPane scrollPane = new JScrollPane(this.table);
        GridBagLayout layout = new GridBagLayout();
        panel.setLayout(layout);
        panel.add(scrollPane);
        layout.setConstraints(scrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(4, 4, 4, 4), 0, 0));
        return panel;
    }

    public void populateTable(ModelVisibilityInfo[] info) {
        this.table.populateTable(info);
        this.tablePopulated = true;
        this.infoPopulatedFrom = info;
    }

    public boolean modelsMatch(ModelVisibilityInfo[] info) {
        boolean match = false;
        if (this.infoPopulatedFrom != null && info.length == this.infoPopulatedFrom.length) {
            boolean mismatchFound = false;
            for (int i = 0; i < info.length && !mismatchFound; ++i) {
                if (!info[i].getModelName().equals(this.infoPopulatedFrom[i].getModelName())) {
                    mismatchFound = true;
                    continue;
                }
                if (info[i].getModelType().equals(this.infoPopulatedFrom[i].getModelType())) continue;
                mismatchFound = true;
            }
            if (!mismatchFound) {
                match = true;
            }
        }
        return match;
    }

    public boolean isTablePopulated() {
        return this.tablePopulated;
    }

    public ModelVisibilityInfo[] getUpdatedVisibilityInfo() {
        return this.table.getUpdatedVisibilityInfo();
    }

    public void tableWasChanged() {
        if (this.currentVisibilityCheckBoxesState != null) {
            boolean[] newVisibilityCheckBoxesState = this.visibilityState();
            if (this.currentVisibilityCheckBoxesState.length != newVisibilityCheckBoxesState.length) {
                this.currentVisibilityCheckBoxesState = newVisibilityCheckBoxesState;
            } else if (!this.visibilityMatchesCurrent(newVisibilityCheckBoxesState)) {
                AbstractButton forwardButton = this.getWizardInterface().getForwardButton();
                boolean nextEnabled = forwardButton.isEnabled();
                boolean shouldBeEnabled = this.table.anyPublic();
                if (shouldBeEnabled != nextEnabled) {
                    forwardButton.setEnabled(shouldBeEnabled);
                    if (!shouldBeEnabled) {
                        StaticUtilities.displayModalDialogWithOK(this.getWizardInterface().getOwner(), "Visible Model Required", "Must check at least one model as Visible.");
                    }
                }
                this.currentVisibilityCheckBoxesState = newVisibilityCheckBoxesState;
            }
        } else {
            this.currentVisibilityCheckBoxesState = this.visibilityState();
        }
    }

    private boolean[] visibilityState() {
        boolean[] visible = null;
        if (this.table != null) {
            int numRows = this.table.getRowCount();
            visible = new boolean[numRows];
            for (int i = 0; i < numRows; ++i) {
                visible[i] = this.table.publicCheckedForRow(i);
            }
        }
        return visible;
    }

    private boolean visibilityMatchesCurrent(boolean[] newVisibility) {
        boolean mismatchFound = false;
        int i = 0;
        while (i < newVisibility.length && !mismatchFound) {
            if (this.currentVisibilityCheckBoxesState[i] != newVisibility[i]) {
                mismatchFound = true;
                continue;
            }
            ++i;
        }
        return !mismatchFound;
    }
}

