/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.vdb;

import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.config.api.ServiceComponentDefn;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.vdb.api.VDBDefn;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.ConnectorManager;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.notification.AddedConnectorBindingNotification;
import com.metamatrix.console.ui.ViewManager;
import com.metamatrix.console.ui.layout.WorkspaceController;
import com.metamatrix.console.ui.util.ColumnSortInfo;
import com.metamatrix.console.ui.views.connectorbinding.ConnectorAndBinding;
import com.metamatrix.console.ui.views.connectorbinding.NewBindingWizardController;
import com.metamatrix.console.ui.views.vdb.ConnectorBindingNameAndUUID;
import com.metamatrix.console.ui.views.vdb.ModelWrapper;
import com.metamatrix.console.ui.views.vdb.MultiSourceModelBindingEditRequestHandler;
import com.metamatrix.console.ui.views.vdb.VDBConnectorBindingAssignmentModelTable;
import com.metamatrix.console.ui.views.vdb.VDBConnectorBindingNames;
import com.metamatrix.console.ui.views.vdb.VDBMultiConnectorBindingAssignmentDlg;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.toolbox.ui.widget.TableWidget;
import com.metamatrix.toolbox.ui.widget.table.DefaultTableModel;
import com.metamatrix.toolbox.ui.widget.table.EnhancedTableColumn;
import com.metamatrix.toolbox.ui.widget.table.EnhancedTableColumnModel;
import com.metamatrix.toolbox.ui.widget.table.TableColumnSortListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class VdbAssignConnBindPanel
extends JPanel
implements MultiSourceModelBindingEditRequestHandler {
    public static final String CONNECTOR_BINDINGS_HDR = "Connector Bindings";
    public static final String MODEL_NAME_HDR = VDBConnectorBindingAssignmentModelTable.MODEL_NAME;
    private BorderLayout borderLayout1 = new BorderLayout();
    private JPanel pnlOuter = new JPanel();
    private JPanel pnlModelsTable = new JPanel();
    private JPanel pnlConnBindTable = new JPanel();
    private JPanel pnlAssignButtons = new JPanel();
    private JScrollPane scpConnBindScroller = new JScrollPane();
    private TableWidget tblConnBinds = new TableWidget();
    private ColumnSortInfo[] connBindsSortInfo = null;
    private VDBConnectorBindingAssignmentModelTable tblModels = null;
    private ColumnSortInfo[] modelsSortInfo = null;
    private JButton btnAssign = new JButton();
    private JButton btnUnassign = new JButton();
    private JButton btnNewConnectorBinding = new JButton();
    private BorderLayout borderLayout2 = new BorderLayout();
    private BorderLayout borderLayout3 = new BorderLayout();
    private ListSelectionModel smConnBindsSelModel = null;
    private ListSelectionModel smModelsSelModel = null;
    private String sSelectedConnBind = "";
    private static final int CONN_BIND_COL_IN_TBL_CONN_BIND = 0;
    private static final int CONN_BIND_COL_IN_TBL_MODELS = 1;
    private static final int MODEL_COL_IN_TBL_MODELS = 0;
    private boolean bAssignableRowSelectedInModelsTable = false;
    private boolean bUnassignableRowSelectedInModelsTable = false;
    private boolean bRowSelectedInConnBindTable = false;
    private int[] aryModelsTableSelectedRows = null;
    private ArrayList arylConnBinds = null;
    private HashMap hmConnBindsXref = new HashMap();
    private String[] aryCBColNames = new String[]{"Connector Bindings"};
    private Map mapModelsToBindings = null;
    private HashMap hmUUIDConnectorBindingsMap = null;
    private Map addTohmUUIDConnectorBindingsMap = null;
    private Collection addToListOfBindings = null;
    private boolean vdbACBPInitSuccessful = true;
    private ConnectionInfo connection;
    private Map migratedBindings = null;
    private Map vdbBindings = null;

    public VdbAssignConnBindPanel(ConnectionInfo connection) {
        this.connection = connection;
        try {
            this.jbInit();
            this.setConnBindTableListening();
            this.setModelsTableListening();
            this.tblConnBinds.setSortable(true);
            this.tblModels.setSortable(true);
            this.setInitialTableSorting();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private ConnectorManager getConnectorManager() {
        return ModelManager.getConnectorManager(this.connection);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension startingSize = super.getPreferredSize();
        int newWidth = Math.max(startingSize.width, (int)((double)Toolkit.getDefaultToolkit().getScreenSize().width * 0.625));
        return new Dimension(newWidth, startingSize.height);
    }

    private String getSelectedConnBind() {
        return this.sSelectedConnBind;
    }

    private void setConnBindTableListening() {
        this.tblConnBinds.setSelectionMode(0);
        this.smConnBindsSelModel = this.tblConnBinds.getSelectionModel();
        this.smConnBindsSelModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                int iTrueModelRow = 0;
                if (!lsm.isSelectionEmpty()) {
                    iTrueModelRow = VdbAssignConnBindPanel.this.tblConnBinds.convertRowIndexToModel(lsm.getMinSelectionIndex());
                    VdbAssignConnBindPanel.this.updateSelectionForConnBindTable(iTrueModelRow);
                } else {
                    VdbAssignConnBindPanel.this.updateDeselectionForConnBindTable();
                }
            }
        });
        EnhancedTableColumnModel etcm = this.tblConnBinds.getEnhancedColumnModel();
        etcm.addColumnSortListener(new TableColumnSortListener(){

            @Override
            public void columnSorted() {
                VdbAssignConnBindPanel.this.tblConnBinds.clearSelection();
                VdbAssignConnBindPanel.this.updateDeselectionForConnBindTable();
            }
        });
    }

    private void updateSelectionForConnBindTable(int iRow) {
        String sSelectedConnBind = "";
        sSelectedConnBind = (String)this.tblConnBinds.getModel().getValueAt(iRow, 0);
        this.setSelectedConnBind(sSelectedConnBind);
        this.bRowSelectedInConnBindTable = true;
        this.enableAssignButtons();
    }

    private void updateDeselectionForConnBindTable() {
        this.setSelectedConnBind("");
        this.bRowSelectedInConnBindTable = false;
        this.enableAssignButtons();
    }

    private void setSelectedConnBind(String sSelectedConnBind) {
        this.sSelectedConnBind = sSelectedConnBind;
    }

    public void setVDBVersion(VDBDefn vdb) {
        this.vdbBindings = this.getBindingsFromVDB(vdb);
        this.mapModelsToBindings = this.migratedBindings == null ? this.vdbBindings : this.migratedBindings;
        this.setAdditionalBindings(vdb.getConnectorBindings());
        this.loadAvailableBindings(null);
    }

    private Map getBindingsFromVDB(VDBDefn vdb) {
        Map tempMap = vdb.getModelToBindingMappings();
        HashMap<String, ConnectorBindingNameAndUUID[]> newMap = new HashMap<String, ConnectorBindingNameAndUUID[]>();
        for (Map.Entry me : tempMap.entrySet()) {
            String modelName = (String)me.getKey();
            List uuids = (List)me.getValue();
            ArrayList<ConnectorBindingNameAndUUID> newList = new ArrayList<ConnectorBindingNameAndUUID>(uuids.size());
            for (String uuid : uuids) {
                ConnectorBinding cb = vdb.getConnectorBindingByRouting(uuid);
                String bindingName = cb.getName();
                newList.add(new ConnectorBindingNameAndUUID(bindingName, uuid));
            }
            ConnectorBindingNameAndUUID[] bindingNames = new ConnectorBindingNameAndUUID[newList.size()];
            Iterator ix = newList.iterator();
            int i = 0;
            while (ix.hasNext()) {
                bindingNames[i] = (ConnectorBindingNameAndUUID)ix.next();
                ++i;
            }
            newMap.put(modelName, bindingNames);
        }
        return newMap;
    }

    private void setBindingsFromMap(Map bindingsMap) throws Exception {
        this.mapModelsToBindings = bindingsMap;
    }

    public void refreshBindingMap() {
        this.refreshBindingsTable(true);
    }

    private void setAdditionalBindings(Map addBindings) {
        if (addBindings == null || addBindings.isEmpty()) {
            return;
        }
        this.addTohmUUIDConnectorBindingsMap = new HashMap(addBindings.size());
        for (String bname : addBindings.keySet()) {
            ConnectorBinding cb = (ConnectorBinding)addBindings.get(bname);
            this.addTohmUUIDConnectorBindingsMap.put(cb.getRoutingUUID(), cb.getName());
        }
        this.addToListOfBindings = addBindings.values();
    }

    private void refreshBindingsTable(boolean refresh) {
        String sModelName = "";
        try {
            this.hmUUIDConnectorBindingsMap = this.getConnectorManager().getUUIDConnectorBindingsMap(true);
            if (this.addTohmUUIDConnectorBindingsMap != null) {
                this.hmUUIDConnectorBindingsMap.putAll(this.addTohmUUIDConnectorBindingsMap);
            }
        }
        catch (Exception e) {
            ExceptionUtility.showMessage("Failed retrieving UUID-ConnBind Map", e);
            this.vdbACBPInitSuccessful = false;
        }
        if (refresh && this.mapModelsToBindings != null) {
            int iRowCount = this.tblModels.getModel().getRowCount();
            for (int ixRow = 0; ixRow < iRowCount; ++ixRow) {
                sModelName = (String)this.tblModels.getModel().getValueAt(ixRow, 0);
                ConnectorBindingNameAndUUID[] bindings = (ConnectorBindingNameAndUUID[])this.mapModelsToBindings.get(sModelName);
                if (bindings == null) continue;
                VDBConnectorBindingNames bindingNames = this.tblModels.getObjectForRow(ixRow);
                bindingNames.setBindings(bindings);
                this.tblModels.reviseRow(bindingNames, ixRow);
            }
        }
        this.saveColumnSortInfo();
        this.setTableAttributes();
        this.restoreColumnSortOrder();
    }

    public void updateMultiSource(Map multiSourceInfo) {
        this.tblModels.updateMultiSource(multiSourceInfo);
    }

    public boolean getVdbACBPSuccessful() {
        return this.vdbACBPInitSuccessful;
    }

    private void setModelsTableListening() {
        this.tblModels.setSelectionMode(2);
        this.smModelsSelModel = this.tblModels.getSelectionModel();
        this.smModelsSelModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (!lsm.isSelectionEmpty()) {
                    VdbAssignConnBindPanel.this.updateSelectionForModelsTable();
                } else {
                    VdbAssignConnBindPanel.this.updateDeselectionForModelsTable();
                }
            }
        });
        EnhancedTableColumnModel etcm = this.tblModels.getEnhancedColumnModel();
        etcm.addColumnSortListener(new TableColumnSortListener(){

            @Override
            public void columnSorted() {
                VdbAssignConnBindPanel.this.tblModels.clearSelection();
                VdbAssignConnBindPanel.this.updateDeselectionForModelsTable();
            }
        });
    }

    public void updateSelectionForModelsTable() {
        this.aryModelsTableSelectedRows = this.tblModels.getSelectedRows();
        if (this.aryModelsTableSelectedRows.length > 0) {
            this.bAssignableRowSelectedInModelsTable = false;
            this.bUnassignableRowSelectedInModelsTable = false;
            for (int i = 0; !(i >= this.aryModelsTableSelectedRows.length || this.bAssignableRowSelectedInModelsTable && this.bUnassignableRowSelectedInModelsTable); ++i) {
                int modelRowIndex = this.tblModels.convertRowIndexToModel(this.aryModelsTableSelectedRows[i]);
                if (this.tblModels.isRowMultiSource(modelRowIndex)) continue;
                this.bAssignableRowSelectedInModelsTable = true;
                if (!this.tblModels.isAssigned(modelRowIndex)) continue;
                this.bUnassignableRowSelectedInModelsTable = true;
            }
        } else {
            this.bAssignableRowSelectedInModelsTable = false;
            this.bUnassignableRowSelectedInModelsTable = false;
        }
        this.enableAssignButtons();
    }

    private void updateDeselectionForModelsTable() {
        this.bAssignableRowSelectedInModelsTable = false;
        this.bUnassignableRowSelectedInModelsTable = false;
        this.enableAssignButtons();
    }

    private void enableAssignButtons() {
        this.btnAssign.setEnabled(this.bAssignableRowSelectedInModelsTable && this.bRowSelectedInConnBindTable);
        this.btnUnassign.setEnabled(this.bUnassignableRowSelectedInModelsTable);
    }

    private void processAssignButton() {
        this.applyStringToSelectedModels(this.getSelectedConnBind());
        this.reselectModelsTableSelectedRows();
        this.bUnassignableRowSelectedInModelsTable = true;
        this.enableAssignButtons();
    }

    private void reselectModelsTableSelectedRows() {
        int iTrueRow = 0;
        this.aryModelsTableSelectedRows = this.tblModels.getSelectedRows();
        if (this.aryModelsTableSelectedRows.length > 0) {
            for (int ixRow = 0; ixRow < this.aryModelsTableSelectedRows.length; ++ixRow) {
                iTrueRow = this.aryModelsTableSelectedRows[ixRow];
                this.tblModels.addRowSelectionInterval(iTrueRow, iTrueRow);
            }
        }
    }

    private void processUnassignButton() {
        this.applyStringToSelectedModels("");
        this.bUnassignableRowSelectedInModelsTable = false;
        this.enableAssignButtons();
    }

    private void processNewBindingButton() {
        ServiceComponentDefn scdNewBinding = this.doNewBindingWizard();
        if (scdNewBinding != null) {
            this.loadAvailableBindings(scdNewBinding.getName());
        }
    }

    private void loadAvailableBindings(String bindingName) {
        this.tblConnBinds.setModel(this.getConnBindsTableModel());
        this.refreshBindingsTable(bindingName == null);
        if (bindingName != null) {
            this.selectConnBindByName(bindingName);
        }
        WorkspaceController.getInstance().handleUpdateNotification(this.connection, new AddedConnectorBindingNotification());
    }

    private void selectConnBindByName(String sConnBindName) {
        int iTargetRow = 0;
        boolean bFoundRow = false;
        for (int iRow = 0; iRow < this.tblConnBinds.getRowCount(); ++iRow) {
            String sAConnBindName = (String)this.tblConnBinds.getValueAt(iRow, 0);
            if (!sAConnBindName.equals(sConnBindName)) continue;
            iTargetRow = iRow;
            bFoundRow = true;
            break;
        }
        if (bFoundRow) {
            this.tblConnBinds.getSelectionModel().setSelectionInterval(iTargetRow, iTargetRow);
        }
    }

    private ServiceComponentDefn doNewBindingWizard() {
        NewBindingWizardController controller = new NewBindingWizardController(this.connection);
        ServiceComponentDefn binding = controller.runWizard();
        return binding;
    }

    private void applyStringToSelectedModels(String s) {
        this.aryModelsTableSelectedRows = this.tblModels.getSelectedRows();
        ConnectorBinding cb = (ConnectorBinding)this.hmConnBindsXref.get(s);
        String uuid = null;
        if (cb != null) {
            uuid = cb.getRoutingUUID();
        }
        for (int ixRow = 0; ixRow < this.aryModelsTableSelectedRows.length; ++ixRow) {
            int iTrueRow = this.aryModelsTableSelectedRows[ixRow];
            VDBConnectorBindingNames bindingInfo = (VDBConnectorBindingNames)this.tblModels.getValueAt(iTrueRow, 1);
            if (bindingInfo.isMultiSource()) continue;
            bindingInfo = bindingInfo.copy();
            ConnectorBindingNameAndUUID[] newBindings = s.trim().length() > 0 ? new ConnectorBindingNameAndUUID[]{new ConnectorBindingNameAndUUID(s, uuid)} : new ConnectorBindingNameAndUUID[]{};
            bindingInfo.setBindings(newBindings);
            this.tblModels.reviseRow(bindingInfo);
        }
        this.tblModels.repaint();
    }

    public Map getModelsToConnectorBindingsMap() {
        HashMap hmap = new HashMap();
        DefaultTableModel tmdl = (DefaultTableModel)this.tblModels.getModel();
        int iRowCount = tmdl.getRowCount();
        int iModelColumn = 0;
        int iConnBindColumn = 1;
        String sModelName = "";
        String sParsedModelName = "";
        for (int x = 0; x < iRowCount; ++x) {
            sModelName = (String)tmdl.getValueAt(x, iModelColumn);
            sParsedModelName = this.parseModelName(sModelName);
            VDBConnectorBindingNames bindings = (VDBConnectorBindingNames)tmdl.getValueAt(x, iConnBindColumn);
            ConnectorBindingNameAndUUID[] bindingNames = bindings.getBindings();
            ArrayList<String> bindingUUIDs = new ArrayList<String>(bindingNames.length);
            for (int i = 0; i < bindingNames.length; ++i) {
                bindingUUIDs.add(bindingNames[i].getUUID());
            }
            hmap.put(sParsedModelName, bindingUUIDs);
        }
        return hmap;
    }

    private String parseModelName(String sModelNameDottedName) {
        String sWorkString = sModelNameDottedName;
        String sDot = ".";
        String sResult = "";
        int iDotPos = sWorkString.indexOf(sDot);
        if (iDotPos > -1) {
            sWorkString = sWorkString.substring(0, iDotPos);
        }
        sResult = sWorkString;
        return sResult;
    }

    private void setTableAttributes() {
        this.tblConnBinds.setAutoResizeMode(0);
        this.tblConnBinds.setColumnSelectionAllowed(false);
        this.tblConnBinds.setEditable(false);
        this.tblConnBinds.sizeColumnsToFitData(100);
        this.tblConnBinds.setRowHeight(VDBConnectorBindingAssignmentModelTable.ROW_HEIGHT);
        this.tblModels.setAutoResizeMode(0);
        this.tblModels.setColumnSelectionAllowed(false);
    }

    private void jbInit() throws Exception {
        this.tblModels = new VDBConnectorBindingAssignmentModelTable(this);
        this.setTableAttributes();
        this.setLayout(this.borderLayout1);
        this.pnlOuter.setLayout(new GridBagLayout());
        this.scpConnBindScroller.setPreferredSize(new Dimension(300, 220));
        this.btnAssign.setText("Assign >");
        this.btnUnassign.setText("< Unassign");
        this.btnNewConnectorBinding.setText("New...");
        this.btnAssign.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                VdbAssignConnBindPanel.this.processAssignButton();
            }
        });
        this.btnUnassign.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                VdbAssignConnBindPanel.this.processUnassignButton();
            }
        });
        this.btnNewConnectorBinding.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                VdbAssignConnBindPanel.this.processNewBindingButton();
            }
        });
        this.btnAssign.setEnabled(false);
        this.btnUnassign.setEnabled(false);
        this.btnNewConnectorBinding.setEnabled(true);
        this.pnlModelsTable.setLayout(this.borderLayout2);
        this.pnlConnBindTable.setLayout(this.borderLayout3);
        this.add((Component)this.pnlOuter, "Center");
        this.pnlConnBindTable.add((Component)this.scpConnBindScroller, "Center");
        this.scpConnBindScroller.getViewport().add((Component)this.tblConnBinds, null);
        this.pnlAssignButtons.setLayout(new GridLayout(3, 1, 5, 15));
        this.pnlAssignButtons.add((Component)this.btnAssign, null);
        this.pnlAssignButtons.add((Component)this.btnUnassign, null);
        this.pnlAssignButtons.add((Component)this.btnNewConnectorBinding, null);
        this.tblConnBinds.setModel(this.getConnBindsTableModel());
        JScrollPane scpModelsScroller = new JScrollPane(this.tblModels);
        this.pnlModelsTable.add((Component)scpModelsScroller, "Center");
        this.tblModels.setContainerScrollPane(scpModelsScroller);
        this.sortConnBindTable();
        this.pnlOuter.add((Component)this.pnlConnBindTable, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 13, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.pnlOuter.add((Component)this.pnlAssignButtons, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.pnlOuter.add((Component)this.pnlModelsTable, new GridBagConstraints(2, 0, 1, 1, 2.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.setTableAttributes();
    }

    private void sortConnBindTable() {
        EnhancedTableColumnModel etcmConnBinds = this.tblConnBinds.getEnhancedColumnModel();
        etcmConnBinds.getColumn(0);
    }

    private void sortModelsTable() {
        EnhancedTableColumnModel etcmModels = this.tblModels.getEnhancedColumnModel();
        etcmModels.getColumn(0);
    }

    public void setModels(Collection colModels) {
        Collection displayableModels = this.getDisplayableModels(colModels);
        this.setModelsTableData(displayableModels);
        this.setTableAttributes();
        this.sortModelsTable();
        this.sortConnBindTable();
    }

    private Collection getDisplayableModels(Collection models) {
        ArrayList<ModelWrapper> displayableModels = new ArrayList<ModelWrapper>();
        for (ModelWrapper mw : models) {
            boolean isDisplayable = mw.requiresConnectorBinding();
            if (!isDisplayable) continue;
            displayableModels.add(mw);
        }
        return displayableModels;
    }

    private void setModelsTableData(Collection colModels) {
        HashMap hmConnBindUUIDToName = null;
        try {
            hmConnBindUUIDToName = this.getConnectorManager().getUUIDConnectorBindingsMap(true);
        }
        catch (Exception ex) {
            String msg = "Exception retrieving existing connector bindings.";
            LogManager.logError((String)"CONNECTOR_BINDINGS", (Throwable)ex, (String)msg);
            ExceptionUtility.showMessage(msg, ex);
        }
        if (hmConnBindUUIDToName != null) {
            ArrayList<VDBConnectorBindingNames> rows = new ArrayList<VDBConnectorBindingNames>();
            for (ModelWrapper mdlWrapper : colModels) {
                String modelName = mdlWrapper.getName();
                boolean supportsMultiSource = mdlWrapper.isMultiSourceBindingsEnabled();
                List bindingUUIDs = mdlWrapper.getConnectorBindingNames();
                ArrayList<ConnectorBindingNameAndUUID> bindingsList = new ArrayList<ConnectorBindingNameAndUUID>(bindingUUIDs.size());
                for (String bindingUUID : bindingUUIDs) {
                    String bindingName = (String)hmConnBindUUIDToName.get(bindingUUID);
                    if (bindingName == null || bindingName.trim().length() <= 0) continue;
                    bindingsList.add(new ConnectorBindingNameAndUUID(bindingName, bindingUUID));
                }
                ConnectorBindingNameAndUUID[] bindingsArray = new ConnectorBindingNameAndUUID[bindingsList.size()];
                Iterator iter = bindingsList.iterator();
                int i = 0;
                while (iter.hasNext()) {
                    bindingsArray[i] = (ConnectorBindingNameAndUUID)iter.next();
                    ++i;
                }
                rows.add(new VDBConnectorBindingNames(modelName, bindingsArray, supportsMultiSource));
            }
            Iterator it = rows.iterator();
            VDBConnectorBindingNames[] array = new VDBConnectorBindingNames[rows.size()];
            int i = 0;
            while (it.hasNext()) {
                array[i] = (VDBConnectorBindingNames)it.next();
                ++i;
            }
            this.tblModels.populate(array);
        }
    }

    private DefaultTableModel getConnBindsTableModel() {
        DefaultTableModel tmdl = new DefaultTableModel(new Vector<String>(Arrays.asList(this.aryCBColNames)));
        try {
            this.arylConnBinds = this.getConnectorManager().getConnectorBindings(false);
        }
        catch (Exception e) {
            ExceptionUtility.showMessage("Failed to retrieve Connector Bindings", e);
            this.vdbACBPInitSuccessful = false;
        }
        this.hmConnBindsXref.clear();
        Iterator itConnBinds = this.arylConnBinds.iterator();
        while (itConnBinds.hasNext()) {
            ServiceComponentDefn scdTemp = ((ConnectorAndBinding)itConnBinds.next()).getBinding();
            this.hmConnBindsXref.put(scdTemp.toString(), scdTemp);
            Vector<String> vCBRow = new Vector<String>();
            vCBRow.add(scdTemp.toString());
            tmdl.addRow(vCBRow.toArray());
        }
        if (this.addToListOfBindings != null) {
            for (ConnectorBinding cb : this.addToListOfBindings) {
                String key = cb.toString();
                if (this.hmConnBindsXref.containsKey(key)) continue;
                this.hmConnBindsXref.put(key, cb);
                Vector<String> vCBRow = new Vector<String>();
                vCBRow.add(cb.toString());
                tmdl.addRow(vCBRow.toArray());
            }
        }
        return tmdl;
    }

    private void setInitialTableSorting() {
        EnhancedTableColumn bndgColumn = (EnhancedTableColumn)this.tblConnBinds.getColumn(CONNECTOR_BINDINGS_HDR);
        this.tblConnBinds.setColumnSortedAscending(bndgColumn, false);
        EnhancedTableColumn mdlNameColumn = (EnhancedTableColumn)this.tblModels.getColumn(MODEL_NAME_HDR);
        this.tblModels.setColumnSortedAscending(mdlNameColumn, false);
        this.saveColumnSortInfo();
    }

    private void saveColumnSortInfo() {
        this.connBindsSortInfo = ColumnSortInfo.getTableColumnSortInfo(this.tblConnBinds);
        this.modelsSortInfo = ColumnSortInfo.getTableColumnSortInfo(this.tblModels);
    }

    private void restoreColumnSortOrder() {
        ColumnSortInfo.setColumnSortOrder(this.connBindsSortInfo, this.tblConnBinds);
        ColumnSortInfo.setColumnSortOrder(this.modelsSortInfo, this.tblModels);
    }

    @Override
    public void editRequested(VDBConnectorBindingNames bindingInfo) {
        String modelName = bindingInfo.getModelName();
        ConnectorBindingNameAndUUID[] assignedBindings = bindingInfo.getBindings();
        List availableBindingsInfo = null;
        availableBindingsInfo = this.getAvailableBindings();
        ArrayList<String> availableBindingNames = new ArrayList<String>(availableBindingsInfo.size());
        HashMap<String, String> bindingNameToUUIDMap = new HashMap<String, String>();
        for (ConnectorBindingNameAndUUID binding : availableBindingsInfo) {
            String bindingName = binding.getBindingName();
            String uuid = binding.getUUID();
            availableBindingNames.add(bindingName);
            bindingNameToUUIDMap.put(bindingName, uuid);
        }
        ArrayList<String> assignedBindingNames = new ArrayList<String>(assignedBindings.length);
        for (int i = 0; i < assignedBindings.length; ++i) {
            assignedBindingNames.add(assignedBindings[i].getBindingName());
        }
        VDBMultiConnectorBindingAssignmentDlg dlg = new VDBMultiConnectorBindingAssignmentDlg(ViewManager.getMainFrame(), modelName, availableBindingNames, assignedBindingNames, bindingNameToUUIDMap, this.connection);
        dlg.show();
        if (!dlg.wasCanceled()) {
            ConnectorBindingNameAndUUID[] selectedBindings = dlg.getSelectedBindings();
            bindingInfo.setBindings(selectedBindings);
            this.tblModels.reviseRow(bindingInfo);
        }
    }

    private List getAvailableBindings() {
        ArrayList<ConnectorBindingNameAndUUID> availableBindings = new ArrayList<ConnectorBindingNameAndUUID>();
        for (Map.Entry me : this.hmConnBindsXref.entrySet()) {
            String bindingName = (String)me.getKey();
            ConnectorBinding cb = (ConnectorBinding)me.getValue();
            String uuid = cb.getRoutingUUID();
            ConnectorBindingNameAndUUID newItem = new ConnectorBindingNameAndUUID(bindingName, uuid);
            availableBindings.add(newItem);
        }
        return availableBindings;
    }

    public void setMigratedBindings(Map bindings) throws Exception {
        HashMap<String, ConnectorBindingNameAndUUID[]> newMap = new HashMap<String, ConnectorBindingNameAndUUID[]>();
        for (Map.Entry me : bindings.entrySet()) {
            String modelName = (String)me.getKey();
            List uuids = (List)me.getValue();
            ArrayList<ConnectorBindingNameAndUUID> newList = new ArrayList<ConnectorBindingNameAndUUID>(uuids.size());
            for (String uuid : uuids) {
                ConnectorBinding cb = null;
                cb = this.getConnectorManager().getConnectorBindingByUUID(uuid);
                if (cb == null) continue;
                String bindingName = cb.getName();
                newList.add(new ConnectorBindingNameAndUUID(bindingName, uuid));
            }
            ConnectorBindingNameAndUUID[] bindingNames = new ConnectorBindingNameAndUUID[newList.size()];
            Iterator ix = newList.iterator();
            int i = 0;
            while (ix.hasNext()) {
                bindingNames[i] = (ConnectorBindingNameAndUUID)ix.next();
                ++i;
            }
            newMap.put(modelName, bindingNames);
        }
        this.migratedBindings = newMap;
    }

    void switchConnectorBindings(boolean useMigratedBindings) {
        boolean exceptionOccurred = false;
        try {
            if (useMigratedBindings && this.migratedBindings != null) {
                this.setBindingsFromMap(this.migratedBindings);
            } else {
                this.setBindingsFromMap(this.vdbBindings);
            }
        }
        catch (Exception ex) {
            exceptionOccurred = true;
            String msg = "Exception retrieving existing connector bindings for migration.";
            LogManager.logError((String)"CONNECTOR_BINDINGS", (Throwable)ex, (String)msg);
            ExceptionUtility.showMessage(msg, ex);
        }
        if (!exceptionOccurred) {
            this.refreshBindingMap();
        }
    }
}

