/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.vdb;

import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.ConnectorManager;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.models.VdbManager;
import com.metamatrix.console.ui.ViewManager;
import com.metamatrix.console.ui.views.DefaultConsoleTableComparator;
import com.metamatrix.console.ui.views.deploy.event.ConfigurationChangeEvent;
import com.metamatrix.console.ui.views.deploy.event.ConfigurationChangeListener;
import com.metamatrix.console.ui.views.vdb.VdbDisplayer;
import com.metamatrix.console.ui.views.vdb.VdbEditConnBindDlg;
import com.metamatrix.console.ui.views.vdb.VdbMainPanel;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.metadata.runtime.api.Model;
import com.metamatrix.metadata.runtime.api.VirtualDatabase;
import com.metamatrix.metadata.runtime.api.VirtualDatabaseID;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.TableWidget;
import com.metamatrix.toolbox.ui.widget.TitledBorder;
import com.metamatrix.toolbox.ui.widget.table.DefaultTableModel;
import com.metamatrix.toolbox.ui.widget.table.EnhancedTableColumn;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class VdbConnBindPanel
extends JPanel
implements VdbDisplayer,
ConfigurationChangeListener {
    public static final String MODEL_NAME = "Model Name";
    public static final String MODEL_TYPE = "Type";
    public static final String CONNECTOR_BINDING = "Connector Binding";
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel pnlOuter = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    Border border1;
    JPanel pnlVdbName = new JPanel();
    FlowLayout flowLayout1 = new FlowLayout();
    JPanel pnlModelTable = new JPanel();
    JTextField txfVdbName = new JTextField();
    JLabel lblVdbName = new JLabel();
    JScrollPane jScrollPane1 = new JScrollPane();
    TableWidget tblConnBndsModels = new TableWidget();
    JFrame frParent;
    Border border2;
    TitledBorder titledBorder1;
    Border border3;
    ButtonWidget btnEdit = new ButtonWidget(" Edit ");
    JLabel lblVersion = new JLabel("Version:");
    JTextField txfVersion = new JTextField();
    VirtualDatabase vdbCurrent = null;
    private ConnectionInfo connection = null;
    private String[] aryColNames = new String[]{"Model Name", "Type", "Connector Binding"};
    private HashMap hmConnBindUUIDToName = null;
    private Collection colModels = null;

    public VdbConnBindPanel(ConnectionInfo connection) {
        this.connection = connection;
        try {
            this.frParent = ViewManager.getMainFrame();
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private VdbManager getVdbManager() {
        return ModelManager.getVdbManager(this.connection);
    }

    private ConnectorManager getConnectorManager() {
        return ModelManager.getConnectorManager(this.connection);
    }

    @Override
    public void setVirtualDatabase(VirtualDatabase vdb) {
        if (this.vdbCurrent != vdb) {
            this.vdbCurrent = vdb;
            this.refresh();
        }
    }

    public VirtualDatabase getVirtualDatabase() {
        return this.vdbCurrent;
    }

    public ButtonWidget getEditButton() {
        return this.btnEdit;
    }

    public void refresh() {
        if (this.getVirtualDatabase() == null) {
            this.clear();
            return;
        }
        this.depopulateTableModel();
        try {
            this.colModels = new ArrayList();
            VirtualDatabase vdb = this.getVirtualDatabase();
            VirtualDatabaseID vID = (VirtualDatabaseID)vdb.getID();
            Collection mdls = this.getVdbManager().getVdbModels(vID);
            for (Model mdlTemp : mdls) {
                if (!mdlTemp.requireConnectorBinding()) continue;
                this.colModels.add(mdlTemp);
            }
        }
        catch (Exception e) {
            ExceptionUtility.showMessage("Failed retrieving models for a vdb", e);
        }
        this.repopulateTableModel(this.colModels);
        this.txfVdbName.setText(this.getVirtualDatabase().getName());
        VirtualDatabaseID vdbid = (VirtualDatabaseID)this.getVirtualDatabase().getID();
        this.txfVersion.setText(vdbid.getVersion());
    }

    public void clear() {
        this.txfVdbName.setText("");
        this.txfVersion.setText("");
        this.depopulateTableModel();
    }

    private void repopulateTableModel(Collection colModels) {
        DefaultTableModel tmdl = (DefaultTableModel)this.tblConnBndsModels.getModel();
        int iCount = 0;
        try {
            this.hmConnBindUUIDToName = this.getConnectorManager().getUUIDConnectorBindingsMap(true);
        }
        catch (Exception e) {
            ExceptionUtility.showMessage("Failed to retrieve the ConnBind UUID Map", e);
        }
        String sRealConnBindName = "";
        Iterator itModels = colModels.iterator();
        HashMap uuidMap = this.getConnBindUUIDNameXref();
        while (itModels.hasNext()) {
            ++iCount;
            Model vdbmodelTemp = (Model)itModels.next();
            List bindingNames = vdbmodelTemp.getConnectorBindingNames();
            Iterator it = bindingNames.iterator();
            while (it.hasNext()) {
                Vector<String> vModelRow = new Vector<String>();
                vModelRow.add(vdbmodelTemp.getName());
                vModelRow.add(vdbmodelTemp.getModelTypeName());
                String bindingName = (String)it.next();
                sRealConnBindName = (String)uuidMap.get(bindingName);
                if (sRealConnBindName == null) {
                    sRealConnBindName = "";
                }
                vModelRow.add(sRealConnBindName);
                tmdl.addRow(vModelRow.toArray());
            }
        }
        this.tblConnBndsModels.sort();
    }

    private void depopulateTableModel() {
        DefaultTableModel tmdl = (DefaultTableModel)this.tblConnBndsModels.getModel();
        int numRows = tmdl.getRowCount();
        for (int i = numRows - 1; i >= 0; --i) {
            tmdl.removeRow(i);
        }
    }

    private HashMap getConnBindUUIDNameXref() {
        try {
            this.hmConnBindUUIDToName = this.getConnectorManager().getUUIDConnectorBindingsMap(true);
        }
        catch (Exception e) {
            ExceptionUtility.showMessage("Failed to retrieve the ConnBind UUID Map", e);
        }
        return this.hmConnBindUUIDToName;
    }

    public void runEditConnBindDialog() {
        String vdbName = "Edit Bindings for Virtual Database " + this.getVirtualDatabase().getName();
        VdbEditConnBindDlg editDialog = new VdbEditConnBindDlg((Frame)this.frParent, vdbName, (VirtualDatabaseID)this.getVirtualDatabase().getID(), this.connection);
        editDialog.pack();
        VdbMainPanel.setLocationOn(editDialog);
        editDialog.setModal(true);
        editDialog.show();
        this.refresh();
    }

    private void jbInit() throws Exception {
        this.border1 = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        this.titledBorder1 = new TitledBorder("Models");
        this.border3 = BorderFactory.createCompoundBorder(new TitledBorder(""), BorderFactory.createEmptyBorder(10, 5, 5, 5));
        this.setLayout(this.borderLayout1);
        this.pnlOuter.setLayout(new GridBagLayout());
        this.pnlOuter.setBorder(this.border1);
        this.pnlVdbName.setLayout(this.flowLayout1);
        this.txfVdbName.setPreferredSize(new Dimension(163, 21));
        this.txfVdbName.setEditable(false);
        this.txfVdbName.setMinimumSize(this.txfVdbName.getPreferredSize());
        this.txfVdbName.setText("");
        this.lblVdbName.setText("VDB Name:");
        this.txfVersion.setPreferredSize(new Dimension(50, 21));
        this.txfVersion.setEditable(false);
        this.txfVersion.setMinimumSize(this.txfVersion.getPreferredSize());
        this.txfVersion.setText("17");
        this.pnlOuter.add((Component)this.lblVdbName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.pnlOuter.add((Component)this.txfVdbName, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.pnlOuter.add((Component)this.lblVersion, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.pnlOuter.add((Component)this.txfVersion, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.pnlOuter.add((Component)this.btnEdit, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.pnlModelTable.setLayout(new GridLayout(1, 1));
        this.pnlModelTable.setBorder(this.border3);
        this.add((Component)this.pnlOuter, "Center");
        GridBagConstraints gridBagConstraints2a = new GridBagConstraints();
        gridBagConstraints2a.gridx = 0;
        gridBagConstraints2a.gridy = 1;
        gridBagConstraints2a.fill = 1;
        gridBagConstraints2a.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints2a.anchor = 17;
        gridBagConstraints2a.weightx = 1.0;
        gridBagConstraints2a.weighty = 1.0;
        gridBagConstraints2a.gridwidth = 5;
        this.pnlOuter.add((Component)this.pnlModelTable, gridBagConstraints2a);
        this.jScrollPane1.setViewportView(this.tblConnBndsModels);
        this.pnlModelTable.add(this.jScrollPane1);
        DefaultTableModel tmdl = new DefaultTableModel(new Vector<String>(Arrays.asList(this.aryColNames)));
        this.tblConnBndsModels.setModel(tmdl);
        this.tblConnBndsModels.setPreferredScrollableViewportSize(new Dimension(this.tblConnBndsModels.getPreferredSize().width, 4 * this.tblConnBndsModels.getRowHeight()));
        this.tblConnBndsModels.setSortable(true);
        this.tblConnBndsModels.setComparator(DefaultConsoleTableComparator.getInstance());
        this.tblConnBndsModels.setEditable(false);
        this.tblConnBndsModels.sizeColumnsToFitData(100);
        this.tblConnBndsModels.setCellSelectionEnabled(false);
        EnhancedTableColumn col = (EnhancedTableColumn)this.tblConnBndsModels.getColumn(MODEL_NAME);
        this.tblConnBndsModels.setColumnSortedAscending(col, false);
        col = (EnhancedTableColumn)this.tblConnBndsModels.getColumn(CONNECTOR_BINDING);
        this.tblConnBndsModels.setColumnSortedAscending(col, true);
        this.refresh();
    }

    @Override
    public void configurationChanged(ConfigurationChangeEvent theEvent) {
        if (theEvent.getType() == 16) {
            this.refresh();
        }
    }
}

