/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.vdb;

import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.models.VdbManager;
import com.metamatrix.console.ui.views.vdb.VdbDisplayer;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.metadata.runtime.api.VirtualDatabase;
import com.metamatrix.metadata.runtime.api.VirtualDatabaseID;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import com.metamatrix.toolbox.ui.widget.TextFieldWidget;
import com.metamatrix.toolbox.ui.widget.text.DefaultTextFieldModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class VdbDetailPanel
extends JPanel
implements VdbDisplayer {
    Border border1;
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    DefaultTextFieldModel dtfmTextModel = new DefaultTextFieldModel();
    JTextArea txaDescription = new JTextArea(this.dtfmTextModel);
    JLabel lblDescription = new LabelWidget();
    JTextField txfVersionedBy = new TextFieldWidget();
    JLabel lblVersionedBy = new LabelWidget();
    JTextField txfVersioned = new TextFieldWidget();
    JLabel lblVersioned = new LabelWidget();
    JTextField txfCreatedBy = new TextFieldWidget();
    JLabel lblCreatedBy = new LabelWidget();
    JTextField txfCreated = new TextFieldWidget();
    JLabel lblCreated = new LabelWidget();
    JTextField txfUpdatedBy = new TextFieldWidget();
    JLabel lblUpdatedBy = new LabelWidget();
    JTextField txfUpdated = new TextFieldWidget();
    JLabel lblUpdated = new LabelWidget();
    JTextField txfFileName = new TextFieldWidget();
    JLabel lblFileName = new LabelWidget();
    JTextField txfVersion = new TextFieldWidget();
    JLabel lblVersion = new LabelWidget();
    JTextField txfName = new TextFieldWidget();
    JLabel lblName = new LabelWidget();
    Border border2;
    JLabel lblStatus = new LabelWidget();
    Border border3;
    JScrollPane scpnDescription = new JScrollPane();
    ButtonWidget btnApply = new ButtonWidget("Apply ");
    ButtonWidget btnReset = new ButtonWidget("Reset");
    private int TEXTAREA_MAXLENGTH = 255;
    private boolean bCanModify;
    VirtualDatabase vdbCurrent = null;
    private ConnectionInfo connection = null;

    public VdbDetailPanel(ConnectionInfo connection, boolean canModify) {
        this.connection = connection;
        this.bCanModify = canModify;
        try {
            this.jbInit();
            this.addListeners();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private VdbManager getVdbManager() {
        return ModelManager.getVdbManager(this.connection);
    }

    @Override
    public void setVirtualDatabase(VirtualDatabase vdb) {
        if (this.vdbCurrent != vdb) {
            this.vdbCurrent = vdb;
            this.refresh();
        }
    }

    public VirtualDatabase getVirtualDatabase() {
        return this.vdbCurrent;
    }

    public void refresh() {
        SimpleDateFormat formatter = StaticUtilities.getDefaultDateFormat();
        if (this.getVirtualDatabase() == null) {
            this.clear();
            return;
        }
        this.txfName.setText(this.getVirtualDatabase().getName());
        short siStatus = this.getVirtualDatabase().getStatus();
        String sStatus = this.getVdbManager().getVdbStatusAsString(siStatus);
        this.lblStatus.setText(sStatus);
        this.txfVersionedBy.setText(this.getVirtualDatabase().getVersionBy());
        this.txfVersioned.setText(formatter.format(this.getVirtualDatabase().getVersionDate()));
        this.txfCreatedBy.setText(this.getVirtualDatabase().getCreatedBy());
        this.txfCreated.setText(formatter.format(this.getVirtualDatabase().getCreationDate()));
        this.txfUpdatedBy.setText(this.getVirtualDatabase().getUpdatedBy());
        this.txfUpdated.setText(formatter.format(this.getVirtualDatabase().getUpdateDate()));
        this.txfFileName.setText(this.getVirtualDatabase().getFileName());
        VirtualDatabaseID vdbid = (VirtualDatabaseID)this.getVirtualDatabase().getID();
        this.txfVersion.setText(vdbid.getVersion());
        this.txaDescription.setText(this.getVirtualDatabase().getDescription());
        if (this.bCanModify) {
            this.txaDescription.setEnabled(true);
        } else {
            this.txaDescription.setEnabled(false);
        }
    }

    public void clear() {
        this.txfName.setText("");
        this.lblStatus.setText("");
        this.txfVersionedBy.setText("");
        this.txfVersioned.setText("");
        this.txfCreatedBy.setText("");
        this.txfCreated.setText("");
        this.txfUpdatedBy.setText("");
        this.txfUpdated.setText("");
        this.txfFileName.setText("");
        this.txaDescription.setText("");
        this.txaDescription.setEnabled(false);
        this.txfVersion.setText("");
    }

    private void addListeners() {
        this.btnApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                VdbDetailPanel.this.processApplyButton();
            }
        });
        this.btnReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                VdbDetailPanel.this.processResetButton();
            }
        });
        this.txaDescription.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent de) {
                VdbDetailPanel.this.enableButtons();
            }

            @Override
            public void insertUpdate(DocumentEvent de) {
                VdbDetailPanel.this.enableButtons();
            }

            @Override
            public void removeUpdate(DocumentEvent de) {
                VdbDetailPanel.this.enableButtons();
            }
        });
    }

    private void enableButtons() {
        if (this.bCanModify) {
            if (this.getVirtualDatabase() != null) {
                if (this.txaDescription.getText().equals(this.getVirtualDatabase().getDescription())) {
                    this.btnApply.setEnabled(false);
                    this.btnReset.setEnabled(false);
                } else {
                    this.btnApply.setEnabled(true);
                    this.btnReset.setEnabled(true);
                }
            } else {
                this.btnApply.setEnabled(false);
                this.btnReset.setEnabled(false);
            }
        } else {
            this.btnApply.setEnabled(false);
            this.btnReset.setEnabled(false);
        }
    }

    private void initButtonState() {
        this.btnApply.setEnabled(false);
        this.btnReset.setEnabled(false);
    }

    private void processApplyButton() {
        VirtualDatabase vdb = this.getVirtualDatabase();
        vdb.update("description", (Object)this.txaDescription.getText());
        try {
            this.getVdbManager().updateVirtualDatabase(vdb);
        }
        catch (Exception ex) {
            ExceptionUtility.showMessage("Failed trying to update a VDB", ex);
        }
        this.initButtonState();
    }

    private void processResetButton() {
        this.refresh();
    }

    private void jbInit() throws Exception {
        this.dtfmTextModel.setMaximumLength(this.TEXTAREA_MAXLENGTH);
        this.border2 = BorderFactory.createEmptyBorder(5, 11, 11, 11);
        this.txaDescription.setColumns(30);
        this.txaDescription.setRows(4);
        this.txaDescription.setPreferredSize(new Dimension(150, 68));
        this.txaDescription.setLineWrap(true);
        this.txaDescription.setWrapStyleWord(true);
        this.txaDescription.setText("");
        this.scpnDescription.setViewportView(this.txaDescription);
        this.setLayout(this.gridBagLayout1);
        this.lblDescription.setText("Description:");
        this.txfVersionedBy.setEditable(false);
        this.txfVersionedBy.setColumns(30);
        this.txfVersionedBy.setMinimumSize(new Dimension(180, 21));
        this.lblVersionedBy.setText("By: ");
        this.txfVersioned.setText("");
        this.txfVersioned.setColumns(30);
        this.txfVersioned.setMinimumSize(new Dimension(180, 21));
        this.txfVersioned.setEditable(false);
        this.lblVersioned.setText("Versioned: ");
        this.txfCreatedBy.setEditable(false);
        this.txfCreatedBy.setColumns(30);
        this.txfCreatedBy.setMinimumSize(new Dimension(180, 21));
        this.lblCreatedBy.setText("By: ");
        this.txfCreated.setText("");
        this.txfCreated.setColumns(30);
        this.txfCreated.setMinimumSize(new Dimension(180, 21));
        this.txfCreated.setEditable(false);
        this.lblCreated.setText("Created: ");
        this.txfUpdatedBy.setEditable(false);
        this.txfUpdatedBy.setColumns(30);
        this.txfUpdatedBy.setMinimumSize(new Dimension(180, 21));
        this.lblUpdatedBy.setText("By: ");
        this.txfUpdated.setText("");
        this.txfUpdated.setColumns(30);
        this.txfUpdated.setMinimumSize(new Dimension(180, 21));
        this.txfUpdated.setEditable(false);
        this.lblUpdated.setText("Updated: ");
        this.txfFileName.setText("");
        this.txfFileName.setColumns(50);
        this.txfFileName.setMinimumSize(new Dimension(300, 210));
        this.txfFileName.setEditable(false);
        this.lblFileName.setText("VDB FileName: ");
        this.txfVersion.setText("");
        this.txfVersion.setColumns(10);
        this.txfVersion.setPreferredSize(new Dimension(50, 21));
        this.txfVersion.setMinimumSize(new Dimension(50, 21));
        this.txfVersion.setEditable(false);
        this.lblVersion.setText("Version: ");
        this.txfName.setText("");
        this.txfName.setColumns(30);
        this.txfName.setMinimumSize(new Dimension(180, 21));
        this.txfName.setEditable(false);
        this.lblName.setText("VDB Name: ");
        this.setBorder(this.border2);
        this.lblStatus.setFont(new Font("Dialog", 1, 14));
        this.lblStatus.setBorder(this.border3);
        this.lblStatus.setText("ACTIVE");
        this.add((Component)this.lblName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 0, 2, 0), 0, 0));
        this.add((Component)this.txfName, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 2, 5), 0, 0));
        this.add((Component)this.lblVersion, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 0, 2, 0), 0, 0));
        this.add((Component)this.txfVersion, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 2, 0), 0, 0));
        this.add((Component)this.lblStatus, new GridBagConstraints(4, 0, 1, 2, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.lblVersioned, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 0, 2, 0), 0, 0));
        this.add((Component)this.txfVersioned, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 2, 0), 0, 0));
        this.add((Component)this.lblVersionedBy, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 0, 2, 0), 0, 0));
        this.add((Component)this.txfVersionedBy, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 2, 0), 0, 0));
        this.add((Component)this.lblCreated, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 0, 2, 0), 0, 0));
        this.add((Component)this.txfCreated, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 2, 0), 0, 0));
        this.add((Component)this.lblCreatedBy, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 0, 2, 0), 0, 0));
        this.add((Component)this.txfCreatedBy, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 2, 0), 0, 0));
        this.add((Component)this.lblUpdated, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 0, 2, 0), 0, 0));
        this.add((Component)this.txfUpdated, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 2, 0), 0, 0));
        this.add((Component)this.lblUpdatedBy, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 0, 2, 0), 0, 0));
        this.add((Component)this.txfUpdatedBy, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 2, 0), 0, 0));
        JPanel configPanel = new JPanel();
        GridBagLayout cl = new GridBagLayout();
        configPanel.setLayout(cl);
        configPanel.add(this.lblFileName);
        cl.setConstraints(this.lblFileName, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        configPanel.add(this.txfFileName);
        cl.setConstraints(this.txfFileName, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)configPanel, new GridBagConstraints(0, 4, 4, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 2, 0), 0, 0));
        this.add((Component)this.lblDescription, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.scpnDescription, new GridBagConstraints(1, 5, 3, 2, 1.0, 0.5, 11, 1, new Insets(2, 0, 2, 0), 0, 0));
        this.add((Component)this.btnApply, new GridBagConstraints(4, 5, 1, 1, 0.0, 0.0, 12, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.btnReset, new GridBagConstraints(4, 6, 1, 1, 0.0, 0.0, 12, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.refresh();
        this.initButtonState();
    }
}

