/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.vdb;

import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.models.VdbManager;
import com.metamatrix.console.ui.views.vdb.ModelWrapper;
import com.metamatrix.console.ui.views.vdb.VdbAssignConnBindPanel;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.metadata.runtime.api.Model;
import com.metamatrix.metadata.runtime.api.VirtualDatabaseID;
import com.metamatrix.toolbox.ui.widget.DialogPanel;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.swing.JDialog;

public class VdbEditConnBindDlg
extends JDialog {
    private VdbAssignConnBindPanel vacbConnectorBindingEditPanel;
    private VirtualDatabaseID vdbID;
    private ConnectionInfo connection = null;
    private DialogPanel dlgpnlDialogContainer = new DialogPanel();

    public VdbEditConnBindDlg(Frame mainFrame, String title, VirtualDatabaseID vdbID, ConnectionInfo connection) {
        super(mainFrame, title);
        this.vdbID = vdbID;
        this.connection = connection;
        try {
            this.init();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private VdbManager getVdbManager() {
        return ModelManager.getVdbManager(this.connection);
    }

    private void init() throws Exception {
        this.vacbConnectorBindingEditPanel = new VdbAssignConnBindPanel(this.connection);
        Collection colModels = this.getModelsForVdb(this.getVdbId());
        this.vacbConnectorBindingEditPanel.setModels(this.convertModelsToModelWrappers(colModels));
        this.dlgpnlDialogContainer.setContent(this.vacbConnectorBindingEditPanel);
        this.addListeners();
        this.getContentPane().add(this.dlgpnlDialogContainer);
    }

    public Collection convertModelsToModelWrappers(Collection colModels) {
        ArrayList<ModelWrapper> arylModelWrappers = new ArrayList<ModelWrapper>();
        for (Model mdlTemp : colModels) {
            if (!mdlTemp.requireConnectorBinding()) continue;
            arylModelWrappers.add(new ModelWrapper(mdlTemp));
        }
        return arylModelWrappers;
    }

    private void addListeners() {
        this.dlgpnlDialogContainer.getAcceptButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                VdbEditConnBindDlg.this.processAcceptButton();
            }
        });
        this.dlgpnlDialogContainer.getCancelButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                VdbEditConnBindDlg.this.processCancelButton();
            }
        });
    }

    private void processAcceptButton() {
        this.updateConnectorBindings();
        this.dispose();
    }

    private void processCancelButton() {
        this.dispose();
    }

    private void updateConnectorBindings() {
        Map mapModelsToConnBinds = this.getModelsToConnBindsMap();
        try {
            this.getVdbManager().setConnectorBindingNames(this.getVdbId(), mapModelsToConnBinds);
        }
        catch (Exception e) {
            ExceptionUtility.showMessage("Failed to update Connector Binding names ", e);
        }
    }

    private VirtualDatabaseID getVdbId() {
        return this.vdbID;
    }

    private Map getModelsToConnBindsMap() {
        return this.vacbConnectorBindingEditPanel.getModelsToConnectorBindingsMap();
    }

    private Collection getModelsForVdb(VirtualDatabaseID vdbID) {
        Collection colModels = null;
        try {
            colModels = this.getVdbManager().getVdbModels(vdbID);
        }
        catch (Exception e) {
            ExceptionUtility.showMessage("Failed retrieving models for a vdb", e);
        }
        return colModels;
    }
}

