/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.vdb;

import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.models.VdbManager;
import com.metamatrix.console.ui.ViewManager;
import com.metamatrix.console.ui.views.DefaultConsoleTableComparator;
import com.metamatrix.console.ui.views.vdb.VdbDisplayer;
import com.metamatrix.console.ui.views.vdb.VdbEditConnBindDlg;
import com.metamatrix.console.ui.views.vdb.VdbMainPanel;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.metadata.runtime.api.VirtualDatabase;
import com.metamatrix.metadata.runtime.api.VirtualDatabaseID;
import com.metamatrix.platform.security.api.AuthorizationPolicyID;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.TableWidget;
import com.metamatrix.toolbox.ui.widget.TitledBorder;
import com.metamatrix.toolbox.ui.widget.table.DefaultTableModel;
import com.metamatrix.toolbox.ui.widget.table.EnhancedTableColumn;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class VdbEntitlementsPanel
extends JPanel
implements VdbDisplayer {
    public static final String ENTITLEMENT = "Role Name";
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel pnlOuter = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    Border border1;
    JPanel pnlVdbName = new JPanel();
    FlowLayout flowLayout1 = new FlowLayout();
    JPanel pnlEntitlementsTable = new JPanel();
    JTextField txfVdbName = new JTextField();
    JLabel lblVdbName = new JLabel();
    JScrollPane jScrollPane1 = new JScrollPane();
    TableWidget tblVdbEntitlements = new TableWidget();
    Border border2;
    TitledBorder titledBorder1;
    Border border3;
    JLabel lblVersion = new JLabel("Version:");
    JTextField txfVersion = new JTextField();
    JFrame frParent;
    ButtonWidget btnExportRoles = new ButtonWidget(" Export Roles... ");
    ButtonWidget btnImportRoles = new ButtonWidget(" Import Roles... ");
    VirtualDatabase vdbCurrent = null;
    private ConnectionInfo connection = null;
    String[] aryColNames = new String[]{"Role Name", "Description"};

    public VdbEntitlementsPanel(ConnectionInfo connection) {
        this.connection = connection;
        try {
            this.frParent = ViewManager.getMainFrame();
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private VdbManager getVdbManager() {
        return ModelManager.getVdbManager(this.connection);
    }

    @Override
    public void setVirtualDatabase(VirtualDatabase vdb) {
        if (this.vdbCurrent != vdb) {
            this.vdbCurrent = vdb;
            this.refresh();
        }
    }

    public VirtualDatabase getVirtualDatabase() {
        return this.vdbCurrent;
    }

    public ButtonWidget getExportRolesButton() {
        return this.btnExportRoles;
    }

    public ButtonWidget getImportRolesButton() {
        return this.btnImportRoles;
    }

    public void runImportRolesDialog() {
        String vdbName = "Import Roles for Virtual Database " + this.getVirtualDatabase().getName();
        VdbEditConnBindDlg editDialog = new VdbEditConnBindDlg((Frame)this.frParent, vdbName, (VirtualDatabaseID)this.getVirtualDatabase().getID(), this.connection);
        editDialog.pack();
        VdbMainPanel.setLocationOn(editDialog);
        editDialog.setModal(true);
        editDialog.show();
        this.refresh();
    }

    public void refresh() {
        if (this.getVirtualDatabase() == null) {
            this.clear();
            return;
        }
        Collection colEntitlements = null;
        try {
            VirtualDatabaseID id = (VirtualDatabaseID)this.getVirtualDatabase().getID();
            colEntitlements = this.getVdbManager().getVdbEntitlements(id);
        }
        catch (Exception e) {
            ExceptionUtility.showMessage("Failed retrieving Roles for a vdb", e);
        }
        this.depopulateTableModel();
        this.repopulateTableModel(colEntitlements);
        this.txfVdbName.setText(this.getVirtualDatabase().getName());
        VirtualDatabaseID vdbid = (VirtualDatabaseID)this.getVirtualDatabase().getID();
        this.txfVersion.setText(vdbid.getVersion());
    }

    private void depopulateTableModel() {
        DefaultTableModel tmdl = (DefaultTableModel)this.tblVdbEntitlements.getModel();
        int numRows = tmdl.getRowCount();
        for (int i = numRows - 1; i >= 0; --i) {
            tmdl.removeRow(i);
        }
    }

    private void repopulateTableModel(Collection colEntitlements) {
        DefaultTableModel tmdl = (DefaultTableModel)this.tblVdbEntitlements.getModel();
        Iterator itEntIDs = colEntitlements.iterator();
        while (itEntIDs.hasNext()) {
            Vector<String> vEntRow = new Vector<String>();
            AuthorizationPolicyID entEntitlementIDTemp = (AuthorizationPolicyID)itEntIDs.next();
            vEntRow.add(entEntitlementIDTemp.getDisplayName());
            vEntRow.add(entEntitlementIDTemp.getDescription());
            tmdl.addRow(vEntRow.toArray());
        }
        this.tblVdbEntitlements.sort();
    }

    public boolean hasRoles() {
        return this.tblVdbEntitlements.getRowCount() > 0;
    }

    public void clear() {
        this.txfVersion.setText("");
        this.txfVdbName.setText("");
        this.depopulateTableModel();
    }

    private void jbInit() throws Exception {
        this.border1 = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        this.titledBorder1 = new TitledBorder("Models");
        this.border3 = BorderFactory.createCompoundBorder(new TitledBorder(""), BorderFactory.createEmptyBorder(10, 5, 5, 5));
        this.setLayout(this.borderLayout1);
        this.pnlOuter.setLayout(new GridBagLayout());
        this.pnlOuter.setBorder(this.border1);
        this.pnlVdbName.setLayout(this.flowLayout1);
        this.txfVdbName.setPreferredSize(new Dimension(263, 21));
        this.txfVdbName.setMinimumSize(this.txfVdbName.getPreferredSize());
        this.txfVdbName.setEditable(false);
        this.txfVdbName.setText("Sales VDB");
        this.lblVdbName.setText("VDB Name:");
        this.pnlEntitlementsTable.setBorder(this.border3);
        this.pnlEntitlementsTable.setLayout(new GridBagLayout());
        this.txfVersion.setPreferredSize(new Dimension(50, 21));
        this.txfVersion.setMinimumSize(this.txfVersion.getPreferredSize());
        this.txfVersion.setEditable(false);
        this.txfVersion.setText("17");
        this.pnlOuter.add((Component)this.lblVdbName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.pnlOuter.add((Component)this.txfVdbName, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.pnlOuter.add((Component)this.lblVersion, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.pnlOuter.add((Component)this.txfVersion, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.add(this.btnImportRoles);
        buttonsPanel.add(this.btnExportRoles);
        this.pnlOuter.add((Component)buttonsPanel, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        DefaultTableModel tmdl = new DefaultTableModel(new Vector<String>(Arrays.asList(this.aryColNames)));
        this.tblVdbEntitlements.setModel(tmdl);
        this.tblVdbEntitlements.setPreferredScrollableViewportSize(new Dimension(this.tblVdbEntitlements.getPreferredSize().width, 2 * this.tblVdbEntitlements.getRowHeight()));
        this.tblVdbEntitlements.setEditable(false);
        this.tblVdbEntitlements.setSortable(true);
        this.tblVdbEntitlements.setComparator(DefaultConsoleTableComparator.getInstance());
        this.tblVdbEntitlements.sizeColumnsToFitData(100);
        this.tblVdbEntitlements.setCellSelectionEnabled(false);
        EnhancedTableColumn col = (EnhancedTableColumn)this.tblVdbEntitlements.getColumn(ENTITLEMENT);
        this.tblVdbEntitlements.setColumnSortedAscending(col, false);
        this.add((Component)this.pnlOuter, "Center");
        GridBagConstraints gridBagConstraints29 = new GridBagConstraints();
        gridBagConstraints29.gridx = 0;
        gridBagConstraints29.gridy = 0;
        gridBagConstraints29.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints29.anchor = 17;
        GridBagConstraints gridBagConstraints2a = new GridBagConstraints();
        gridBagConstraints2a.gridx = 0;
        gridBagConstraints2a.gridy = 1;
        gridBagConstraints2a.fill = 1;
        gridBagConstraints2a.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints2a.anchor = 17;
        gridBagConstraints2a.weightx = 1.0;
        gridBagConstraints2a.weighty = 1.0;
        gridBagConstraints2a.gridwidth = 5;
        this.pnlOuter.add((Component)this.pnlEntitlementsTable, gridBagConstraints2a);
        this.jScrollPane1.setViewportView(this.tblVdbEntitlements);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        this.pnlEntitlementsTable.add((Component)this.jScrollPane1, gridBagConstraints2);
        this.refresh();
    }
}

