/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.vdb;

import com.metamatrix.common.util.PropertiesUtils;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.models.VdbManager;
import com.metamatrix.console.notification.DataEntitlementChangeNotification;
import com.metamatrix.console.notification.RuntimeUpdateNotification;
import com.metamatrix.console.security.UserCapabilities;
import com.metamatrix.console.ui.ViewManager;
import com.metamatrix.console.ui.layout.BasePanel;
import com.metamatrix.console.ui.layout.ConsoleMainFrame;
import com.metamatrix.console.ui.layout.MenuEntry;
import com.metamatrix.console.ui.layout.WorkspaceController;
import com.metamatrix.console.ui.layout.WorkspacePanel;
import com.metamatrix.console.ui.util.AbstractPanelAction;
import com.metamatrix.console.ui.views.DefaultConsoleTableComparator;
import com.metamatrix.console.ui.views.vdb.DeleteConfirmationDialogForVDBWithEntitlements;
import com.metamatrix.console.ui.views.vdb.ImportVdbRolesWizardDlg;
import com.metamatrix.console.ui.views.vdb.ImportVdbVersionWizardDlg;
import com.metamatrix.console.ui.views.vdb.MaterializationPanel;
import com.metamatrix.console.ui.views.vdb.VDBExporter;
import com.metamatrix.console.ui.views.vdb.VDBMetadataTreePanel;
import com.metamatrix.console.ui.views.vdb.VDBRolesExporter;
import com.metamatrix.console.ui.views.vdb.VDBTableModel;
import com.metamatrix.console.ui.views.vdb.VdbConnBindPanel;
import com.metamatrix.console.ui.views.vdb.VdbDetailPanel;
import com.metamatrix.console.ui.views.vdb.VdbDisplayer;
import com.metamatrix.console.ui.views.vdb.VdbEntitlementsPanel;
import com.metamatrix.console.ui.views.vdb.VdbModelsPanel;
import com.metamatrix.console.ui.views.vdb.VdbSetStatusDlg;
import com.metamatrix.console.util.DialogUtility;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.console.util.Refreshable;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.metadata.runtime.api.VirtualDatabase;
import com.metamatrix.metadata.runtime.api.VirtualDatabaseID;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.Splitter;
import com.metamatrix.toolbox.ui.widget.TableWidget;
import com.metamatrix.toolbox.ui.widget.TitledBorder;
import com.metamatrix.toolbox.ui.widget.menu.DefaultPopupMenuFactory;
import com.metamatrix.toolbox.ui.widget.table.DefaultTableModel;
import com.metamatrix.toolbox.ui.widget.table.EnhancedTableColumn;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class VdbMainPanel
extends BasePanel
implements ChangeListener,
WorkspacePanel,
Refreshable {
    private boolean bIsStale = false;
    private static final String VDB_MANAGEMENT_TITLE = "Virtual Databases";
    private static final String IMPORT_VDB_TITLE = "Import VDB...";
    private static final String EXPORT_VDB_TITLE = "Export VDB...";
    private static final String EDIT_CONN_BIND_TITLE = "Edit Bindings...";
    private static final String CHANGE_VDB_DEFAULT_STATUS_TITLE = "Change VDB Default Status...";
    private static final String CHANGE_VDB_STATUS_TITLE = "Change VDB Status...";
    private static final String CHANGE_VDB_STATUS_ROOT = "Make VDB ";
    private static final String DELETE_VDB_TITLE = "Delete VDB";
    private static final String EXPORT_ROLES_TITLE = "Export Roles...";
    private static final String IMPORT_ROLES_TITLE = "Import Roles...";
    private static final String ACTIVE = "Active...";
    private static final String ACTIVE_DEFAULT = "Active (Default)...";
    private static final String INACTIVE = "Inactive...";
    private static final String DETAILS_TAB_TITLE = "Details";
    private static final String MODELS_TAB_TITLE = "Models Summary";
    private static final String TREE_TAB_TITLE = "Metadata Tree";
    private static final String CONNBIND_TAB_TITLE = "Connector Bindings";
    private static final String ENTITLEMENTS_TAB_TITLE = "Roles";
    private static final String MATERIALIZATION_TAB_TITLE = "Materialization";
    private static final String ACTIVE_DEFAULT_DISPLAY_LABEL = "Active (Default)";
    private ConnectionInfo connection;
    private PanelAction actionImportVDB;
    private PanelAction actionExportVDB;
    private PanelAction actionEditConnBind;
    private PanelAction actionChangeStatus;
    private PanelAction actionChangeDefaultStatus;
    private PanelAction actionDeleteVdb;
    private PanelAction actionExportRoles;
    private PanelAction actionImportRoles;
    private ArrayList arylActions = new ArrayList();
    private ArrayList arylPopupActions = new ArrayList();
    JFrame frParentFrame;
    private Collection colVdbs = null;
    private Collection colDisplayedVdbs = null;
    private VirtualDatabase vdbSelected = null;
    public static final int NUMERIC_FIELD = 10111;
    public static final int ALPHA_FIELD = 11;
    private JSplitPane splitMain;
    private JPanel pnlTop;
    private JPanel pnlFilter;
    private JLabel lblName;
    private JTextField txfName;
    private JPanel pnlStatus;
    private JCheckBox chkActive;
    private JCheckBox chkActiveDefault;
    private JCheckBox chkInactive;
    private JCheckBox chkIncomplete;
    private JCheckBox chkDeleted;
    private JPanel pnlVersion;
    private JRadioButton rdbAllVersions;
    private JRadioButton rdbLatestVersion;
    private ButtonGroup bgrpVersionGroup;
    private JPanel pnlFilterOps;
    private JPanel pnlFilterOpsSizer;
    private ButtonWidget btnApply;
    private ButtonWidget btnReset;
    private ButtonWidget btnHideFilter;
    private ButtonWidget btnShowFilter;
    private JScrollPane spnVdb;
    private TableWidget tblVdb;
    private DefaultTableModel tableModel;
    private VdbDetailPanel pnlDetails;
    private VdbConnBindPanel pnlBindings;
    private VdbEntitlementsPanel pnlEntitlements;
    private JTabbedPane tpnDetails;
    private ButtonWidget btnImportVDB;
    private ButtonWidget btnExportVDB;
    private JPanel pnlNoFilter;
    private GridBagConstraints gbcFilterPanel;
    private boolean bInactiveBaseState = true;
    private boolean bIncompleteBaseState = true;
    private boolean bActiveBaseState = true;
    private boolean bActiveDefaultBaseState = true;
    private boolean bDeletedBaseState = true;
    private boolean bAllVersionsBaseState = true;
    private boolean bLatestVersionsBaseState = false;
    private String sNameFilterBaseState = "*";
    private ListSelectionModel rowSM = null;
    private UserCapabilities ucapsCapabilities = null;
    private boolean bCanModify = false;
    private boolean programmaticChange = false;

    public VdbMainPanel(ConnectionInfo conn) {
        this.connection = conn;
        this.initComponents();
        this.establishActionArray();
        this.updateDetailForTableDeselection();
    }

    private VdbManager getVdbManager() {
        return ModelManager.getVdbManager(this.connection);
    }

    private void initComponents() {
        this.establishUserCapabilities();
        this.createActions();
        this.setLayout(new GridLayout(2, 1, 0, 0));
        this.pnlTop = new JPanel();
        this.spnVdb = new JScrollPane();
        this.tableModel = new VDBTableModel();
        this.tblVdb = new TableWidget(this.tableModel);
        this.tblVdb.setAutoResizeMode(0);
        this.tblVdb.setColumnSelectionAllowed(false);
        this.tblVdb.setEditable(false);
        this.tblVdb.setSortable(true);
        this.tblVdb.sizeColumnsToFitData(100);
        this.tblVdb.setPopupMenuFactory(new TableMenuFactory(this.tblVdb, this));
        EnhancedTableColumn nameColumn = (EnhancedTableColumn)this.tblVdb.getColumn("VDB Name");
        this.tblVdb.setColumnSortedAscending(nameColumn, false);
        EnhancedTableColumn versionColumn = (EnhancedTableColumn)this.tblVdb.getColumn("Version");
        this.tblVdb.setColumnSortedAscending(versionColumn, true);
        this.tblVdb.setComparator(DefaultConsoleTableComparator.getInstance());
        this.setTableListening();
        JPanel pnlBottom = new JPanel();
        this.tpnDetails = new JTabbedPane();
        this.pnlDetails = new VdbDetailPanel(this.connection, this.bCanModify);
        VdbModelsPanel pnlModels = new VdbModelsPanel(this.connection);
        VDBMetadataTreePanel pnlTree = new VDBMetadataTreePanel(this.connection);
        this.pnlBindings = new VdbConnBindPanel(this.connection);
        this.pnlEntitlements = new VdbEntitlementsPanel(this.connection);
        MaterializationPanel pnlMaterialization = new MaterializationPanel(this.connection);
        JPanel pnlOps = new JPanel();
        this.btnImportVDB = new ButtonWidget();
        this.setup("action", this.btnImportVDB, this.actionImportVDB);
        this.actionImportVDB.setEnabled(this.bCanModify);
        this.btnExportVDB = new ButtonWidget();
        this.setup("action", this.btnExportVDB, this.actionExportVDB);
        this.actionExportVDB.setEnabled(false);
        this.setLayout(new GridBagLayout());
        this.pnlTop.setLayout(new GridBagLayout());
        this.pnlTop.setBorder(new EmptyBorder(new Insets(3, 3, 3, 3)));
        this.gbcFilterPanel = new GridBagConstraints();
        this.gbcFilterPanel.insets = new Insets(3, 3, 3, 3);
        this.gbcFilterPanel.anchor = 13;
        this.pnlTop.add((Component)this.getNoFilterPanel(), this.gbcFilterPanel);
        this.pnlTop.setMinimumSize(new Dimension(0, 0));
        pnlBottom.setMinimumSize(new Dimension(0, 0));
        pnlBottom.setBorder(new EmptyBorder(new Insets(3, 3, 3, 3)));
        this.spnVdb.setViewportView(this.tblVdb);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        this.pnlTop.add((Component)this.spnVdb, gridBagConstraints2);
        pnlBottom.setLayout(new GridLayout(1, 1));
        this.tpnDetails.addTab(DETAILS_TAB_TITLE, this.pnlDetails);
        this.tpnDetails.addTab(MODELS_TAB_TITLE, pnlModels);
        this.tpnDetails.addTab(TREE_TAB_TITLE, pnlTree);
        this.tpnDetails.addTab(CONNBIND_TAB_TITLE, this.pnlBindings);
        this.tpnDetails.addTab(ENTITLEMENTS_TAB_TITLE, this.pnlEntitlements);
        this.tpnDetails.addTab(MATERIALIZATION_TAB_TITLE, pnlMaterialization);
        this.tpnDetails.setSelectedIndex(0);
        pnlBottom.add(this.tpnDetails);
        this.splitMain = new Splitter(0, true, this.pnlTop, pnlBottom);
        this.splitMain.setOneTouchExpandable(true);
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        this.add((Component)this.splitMain, gridBagConstraints1);
        JPanel filepanel = new JPanel();
        TitledBorder tBorder = new TitledBorder("File");
        tBorder.setTitleJustification(1);
        tBorder.setTitleFont(tBorder.getTitleFont().deriveFont(1));
        filepanel.setBorder(tBorder);
        filepanel.setLayout(new FlowLayout());
        filepanel.add(this.btnImportVDB);
        filepanel.add(this.btnExportVDB);
        pnlOps.setLayout(new GridLayout(1, 2, 3, 0));
        pnlOps.add(filepanel);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.insets = new Insets(3, 3, 3, 3);
        this.add((Component)pnlOps, gridBagConstraints1);
        this.tpnDetails.addChangeListener(this);
        this.populateTable(false, null);
    }

    private void establishUserCapabilities() {
        try {
            this.ucapsCapabilities = UserCapabilities.getInstance();
            this.bCanModify = this.ucapsCapabilities.canModifyVDBs(this.connection);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void createActions() {
        this.actionImportVDB = new PanelAction(5);
        this.actionImportVDB.putValue("Name", IMPORT_VDB_TITLE);
        this.actionExportVDB = new PanelAction(6);
        this.actionExportVDB.putValue("Name", EXPORT_VDB_TITLE);
        this.actionEditConnBind = new PanelAction(2);
        this.actionEditConnBind.putValue("Name", EDIT_CONN_BIND_TITLE);
        this.actionChangeStatus = new PanelAction(3);
        this.actionChangeStatus.putValue("Name", CHANGE_VDB_STATUS_TITLE);
        this.actionChangeDefaultStatus = new PanelAction(10);
        this.actionChangeDefaultStatus.putValue("Name", CHANGE_VDB_DEFAULT_STATUS_TITLE);
        this.actionDeleteVdb = new PanelAction(4);
        this.actionDeleteVdb.putValue("Name", DELETE_VDB_TITLE);
        this.actionExportRoles = new PanelAction(8);
        this.actionExportRoles.putValue("Name", EXPORT_ROLES_TITLE);
        this.actionImportRoles = new PanelAction(9);
        this.actionImportRoles.putValue("Name", IMPORT_ROLES_TITLE);
    }

    public void establishActionArray() {
        this.setup("action", this.pnlBindings.getEditButton(), this.actionEditConnBind);
        this.actionEditConnBind.setEnabled(false);
        this.setup("action", this.pnlEntitlements.getImportRolesButton(), this.actionImportRoles);
        this.actionImportRoles.setEnabled(false);
        this.setup("action", this.pnlEntitlements.getExportRolesButton(), this.actionExportRoles);
        this.actionExportRoles.setEnabled(false);
        this.addSeparatorToActionList();
        this.addActionToList("action", this.actionChangeStatus);
        this.addActionToList("action", this.actionChangeDefaultStatus);
        this.addActionToList("action", this.actionDeleteVdb);
        this.arylPopupActions.add(this.actionImportVDB);
        this.arylPopupActions.add(this.actionExportVDB);
        this.arylPopupActions.add(this.actionEditConnBind);
        this.arylPopupActions.add(this.actionImportRoles);
        this.arylPopupActions.add(this.actionExportRoles);
        this.arylPopupActions.add(this.actionChangeStatus);
        this.arylPopupActions.add(this.actionChangeDefaultStatus);
        this.arylPopupActions.add(this.actionDeleteVdb);
    }

    private void hideFilter() {
        this.gbcFilterPanel = new GridBagConstraints();
        this.gbcFilterPanel.insets = new Insets(3, 3, 3, 3);
        this.gbcFilterPanel.anchor = 13;
        this.pnlTop.remove(this.getFilterPanel());
        this.pnlTop.add((Component)this.getNoFilterPanel(), this.gbcFilterPanel);
        this.forceRepaint();
        int iFilterHeight = this.getFilterPanel().getHeight();
        if (iFilterHeight == 0) {
            iFilterHeight = 126;
        }
        int iNoFilterHeight = this.getNoFilterPanel().getHeight();
        int iCurrentLocation = this.splitMain.getDividerLocation();
        int iOrigLocation = iCurrentLocation - (iFilterHeight - iNoFilterHeight);
        this.splitMain.setDividerLocation(iOrigLocation);
    }

    private void showFilter() {
        this.gbcFilterPanel = new GridBagConstraints();
        this.gbcFilterPanel.insets = new Insets(3, 3, 3, 3);
        this.pnlTop.remove(this.getNoFilterPanel());
        this.pnlTop.add((Component)this.getFilterPanel(), this.gbcFilterPanel);
        this.forceRepaint();
        int iFilterHeight = this.getFilterPanel().getHeight();
        if (iFilterHeight == 0) {
            iFilterHeight = 126;
        }
        int iNoFilterHeight = this.getNoFilterPanel().getHeight();
        int iOrigLocation = this.splitMain.getDividerLocation();
        this.splitMain.setDividerLocation(iOrigLocation + (iFilterHeight - iNoFilterHeight));
    }

    private void forceRepaint() {
        int iWiggleIncrement = 10;
        int iOrigLocation = this.splitMain.getDividerLocation();
        this.splitMain.setDividerLocation(iOrigLocation + iWiggleIncrement);
        this.splitMain.setDividerLocation(iOrigLocation);
        ConsoleMainFrame.getInstance().repaintNeeded();
    }

    private void editConnectorBindings() {
        this.pnlBindings.runEditConnBindDialog();
        this.editConnectorBindingsFinishProcess();
    }

    public void editConnectorBindingsFinishProcess() {
        this.setIsStale(true);
        this.refresh();
    }

    private void exportRoles() {
        VirtualDatabase vdbToExport = this.vdbSelected;
        VDBRolesExporter exporter = new VDBRolesExporter(vdbToExport, this.connection);
        exporter.go();
    }

    private void importRoles() {
        VirtualDatabase vdbForRolesImport = this.vdbSelected;
        boolean continuing = true;
        Window importRolesWizardDlg = null;
        try {
            importRolesWizardDlg = new ImportVdbRolesWizardDlg(this.getThisParent(), vdbForRolesImport, this.connection);
        }
        catch (Exception ex) {
            continuing = false;
        }
        if (continuing) {
            importRolesWizardDlg.pack();
            VdbMainPanel.setLocationOn(importRolesWizardDlg);
            ((Dialog)importRolesWizardDlg).show();
            if (((ImportVdbRolesWizardDlg)importRolesWizardDlg).finishClicked()) {
                this.setSelectedVdb(((ImportVdbRolesWizardDlg)importRolesWizardDlg).getVdb());
                this.setIsStale(true);
                this.refresh();
            }
        }
    }

    public void importVDB() {
        boolean continuing = true;
        ImportVdbVersionWizardDlg nvwWizardDlg = null;
        try {
            nvwWizardDlg = new ImportVdbVersionWizardDlg(this.getThisParent(), this.connection);
        }
        catch (Exception ex) {
            continuing = false;
        }
        if (continuing) {
            nvwWizardDlg.pack();
            VdbMainPanel.setLocationOn(nvwWizardDlg);
            nvwWizardDlg.show();
            if (nvwWizardDlg.finishClicked()) {
                this.setSelectedVdb(nvwWizardDlg.getNewVdb());
                this.setIsStale(true);
                this.refresh();
            }
        }
    }

    public void exportVDB() {
        VirtualDatabase vdbToExport = this.vdbSelected;
        VDBExporter exporter = new VDBExporter(vdbToExport, this.connection);
        exporter.go();
    }

    private void runDeleteVdb() {
        boolean bConfirmed = false;
        String vdbName = this.getSelectedVdb().getName();
        VirtualDatabaseID vdbID = (VirtualDatabaseID)this.getSelectedVdb().getID();
        int vdbVersion = new Integer(vdbID.getVersion());
        ArrayList entitlementsForVDB = null;
        try {
            entitlementsForVDB = ModelManager.getEntitlementManager(this.connection).getEntitlementsForVDB(vdbName, vdbVersion);
        }
        catch (Exception ex) {
            entitlementsForVDB = new ArrayList(0);
        }
        if (entitlementsForVDB.size() > 0) {
            DeleteConfirmationDialogForVDBWithEntitlements dlg = new DeleteConfirmationDialogForVDBWithEntitlements(vdbName, vdbVersion, entitlementsForVDB);
            dlg.show();
            bConfirmed = dlg.confirmed();
        } else {
            bConfirmed = DialogUtility.yesNoDialog(null, "Delete VirtualDatabase " + vdbName + ", Version " + vdbVersion + "?", "Confirm Deletion");
        }
        if (bConfirmed) {
            this.deleteVdb();
            this.setIsStale(true);
            this.refresh();
            WorkspaceController.getInstance().handleUpdateNotification(this.getVdbManager().getConnection(), new DataEntitlementChangeNotification());
        }
    }

    private void deleteVdb() {
        try {
            VirtualDatabaseID vdbID = (VirtualDatabaseID)this.getSelectedVdb().getID();
            this.getVdbManager().markVDBForDelete(vdbID);
        }
        catch (Exception e) {
            ExceptionUtility.showMessage("Failed to mark this VDB for delete ", e);
        }
    }

    private JPanel getNoFilterPanel() {
        if (this.pnlNoFilter == null) {
            this.pnlNoFilter = new JPanel(new FlowLayout(2, 10, 10));
            this.btnShowFilter = new ButtonWidget("Show Filter");
            this.btnShowFilter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    VdbMainPanel.this.showFilter();
                }
            });
            this.pnlNoFilter.add(this.btnShowFilter);
            Dimension dim = new Dimension(this.getFilterPanel().getPreferredSize().width, this.pnlNoFilter.getPreferredSize().height);
            this.pnlNoFilter.setPreferredSize(dim);
        }
        return this.pnlNoFilter;
    }

    private JPanel getFilterPanel() {
        if (this.pnlFilter == null) {
            this.pnlFilter = new JPanel();
            this.lblName = new JLabel();
            this.txfName = new JTextField();
            this.pnlStatus = new JPanel();
            this.chkActive = new JCheckBox();
            this.chkActiveDefault = new JCheckBox();
            this.chkInactive = new JCheckBox();
            this.chkIncomplete = new JCheckBox();
            this.chkDeleted = new JCheckBox();
            this.pnlVersion = new JPanel();
            this.rdbAllVersions = new JRadioButton();
            this.rdbLatestVersion = new JRadioButton();
            this.bgrpVersionGroup = new ButtonGroup();
            this.rdbAllVersions.setSelected(true);
            this.bgrpVersionGroup.add(this.rdbAllVersions);
            this.bgrpVersionGroup.add(this.rdbLatestVersion);
            this.txfName.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    VdbMainPanel.this.enableApplyResetButtons(true);
                }
            });
            this.chkActive.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    VdbMainPanel.this.enableApplyResetButtons(true);
                }
            });
            this.chkActiveDefault.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    VdbMainPanel.this.enableApplyResetButtons(true);
                }
            });
            this.chkInactive.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    VdbMainPanel.this.enableApplyResetButtons(true);
                }
            });
            this.chkIncomplete.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    VdbMainPanel.this.enableApplyResetButtons(true);
                }
            });
            this.chkDeleted.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    VdbMainPanel.this.enableApplyResetButtons(true);
                }
            });
            this.rdbAllVersions.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    VdbMainPanel.this.enableApplyResetButtons(true);
                }
            });
            this.rdbLatestVersion.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    VdbMainPanel.this.enableApplyResetButtons(true);
                }
            });
            this.pnlFilterOps = new JPanel();
            this.pnlFilterOpsSizer = new JPanel();
            this.btnApply = new ButtonWidget();
            this.btnReset = new ButtonWidget();
            this.btnHideFilter = new ButtonWidget();
            this.btnHideFilter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    VdbMainPanel.this.hideFilter();
                }
            });
            this.pnlFilter.setLayout(new GridBagLayout());
            this.pnlFilter.setBorder(new TitledBorder("Filter"));
            this.lblName.setText("Name: ");
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.insets = new Insets(3, 3, 3, 3);
            gridBagConstraints3.anchor = 17;
            this.pnlFilter.add((Component)this.lblName, gridBagConstraints3);
            this.txfName.setColumns(25);
            gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 1;
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.gridwidth = 2;
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.insets = new Insets(3, 3, 3, 3);
            gridBagConstraints3.anchor = 17;
            this.pnlFilter.add((Component)this.txfName, gridBagConstraints3);
            this.pnlStatus.setBorder(new TitledBorder("Statuses"));
            this.chkActive.setText("Active");
            this.pnlStatus.add(this.chkActive);
            this.chkActiveDefault.setText("Active-Default");
            this.pnlStatus.add(this.chkActiveDefault);
            this.chkInactive.setText("Inactive");
            this.pnlStatus.add(this.chkInactive);
            this.chkIncomplete.setText("Incomplete");
            this.pnlStatus.add(this.chkIncomplete);
            this.chkDeleted.setText("Deleted");
            this.pnlStatus.add(this.chkDeleted);
            gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 1;
            gridBagConstraints3.gridwidth = 3;
            gridBagConstraints3.insets = new Insets(3, 3, 3, 3);
            gridBagConstraints3.anchor = 17;
            this.pnlFilter.add((Component)this.pnlStatus, gridBagConstraints3);
            this.pnlVersion.setBorder(new TitledBorder("Versions"));
            this.rdbAllVersions.setText("All");
            this.pnlVersion.add(this.rdbAllVersions);
            this.rdbLatestVersion.setText("Latest Only");
            this.pnlVersion.add(this.rdbLatestVersion);
            gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 3;
            gridBagConstraints3.gridy = 1;
            gridBagConstraints3.gridwidth = 2;
            gridBagConstraints3.insets = new Insets(3, 3, 3, 3);
            gridBagConstraints3.anchor = 17;
            this.pnlFilter.add((Component)this.pnlVersion, gridBagConstraints3);
            this.pnlFilterOpsSizer.setLayout(new GridLayout(2, 1, 0, 5));
            this.btnApply.setText("Apply");
            this.pnlFilterOpsSizer.add(this.btnApply);
            this.btnReset.setText("Reset");
            this.pnlFilterOpsSizer.add(this.btnReset);
            this.pnlFilterOps.add(this.pnlFilterOpsSizer);
            this.btnApply.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    VdbMainPanel.this.applyFilter();
                }
            });
            this.btnReset.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    VdbMainPanel.this.resetFilterState();
                }
            });
            gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 5;
            gridBagConstraints3.gridy = 1;
            gridBagConstraints3.insets = new Insets(3, 3, 3, 3);
            this.pnlFilter.add((Component)this.pnlFilterOps, gridBagConstraints3);
            this.btnHideFilter.setText("Hide Filter");
            gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 2;
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.gridwidth = 0;
            gridBagConstraints3.insets = new Insets(3, 3, 3, 3);
            gridBagConstraints3.anchor = 13;
            this.pnlFilter.add((Component)this.btnHideFilter, gridBagConstraints3);
            this.initFilterState();
        }
        return this.pnlFilter;
    }

    private void applyFilter() {
        this.populateTable(true, this.getSelectedVdb());
        this.setBaseFilterFromCurrentFilterState();
    }

    private void enableApplyResetButtons(boolean bNewState) {
        if (this.bCanModify) {
            this.btnApply.setEnabled(bNewState);
            this.btnReset.setEnabled(bNewState);
        } else {
            this.btnApply.setEnabled(false);
            this.btnReset.setEnabled(false);
        }
    }

    private void initFilterState() {
        this.bIncompleteBaseState = true;
        this.bInactiveBaseState = true;
        this.bActiveBaseState = true;
        this.bActiveDefaultBaseState = true;
        this.bDeletedBaseState = true;
        this.bAllVersionsBaseState = true;
        this.bLatestVersionsBaseState = false;
        this.sNameFilterBaseState = "*";
        this.resetFilterState();
    }

    private void resetFilterState() {
        this.chkIncomplete.setSelected(this.bIncompleteBaseState);
        this.chkInactive.setSelected(this.bInactiveBaseState);
        this.chkActive.setSelected(this.bActiveBaseState);
        this.chkActiveDefault.setSelected(this.bActiveDefaultBaseState);
        this.chkDeleted.setSelected(this.bDeletedBaseState);
        this.rdbAllVersions.setSelected(this.bAllVersionsBaseState);
        this.rdbLatestVersion.setSelected(this.bLatestVersionsBaseState);
        this.txfName.setText(this.sNameFilterBaseState);
    }

    private void setBaseFilterFromCurrentFilterState() {
        this.bIncompleteBaseState = this.chkIncomplete.isSelected();
        this.bInactiveBaseState = this.chkInactive.isSelected();
        this.bActiveBaseState = this.chkActive.isSelected();
        this.bActiveDefaultBaseState = this.chkActiveDefault.isSelected();
        this.bDeletedBaseState = this.chkDeleted.isSelected();
        this.bAllVersionsBaseState = this.rdbAllVersions.isSelected();
        this.bLatestVersionsBaseState = this.rdbLatestVersion.isSelected();
        this.sNameFilterBaseState = this.txfName.getText();
    }

    private Collection applyFilter(Collection colVdbs) {
        VirtualDatabase vdbTemp2 = null;
        Collection<VirtualDatabase> colResultVdbs = new Vector();
        for (VirtualDatabase vdbTemp2 : colVdbs) {
            if (!this.passesExcludeFilters(vdbTemp2)) continue;
            colResultVdbs.add(vdbTemp2);
        }
        if (!this.rdbAllVersions.isSelected()) {
            colResultVdbs = this.applyVersionFilter(colResultVdbs);
        }
        return colResultVdbs;
    }

    private boolean passesExcludeFilters(VirtualDatabase vdb) {
        boolean bResult = true;
        if (vdb.getStatus() == 3 && !this.chkActive.isSelected()) {
            bResult = false;
        } else if (vdb.getStatus() == 3 && !this.chkActiveDefault.isSelected()) {
            bResult = false;
        } else if (vdb.getStatus() == 2 && !this.chkInactive.isSelected()) {
            bResult = false;
        } else if (vdb.getStatus() == 1 && !this.chkIncomplete.isSelected()) {
            bResult = false;
        } else if (vdb.getStatus() == 4 && !this.chkDeleted.isSelected()) {
            bResult = false;
        }
        if (bResult) {
            bResult = PropertiesUtils.filterTest((String)this.txfName.getText(), (String)vdb.getName());
        }
        return bResult;
    }

    private Collection applyVersionFilter(Collection colVdbs) {
        HashMap<String, VirtualDatabase> hmapHighVersionVdbs = new HashMap<String, VirtualDatabase>();
        VirtualDatabase vdbCandidateVdb2 = null;
        VirtualDatabase vdbTemp = null;
        String sCandidateVdbVersion = "";
        String sTempVdbVersion = "";
        int iCandidateVdbVersion = 0;
        int iTempVdbVersion = 0;
        for (VirtualDatabase vdbCandidateVdb2 : colVdbs) {
            vdbTemp = (VirtualDatabase)hmapHighVersionVdbs.get(vdbCandidateVdb2.getName());
            if (vdbTemp == null) {
                hmapHighVersionVdbs.put(vdbCandidateVdb2.getName(), vdbCandidateVdb2);
                continue;
            }
            sCandidateVdbVersion = this.getVdbVersion(vdbCandidateVdb2);
            iCandidateVdbVersion = Integer.parseInt(sCandidateVdbVersion);
            if (iCandidateVdbVersion <= (iTempVdbVersion = Integer.parseInt(sTempVdbVersion = this.getVdbVersion(vdbTemp)))) continue;
            hmapHighVersionVdbs.remove(vdbTemp.getName());
            hmapHighVersionVdbs.put(vdbCandidateVdb2.getName(), vdbCandidateVdb2);
        }
        return hmapHighVersionVdbs.values();
    }

    private String getVdbVersion(VirtualDatabase vdb) {
        VirtualDatabaseID vdbid = (VirtualDatabaseID)vdb.getID();
        return vdbid.getVersion();
    }

    private void runChangeStatusDialog(boolean changeDefaultStatus) {
        VdbSetStatusDlg vssdlg = new VdbSetStatusDlg(this.getSelectedVdb(), this.connection, changeDefaultStatus);
        vssdlg.pack();
        VdbMainPanel.setLocationOn(vssdlg);
        vssdlg.setModal(true);
        vssdlg.show();
        this.setIsStale(true);
        this.refresh();
    }

    public static void setLocationOn(Component comp) {
        Point p = StaticUtilities.centerFrame(comp.getSize());
        comp.setLocation(p.x, p.y);
    }

    public void setParent(JFrame frame) {
        this.frParentFrame = frame;
    }

    public JFrame getThisParent() {
        if (this.frParentFrame == null) {
            this.frParentFrame = ViewManager.getMainFrame();
        }
        return this.frParentFrame;
    }

    private void emptyTheTable() {
        this.tableModel.setRowCount(0);
    }

    private void populateTable(boolean bApplyFilter, VirtualDatabase vdbToSelect) {
        this.emptyTheTable();
        StaticUtilities.getDefaultDateFormat();
        List colVdbs = null;
        try {
            colVdbs = this.getVdbs();
        }
        catch (Exception e) {
            ExceptionUtility.showMessage("Failed while retrieving VDBs ", e);
        }
        if (colVdbs != null) {
            this.colDisplayedVdbs = bApplyFilter ? this.applyFilter(colVdbs) : colVdbs;
            short siStatus = 0;
            Iterator it = this.colDisplayedVdbs.iterator();
            int iCount = 0;
            while (it.hasNext()) {
                ++iCount;
                Vector<Object> vVdbRow = new Vector<Object>();
                VirtualDatabase vdbTemp = (VirtualDatabase)it.next();
                vVdbRow.add(vdbTemp.getName());
                VirtualDatabaseID vdbid = (VirtualDatabaseID)vdbTemp.getID();
                vVdbRow.add(new Integer(vdbid.getVersion()));
                siStatus = vdbTemp.getStatus();
                vVdbRow.add(this.getVdbManager().getVdbStatusAsString(siStatus));
                Date versionDate = vdbTemp.getVersionDate();
                vVdbRow.add(versionDate);
                vVdbRow.add(vdbTemp.getVersionBy());
                this.tableModel.addRow(vVdbRow);
            }
        }
        this.programmaticChange = true;
        this.tblVdb.sort();
        this.programmaticChange = false;
        this.setSelectedVdb(vdbToSelect);
        this.reselectCurrentVdbInTable();
    }

    public void setIsStale(boolean bIsStale) {
        this.bIsStale = bIsStale;
    }

    public boolean isStale() {
        return this.bIsStale;
    }

    private List getVdbs() throws Exception {
        if (this.colVdbs == null) {
            this.colVdbs = this.getVdbManager().getVDBs();
        }
        Vector vVdbs = new Vector(this.colVdbs);
        return vVdbs;
    }

    private List getDisplayedVdbs() {
        Vector vVdbs = new Vector(this.colDisplayedVdbs);
        return vVdbs;
    }

    private void setTableListening() {
        this.tblVdb.setSelectionMode(0);
        this.rowSM = this.tblVdb.getSelectionModel();
        this.rowSM.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting() && !VdbMainPanel.this.programmaticChange) {
                    int iTrueModelRow = 0;
                    int iSelectionIndex = 0;
                    ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                    if (lsm.isSelectionEmpty()) {
                        VdbMainPanel.this.updateDetailForTableDeselection();
                    } else {
                        iSelectionIndex = lsm.getMinSelectionIndex();
                        if (iSelectionIndex >= 0) {
                            iTrueModelRow = VdbMainPanel.this.tblVdb.convertRowIndexToModel(iSelectionIndex);
                            VdbMainPanel.this.updateDetailForTableSelection(iTrueModelRow);
                        } else {
                            VdbMainPanel.this.updateDetailForTableDeselection();
                        }
                    }
                }
            }
        });
    }

    private void updateDetailForTableSelection(int iRow) {
        VirtualDatabase vdbSelected = null;
        try {
            vdbSelected = (VirtualDatabase)this.getDisplayedVdbs().get(iRow);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setSelectedVdb(vdbSelected);
        this.alignVisibleDetailPanelWithTableChoice();
        this.actionExportVDB.setEnabled(true);
        if (this.bCanModify) {
            this.setEnabledForChangeStatusAction();
            this.setEnabledForChangeDefaultStatusAction();
            this.setEnabledForDeleteAction();
            this.actionExportVDB.setEnabled(true);
        } else {
            this.actionDeleteVdb.setEnabled(false);
            this.actionChangeStatus.setEnabled(false);
            this.actionChangeDefaultStatus.setEnabled(false);
        }
        this.forceRepaint();
    }

    private void setEnabledForChangeStatusAction() {
        VirtualDatabase vdb = this.getSelectedVdb();
        if (vdb != null) {
            short siCurrStatus = vdb.getStatus();
            if (siCurrStatus == 3 || siCurrStatus == 3 || siCurrStatus == 2) {
                this.actionChangeStatus.setEnabled(true);
                this.actionChangeStatus.putValue("Name", this.getChangeStatusLabel(siCurrStatus));
            } else {
                this.actionChangeStatus.putValue("Name", CHANGE_VDB_STATUS_TITLE);
                this.actionChangeStatus.setEnabled(false);
            }
        } else {
            this.actionChangeStatus.setEnabled(false);
        }
    }

    private String getChangeStatusLabel(short siCurrStatus) {
        String sChangeStatusBase = CHANGE_VDB_STATUS_ROOT;
        if (siCurrStatus == 3 || siCurrStatus == 3) {
            sChangeStatusBase = sChangeStatusBase + INACTIVE;
        } else if (siCurrStatus == 2) {
            sChangeStatusBase = sChangeStatusBase + ACTIVE;
        }
        return sChangeStatusBase;
    }

    private void setEnabledForChangeDefaultStatusAction() {
        VirtualDatabase vdb = this.getSelectedVdb();
        int nVersions = this.getNumberOfVersionsForVdb(vdb);
        boolean hasActiveDefault = this.hasActiveDefault(vdb);
        if (vdb != null) {
            short siCurrStatus = vdb.getStatus();
            if (nVersions <= 1) {
                this.actionChangeDefaultStatus.setEnabled(false);
                this.actionChangeDefaultStatus.putValue("Name", CHANGE_VDB_DEFAULT_STATUS_TITLE);
            } else if (!hasActiveDefault) {
                this.actionChangeDefaultStatus.putValue("Name", this.getChangeDefaultStatusLabel(siCurrStatus));
                this.actionChangeDefaultStatus.setEnabled(true);
            } else {
                this.actionChangeDefaultStatus.putValue("Name", this.getChangeDefaultStatusLabel(siCurrStatus));
                if (siCurrStatus == 3) {
                    this.actionChangeDefaultStatus.setEnabled(true);
                } else {
                    this.actionChangeDefaultStatus.setEnabled(false);
                }
            }
        } else {
            this.actionChangeDefaultStatus.setEnabled(false);
        }
    }

    private String getChangeDefaultStatusLabel(short siCurrStatus) {
        String sChangeStatusBase = CHANGE_VDB_STATUS_ROOT;
        if (siCurrStatus == 3 || siCurrStatus == 2) {
            sChangeStatusBase = sChangeStatusBase + ACTIVE_DEFAULT;
        } else if (siCurrStatus == 3) {
            sChangeStatusBase = sChangeStatusBase + ACTIVE;
        }
        return sChangeStatusBase;
    }

    private void setEnabledForDeleteAction() {
        VirtualDatabase vdb = this.getSelectedVdb();
        if (vdb != null) {
            short siCurrStatus = vdb.getStatus();
            if (siCurrStatus == 1 || siCurrStatus == 2) {
                this.actionDeleteVdb.setEnabled(true);
            } else {
                this.actionDeleteVdb.setEnabled(false);
            }
        } else {
            this.actionDeleteVdb.setEnabled(false);
        }
    }

    private VirtualDatabase getSelectedVdb() {
        return this.vdbSelected;
    }

    private void setSelectedVdb(VirtualDatabase vdb) {
        this.vdbSelected = vdb;
    }

    private void updateDetailForTableDeselection() {
        this.actionExportVDB.setEnabled(false);
        this.actionChangeStatus.setEnabled(false);
        this.actionChangeDefaultStatus.setEnabled(false);
        this.actionDeleteVdb.setEnabled(false);
        this.actionEditConnBind.setEnabled(false);
        this.actionExportRoles.setEnabled(false);
        this.actionImportRoles.setEnabled(false);
        this.setSelectedVdb(null);
        this.alignVisibleDetailPanelWithTableChoice();
        this.forceRepaint();
    }

    @Override
    public void receiveUpdateNotification(RuntimeUpdateNotification notification) {
    }

    @Override
    public List resume() {
        return this.arylActions;
    }

    @Override
    public ConnectionInfo getConnection() {
        return this.connection;
    }

    @Override
    public void postRealize() {
        this.splitMain.setDividerLocation(0.5);
        this.splitMain.getDividerLocation();
        if (this.tblVdb.getRowCount() > 0) {
            this.tblVdb.setRowSelectionInterval(0, 0);
        }
    }

    public List getCurrentActions() {
        return this.arylActions;
    }

    public void addActionToList(String sID, Action act) {
        this.arylActions.add(new MenuEntry(sID, act));
    }

    private void addSeparatorToActionList() {
        this.arylActions.add(MenuEntry.getSeparator());
    }

    @Override
    public void refresh() {
        VirtualDatabase vdbCurrent = this.getSelectedVdb();
        this.colVdbs = null;
        this.populateTable(false, vdbCurrent);
        this.colDisplayedVdbs = this.colVdbs;
        this.forceRepaint();
    }

    private void reselectCurrentVdbInTable() {
        VirtualDatabase vdbCurrent = this.getSelectedVdb();
        if (vdbCurrent != null) {
            int iRow = this.getModelRowForVdb(vdbCurrent);
            if (iRow >= 0) {
                int viewRow = this.tblVdb.convertRowIndexToView(iRow);
                this.tblVdb.getSelectionModel().setSelectionInterval(viewRow, viewRow);
                this.tblVdb.scrollRectToVisible(this.tblVdb.getCellRect(viewRow, 0, true));
            } else {
                this.setSelectedVdb(null);
                this.tblVdb.clearSelection();
                this.updateDetailForTableDeselection();
            }
        } else {
            this.tblVdb.clearSelection();
            this.updateDetailForTableDeselection();
        }
    }

    private int getModelRowForVdb(VirtualDatabase vdb) {
        int matchRow = -1;
        int numRows = this.tblVdb.getRowCount();
        int row = 0;
        String sSelectedVdbName = vdb.getName();
        String sSelectedVdbVersion = this.getVdbVersion(vdb);
        while (row < numRows && matchRow < 0) {
            String sVdbName = this.tblVdb.getModel().getValueAt(row, 0).toString();
            String sVdbVersion = this.tblVdb.getModel().getValueAt(row, 1).toString();
            if (sSelectedVdbName.equals(sVdbName) && sSelectedVdbVersion.equals(sVdbVersion)) {
                matchRow = row;
                continue;
            }
            ++row;
        }
        return matchRow;
    }

    private int getNumberOfVersionsForVdb(VirtualDatabase vdb) {
        int nVersions = 0;
        int numRows = this.tblVdb.getRowCount();
        String sSelectedVdbName = vdb.getName();
        for (int row = 0; row < numRows; ++row) {
            String sVdbName = this.tblVdb.getModel().getValueAt(row, 0).toString();
            if (!sSelectedVdbName.equals(sVdbName)) continue;
            ++nVersions;
        }
        return nVersions;
    }

    private boolean hasActiveDefault(VirtualDatabase vdb) {
        boolean hasActiveDefault = false;
        int numRows = this.tblVdb.getRowCount();
        String sSelectedVdbName = vdb.getName();
        for (int row = 0; row < numRows; ++row) {
            String sVdbStatus;
            String sVdbName = this.tblVdb.getModel().getValueAt(row, 0).toString();
            if (!sSelectedVdbName.equals(sVdbName) || !ACTIVE_DEFAULT_DISPLAY_LABEL.equals(sVdbStatus = this.tblVdb.getModel().getValueAt(row, 2).toString())) continue;
            hasActiveDefault = true;
            break;
        }
        return hasActiveDefault;
    }

    public boolean havePendingChanges() {
        boolean haveChanges = false;
        return haveChanges;
    }

    public boolean finishUp() {
        return true;
    }

    @Override
    public String getTitle() {
        return VDB_MANAGEMENT_TITLE;
    }

    public void setMainButtons() {
        this.tpnDetails.getTitleAt(this.tpnDetails.getSelectedIndex());
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        this.setMainButtons();
        this.alignVisibleDetailPanelWithTableChoice();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void alignVisibleDetailPanelWithTableChoice() {
        try {
            StaticUtilities.startWait(ViewManager.getMainFrame());
            VdbDisplayer vdspDisplayPanel = this.getCurrentDetailPanel();
            vdspDisplayPanel.setVirtualDatabase(this.getSelectedVdb());
        }
        catch (Exception e) {
            ExceptionUtility.showMessage("Failed while tabbing in MainPanel", e);
        }
        finally {
            StaticUtilities.endWait(ViewManager.getMainFrame());
        }
        String sTitle = this.tpnDetails.getTitleAt(this.tpnDetails.getSelectedIndex());
        boolean editBindingsEnabled = false;
        boolean importRolesEnabled = false;
        boolean exportRolesEnabled = false;
        if (this.bCanModify) {
            short status;
            VirtualDatabase vdb;
            if (sTitle.equals(CONNBIND_TAB_TITLE) && (vdb = this.getSelectedVdb()) != null && ((status = vdb.getStatus()) == 2 || status == 1)) {
                editBindingsEnabled = true;
            }
            if (sTitle.equals(ENTITLEMENTS_TAB_TITLE) && this.getSelectedVdb() != null) {
                importRolesEnabled = true;
                if (this.pnlEntitlements.hasRoles()) {
                    exportRolesEnabled = true;
                }
            }
        }
        this.actionEditConnBind.setEnabled(editBindingsEnabled);
        this.actionImportRoles.setEnabled(importRolesEnabled);
        this.actionExportRoles.setEnabled(exportRolesEnabled);
        this.forceRepaint();
    }

    public VdbDisplayer getCurrentDetailPanel() {
        VdbDisplayer vdbDisplayer = (VdbDisplayer)((Object)this.tpnDetails.getSelectedComponent());
        return vdbDisplayer;
    }

    private void setup(String sID, AbstractButton theButton, AbstractPanelAction theAction) {
        theAction.addComponent(theButton);
        this.addActionToList(sID, theAction);
    }

    public List getTableActions() {
        return this.arylPopupActions;
    }

    private static class TableMenuFactory
    extends DefaultPopupMenuFactory {
        JPopupMenu pop = new JPopupMenu();
        VdbMainPanel pnl;

        public TableMenuFactory(TableWidget theTable, VdbMainPanel thePanel) {
            this.pnl = thePanel;
        }

        protected JPopupMenu createTreePopupMenu(TableWidget table) {
            return this.pop;
        }

        @Override
        public JPopupMenu getPopupMenu(Component context) {
            if (context instanceof TableWidget) {
                this.pop.removeAll();
                List actions = this.pnl.getTableActions();
                if (actions != null) {
                    int size = actions.size();
                    int i = 0;
                    while (i < size) {
                        this.pop.add((Action)actions.get(i++));
                    }
                    return this.pop;
                }
            }
            return null;
        }
    }

    private class PanelAction
    extends AbstractPanelAction {
        public static final int EDIT_CONN_BIND = 2;
        public static final int CHANGE_STATUS = 3;
        public static final int DELETE_VDB = 4;
        public static final int IMPORT_VDB = 5;
        public static final int EXPORT_VDB = 6;
        public static final int EXPORT_ROLES = 8;
        public static final int IMPORT_ROLES = 9;
        public static final int CHANGE_DEFAULT_STATUS = 10;

        public PanelAction(int theType) {
            super(theType);
        }

        @Override
        public void actionImpl(ActionEvent theEvent) {
            if (this.type == 5) {
                VdbMainPanel.this.importVDB();
            } else if (this.type == 6) {
                VdbMainPanel.this.exportVDB();
            } else if (this.type == 2) {
                VdbMainPanel.this.editConnectorBindings();
            } else if (this.type == 8) {
                VdbMainPanel.this.exportRoles();
            } else if (this.type == 9) {
                VdbMainPanel.this.importRoles();
            } else if (this.type == 3) {
                VdbMainPanel.this.runChangeStatusDialog(false);
            } else if (this.type == 10) {
                VdbMainPanel.this.runChangeStatusDialog(true);
            } else if (this.type == 4) {
                VdbMainPanel.this.runDeleteVdb();
            }
        }
    }
}

