/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.vdb;

import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.models.VdbManager;
import com.metamatrix.console.ui.views.DefaultConsoleTableComparator;
import com.metamatrix.console.ui.views.vdb.VDBModelsPanelTableModel;
import com.metamatrix.console.ui.views.vdb.VdbDisplayer;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.metadata.runtime.api.VirtualDatabase;
import com.metamatrix.metadata.runtime.api.VirtualDatabaseID;
import com.metamatrix.toolbox.ui.widget.TableWidget;
import com.metamatrix.toolbox.ui.widget.TitledBorder;
import com.metamatrix.toolbox.ui.widget.table.EnhancedTableColumn;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class VdbModelsPanel
extends JPanel
implements VdbDisplayer {
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel pnlOuter = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    Border border1;
    JPanel pnlVdbName = new JPanel();
    FlowLayout flowLayout1 = new FlowLayout();
    JPanel pnlModelTable = new JPanel();
    JTextField txfVdbName = new JTextField();
    JLabel lblVdbName = new JLabel();
    JScrollPane jScrollPane1;
    VDBModelsPanelTableModel tableModel;
    TableWidget tblVdbModels;
    Border border2;
    TitledBorder titledBorder1;
    Border border3;
    JTextField txfVersion = new JTextField();
    VirtualDatabase vdbCurrent = null;
    ConnectionInfo connection = null;

    public VdbModelsPanel(ConnectionInfo connection) {
        this.connection = connection;
        try {
            this.init();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private VdbManager getVdbManager() {
        return ModelManager.getVdbManager(this.connection);
    }

    @Override
    public void setVirtualDatabase(VirtualDatabase vdb) {
        if (this.vdbCurrent != vdb) {
            this.vdbCurrent = vdb;
            this.refresh();
        }
    }

    public VirtualDatabase getVirtualDatabase() {
        return this.vdbCurrent;
    }

    public void refresh() {
        if (this.getVirtualDatabase() == null) {
            this.clear();
        } else {
            Collection colModels = null;
            VirtualDatabaseID vdbID = (VirtualDatabaseID)this.getVirtualDatabase().getID();
            boolean continuing = true;
            try {
                colModels = this.getVdbManager().getVdbModels(vdbID);
            }
            catch (Exception e) {
                ExceptionUtility.showMessage("Failed retrieving models for a VDB", e);
                continuing = false;
            }
            if (continuing) {
                this.tableModel.populate(colModels);
                this.tblVdbModels.sort();
                this.txfVdbName.setText(this.getVirtualDatabase().getName());
            }
        }
    }

    public void clear() {
        this.txfVdbName.setText("");
        this.txfVersion.setText("");
        this.tableModel.populate(null);
    }

    private void init() throws Exception {
        this.tableModel = new VDBModelsPanelTableModel();
        this.tblVdbModels = new TableWidget(this.tableModel);
        EnhancedTableColumn col = (EnhancedTableColumn)this.tblVdbModels.getColumn("Model Name");
        this.tblVdbModels.setColumnSortedAscending(col, false);
        this.tblVdbModels.setColumnSortedAscending(col, true);
        this.tblVdbModels.setPreferredScrollableViewportSize(new Dimension(this.tblVdbModels.getPreferredSize().width, 4 * this.tblVdbModels.getRowHeight()));
        this.tblVdbModels.setEditable(false);
        this.tblVdbModels.setSortable(true);
        this.tblVdbModels.sizeColumnsToFitData(100);
        this.tblVdbModels.setCellSelectionEnabled(false);
        this.tblVdbModels.setComparator(DefaultConsoleTableComparator.getInstance());
        this.border1 = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        this.titledBorder1 = new TitledBorder("");
        this.border3 = BorderFactory.createCompoundBorder(this.titledBorder1, BorderFactory.createEmptyBorder(10, 5, 5, 5));
        this.setLayout(this.borderLayout1);
        this.pnlOuter.setLayout(new GridBagLayout());
        this.pnlOuter.setBorder(this.border1);
        this.pnlVdbName.setLayout(this.flowLayout1);
        this.txfVdbName.setPreferredSize(new Dimension(263, 21));
        this.txfVdbName.setMinimumSize(this.txfVdbName.getPreferredSize());
        this.txfVdbName.setEditable(false);
        this.txfVdbName.setText("Sales VDB");
        this.lblVdbName.setText("VDB Name:");
        this.pnlModelTable.setLayout(new GridBagLayout());
        this.pnlModelTable.setBorder(this.border3);
        this.txfVersion.setPreferredSize(new Dimension(50, 21));
        this.txfVersion.setMinimumSize(this.txfVersion.getPreferredSize());
        this.txfVersion.setEditable(false);
        this.txfVersion.setText("17");
        this.pnlOuter.add((Component)this.lblVdbName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.pnlOuter.add((Component)this.txfVdbName, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 1, 0));
        this.pnlOuter.add((Component)this.txfVersion, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 1, 0));
        this.add((Component)this.pnlOuter, "Center");
        GridBagConstraints gridBagConstraints2a = new GridBagConstraints();
        gridBagConstraints2a.gridx = 0;
        gridBagConstraints2a.gridy = 1;
        gridBagConstraints2a.fill = 1;
        gridBagConstraints2a.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints2a.anchor = 17;
        gridBagConstraints2a.weightx = 1.0;
        gridBagConstraints2a.weighty = 1.0;
        gridBagConstraints2a.gridwidth = 4;
        this.pnlOuter.add((Component)this.pnlModelTable, gridBagConstraints2a);
        this.jScrollPane1 = new JScrollPane(this.tblVdbModels);
        this.pnlModelTable.add((Component)this.jScrollPane1, null);
        this.jScrollPane1.setViewportView(this.tblVdbModels);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        this.pnlModelTable.add((Component)this.jScrollPane1, gridBagConstraints2);
        this.refresh();
    }
}

