/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.vdb;

import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.models.VdbManager;
import com.metamatrix.console.ui.ViewManager;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.metadata.runtime.api.VirtualDatabase;
import com.metamatrix.metadata.runtime.api.VirtualDatabaseID;
import com.metamatrix.toolbox.ui.widget.DialogPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class VdbSetStatusDlg
extends JDialog {
    private VirtualDatabase theVdb = null;
    private ConnectionInfo connection = null;
    private DialogPanel dlgpnlDialogContainer = new DialogPanel();
    private JPanel pnlID = new JPanel();
    private JPanel pnlOuter = new JPanel();
    private short siNewStatus = 0;
    private short siCurrStatus = 0;
    private static final String SET_STATUS_TEXT = "Click OK to Change VDB Status to ";

    public VdbSetStatusDlg(VirtualDatabase theVdb, ConnectionInfo connection, boolean changeDefaultStatus) {
        super(ViewManager.getMainFrame());
        ViewManager.getMainFrame();
        this.theVdb = theVdb;
        this.connection = connection;
        this.siCurrStatus = theVdb.getStatus();
        this.siNewStatus = this.determinePossibleNewStatus(this.siCurrStatus, changeDefaultStatus);
        try {
            this.init();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private VdbManager getVdbManager() {
        return ModelManager.getVdbManager(this.connection);
    }

    private short determinePossibleNewStatus(short siCurrStatus, boolean changingDefaultStatus) {
        if (!changingDefaultStatus) {
            if (siCurrStatus == 3 || siCurrStatus == 3) {
                return 2;
            }
            if (siCurrStatus == 2) {
                return 3;
            }
        } else {
            if (siCurrStatus == 3 || siCurrStatus == 2) {
                return 3;
            }
            if (siCurrStatus == 3) {
                return 3;
            }
        }
        return 0;
    }

    private void init() throws Exception {
        this.dlgpnlDialogContainer.setContent(this.getSetStatusPanel());
        this.addListeners();
        this.getContentPane().add(this.dlgpnlDialogContainer);
        this.setTitle("Change Status for " + this.getVdb().getName());
    }

    private VirtualDatabase getVdb() {
        return this.theVdb;
    }

    private VirtualDatabaseID getVdbId() {
        VirtualDatabaseID vdbID = (VirtualDatabaseID)this.getVdb().getID();
        return vdbID;
    }

    private void addListeners() {
        this.dlgpnlDialogContainer.getAcceptButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                VdbSetStatusDlg.this.processAcceptButton();
            }
        });
        this.dlgpnlDialogContainer.getCancelButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                VdbSetStatusDlg.this.processCancelButton();
            }
        });
    }

    private void processAcceptButton() {
        this.updateStatus();
        this.dispose();
    }

    private void processCancelButton() {
        this.dispose();
    }

    private void updateStatus() {
        try {
            this.getVdbManager().setVDBState(this.getVdbId(), this.siNewStatus);
        }
        catch (Exception e) {
            ExceptionUtility.showMessage("Failed to update Connector Binding names ", e);
        }
    }

    private JPanel getSetStatusPanel() {
        JPanel pnlBlather = new JPanel();
        JLabel lblBlather = new JLabel();
        JLabel lblNewStatus = new JLabel();
        lblBlather.setText(SET_STATUS_TEXT);
        lblNewStatus.setText(this.getVdbManager().getVdbStatusAsString(this.siNewStatus));
        lblNewStatus.setFont(new Font("Dialog", 1, 14));
        pnlBlather.add(lblBlather);
        pnlBlather.add(lblNewStatus);
        this.pnlOuter.setLayout(new GridBagLayout());
        this.pnlID.setLayout(new GridBagLayout());
        JLabel lblVdbName = new JLabel("VDB Name: ");
        JTextField txfVdbName = new JTextField();
        txfVdbName.setText(this.getVdb().getName());
        JLabel lblVersion = new JLabel("Version: ");
        JTextField txfVersion = new JTextField();
        VirtualDatabaseID vdbID = (VirtualDatabaseID)this.getVdb().getID();
        txfVersion.setText(vdbID.getVersion());
        JLabel lblStatus = new JLabel("Current Status: ");
        String sCurrStatus = this.getVdbManager().getVdbStatusAsString(this.siCurrStatus);
        JLabel lblStatusPhrase = new JLabel(sCurrStatus);
        lblStatusPhrase.setFont(new Font("Dialog", 1, 14));
        txfVdbName.setPreferredSize(new Dimension(263, 21));
        txfVdbName.setMinimumSize(new Dimension(263, 21));
        txfVdbName.setEditable(false);
        txfVersion.setPreferredSize(new Dimension(50, 21));
        txfVersion.setMinimumSize(new Dimension(50, 21));
        txfVersion.setEditable(false);
        this.pnlID.add((Component)lblVdbName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.pnlID.add((Component)txfVdbName, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.pnlID.add((Component)lblVersion, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.pnlID.add((Component)txfVersion, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.pnlID.add((Component)lblStatus, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.pnlID.add((Component)lblStatusPhrase, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.pnlOuter.add((Component)this.pnlID, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(15, 15, 15, 15), 0, 0));
        this.pnlOuter.add((Component)pnlBlather, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(15, 15, 15, 15), 0, 0));
        return this.pnlOuter;
    }
}

