/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.vdb;

import com.metamatrix.console.ui.util.BasicWizardSubpanelContainer;
import com.metamatrix.console.ui.util.WizardInterface;
import com.metamatrix.metadata.runtime.api.VirtualDatabase;
import com.metamatrix.toolbox.ui.widget.CheckBox;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import com.metamatrix.toolbox.ui.widget.TextFieldWidget;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class VdbWizardConfirmPanel
extends BasicWizardSubpanelContainer {
    private String NEED_ENTITLEMENTS_MESSAGE = "\n\nIf Roles are used at your installation, they must be defined for a VDB before applications can use it.";
    private String INCOMPLETE_VDB_MESSAGE = "Please note: Since Connector Bindings were not specified for all of the models, the VDB will have an initial status of Incomplete, until you specify all Bindings.  ";
    private String INACTIVE_VDB_MESSAGE = "Please note: Connector Bindings have been specified for all of the models.  The VDB will have an initial status of Inactive.  ";
    private static final int NOTES_HORIZONTAL_MARGINS = 20;
    private static final int LABELS_HORIZONTAL_MARGINS = 5;
    private TextFieldWidget txfName;
    private JPanel thePanel;
    private JTextArea txaConfirmationMessage;
    private TextFieldWidget txfStatus;
    private CheckBox cbxSetStatusActive;
    private CheckBox cbxSync;
    private String sVdbName = "";
    private short siStatus = 0;
    private VirtualDatabase vdbSourceVdb = null;
    private boolean NEW_VDB = true;
    private boolean NEW_VDB_VERSION = false;
    private boolean bMigrateEntitlementsRequested = false;

    public VdbWizardConfirmPanel(WizardInterface wizardInterface, int stepNum) {
        super(wizardInterface);
        this.NEW_VDB_VERSION = false;
        this.NEW_VDB = true;
        try {
            this.jbInit();
            this.setWizardStuff(stepNum);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public VdbWizardConfirmPanel(VirtualDatabase vdb, WizardInterface wizardInterface, int stepNum) {
        super(wizardInterface);
        this.NEW_VDB_VERSION = true;
        this.NEW_VDB = false;
        this.vdbSourceVdb = vdb;
        try {
            this.jbInit();
            this.setWizardStuff(stepNum);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public VirtualDatabase getSourceVdb() {
        return this.vdbSourceVdb;
    }

    private void setWizardStuff(int stepNum) {
        boolean isLastStep;
        this.setMainContent(this.thePanel);
        int numSteps = this.getWizardInterface().getPageCount();
        boolean bl = isLastStep = stepNum == numSteps - 1;
        if (isLastStep) {
            if (this.NEW_VDB) {
                this.setStepText(stepNum, "Click \"Finish\" to create the new Virtual Database.");
            } else {
                this.setStepText(stepNum, "Click \"Finish\" to create a new version of the Virtual Database " + this.getSourceVdb().getName() + ".");
            }
        } else if (this.NEW_VDB) {
            this.setStepText(stepNum, "Click \"Next\" to create the new Virtual Database.");
        } else {
            this.setStepText(stepNum, "Click \"Next\" to create a new version of the Virtual Database " + this.getSourceVdb().getName() + ".");
        }
    }

    public String getVdbName() {
        return this.sVdbName;
    }

    public short getStatus() {
        if (this.isSelectedSetStatusActive()) {
            return 3;
        }
        return this.siStatus;
    }

    public void setVdbName(String sVdbName) {
        this.sVdbName = sVdbName;
    }

    public void setStatus(short siStatus) {
        this.siStatus = siStatus;
    }

    public void putDataIntoPanel() {
        this.txfName.setText(this.getVdbName());
        String text = "";
        if (this.siStatus == 1) {
            if (this.NEW_VDB) {
                text = this.INCOMPLETE_VDB_MESSAGE + this.NEED_ENTITLEMENTS_MESSAGE;
            } else if (this.NEW_VDB_VERSION) {
                text = this.INCOMPLETE_VDB_MESSAGE;
                if (!this.wasMigrateEntitlementsRequested()) {
                    text = text + this.NEED_ENTITLEMENTS_MESSAGE;
                }
            }
            this.txfStatus.setText("Incomplete");
            this.cbxSetStatusActive.setVisible(false);
            this.cbxSync.setVisible(false);
        } else {
            if (this.NEW_VDB) {
                text = this.INACTIVE_VDB_MESSAGE + this.NEED_ENTITLEMENTS_MESSAGE;
            } else if (this.NEW_VDB_VERSION) {
                text = this.INACTIVE_VDB_MESSAGE;
                if (!this.wasMigrateEntitlementsRequested()) {
                    text = text + this.NEED_ENTITLEMENTS_MESSAGE;
                }
            }
            this.txfStatus.setText("Inactive");
            this.cbxSetStatusActive.setVisible(true);
            this.cbxSync.setVisible(true);
        }
        this.txaConfirmationMessage.setText(text);
    }

    public void setMigrateEntitlementsRequested(boolean b) {
        this.bMigrateEntitlementsRequested = b;
    }

    public boolean wasMigrateEntitlementsRequested() {
        return this.bMigrateEntitlementsRequested;
    }

    private void jbInit() throws Exception {
        this.thePanel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        this.thePanel.setLayout(layout);
        this.txaConfirmationMessage = new JTextArea();
        this.txaConfirmationMessage.setFont(new Font("Dialog", 1, 12));
        this.txaConfirmationMessage.setText("");
        this.txaConfirmationMessage.setLineWrap(true);
        this.txaConfirmationMessage.setWrapStyleWord(true);
        this.txaConfirmationMessage.setEditable(false);
        this.txaConfirmationMessage.setBackground(new JPanel().getBackground());
        this.thePanel.add(this.txaConfirmationMessage);
        layout.setConstraints(this.txaConfirmationMessage, new GridBagConstraints(0, 0, 4, 1, 1.0, 0.0, 10, 2, new Insets(10, 20, 10, 20), 0, 0));
        LabelWidget lblName = new LabelWidget("Name:");
        this.thePanel.add(lblName);
        layout.setConstraints(lblName, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 4, 0), 0, 0));
        this.txfName = new TextFieldWidget();
        this.txfName.setEditable(false);
        this.thePanel.add(this.txfName);
        layout.setConstraints(this.txfName, new GridBagConstraints(1, 1, 3, 1, 0.0, 0.0, 18, 2, new Insets(0, 2, 4, 5), 0, 0));
        LabelWidget lblStatus = new LabelWidget("Status:");
        this.thePanel.add(lblStatus);
        layout.setConstraints(lblStatus, new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 18, 0, new Insets(4, 5, 4, 0), 0, 0));
        this.txfStatus = new TextFieldWidget();
        this.txfStatus.setEditable(false);
        this.txfStatus.setFont(new Font("SansSerif", 1, 12));
        this.thePanel.add(this.txfStatus);
        layout.setConstraints(this.txfStatus, new GridBagConstraints(1, 2, 1, 1, 0.0, 1.0, 11, 0, new Insets(4, 2, 4, 0), 0, 0));
        this.cbxSetStatusActive = new CheckBox("Set Status Active", 1);
        this.thePanel.add(this.cbxSetStatusActive);
        layout.setConstraints(this.cbxSetStatusActive, new GridBagConstraints(2, 2, 1, 1, 0.0, 1.0, 18, 0, new Insets(4, 15, 4, 5), 0, 0));
        this.cbxSync = new CheckBox("Synchronize", 1);
        this.thePanel.add(this.cbxSync);
        layout.setConstraints(this.cbxSync, new GridBagConstraints(3, 2, 1, 1, 1.0, 1.0, 18, 0, new Insets(4, 15, 4, 5), 0, 0));
    }

    public boolean isSelectedSetStatusActive() {
        return this.cbxSetStatusActive.isSelected() && this.cbxSetStatusActive.isVisible();
    }

    public boolean isSyncActive() {
        return this.cbxSync.isSelected() && this.cbxSync.isVisible();
    }
}

