/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.vdb;

import com.metamatrix.common.vdb.api.VDBDefn;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.models.VdbManager;
import com.metamatrix.console.ui.util.BasicWizardSubpanelContainer;
import com.metamatrix.console.ui.util.WizardInterface;
import com.metamatrix.console.ui.views.vdb.ModelWrapper;
import com.metamatrix.console.ui.views.vdb.VdbAssignConnBindPanel;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.metadata.runtime.api.VirtualDatabase;
import com.metamatrix.vdb.runtime.BasicModelInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class VdbWizardEditConnBindPanel
extends BasicWizardSubpanelContainer {
    private static final String USE_VDB_CONNECTOR_BINDINGS = "Use Connector Bindings From Current VDB";
    private static final String USE_MIGRATE_CONNECTOR_BINDINGS = "Migrate Connector Bindings From Previous VDB Version";
    private VdbAssignConnBindPanel vacbConnectorBindingEditPanel;
    private VirtualDatabase vdbSourceVdb = null;
    private boolean newVDBVersion;
    boolean editCBPInitSuccessful = true;
    private JRadioButton vdbBindings = new JRadioButton("Use Connector Bindings From Current VDB");
    private JRadioButton migratedBindings = new JRadioButton("Migrate Connector Bindings From Previous VDB Version", true);
    private ButtonGroup migrateBtnGroup = new ButtonGroup();
    private JPanel pnlOuter = new JPanel();
    private VDBDefn vdbDefn = null;
    private ConnectionInfo connection;
    private int panelOrder;

    public VdbWizardEditConnBindPanel(int step, WizardInterface wizardInterface, ConnectionInfo connection) {
        super(wizardInterface);
        this.panelOrder = step;
        this.connection = connection;
        this.newVDBVersion = false;
        try {
            this.init();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public VdbWizardEditConnBindPanel(int step, VirtualDatabase vdb, WizardInterface wizardInterface, ConnectionInfo connection) {
        super(wizardInterface);
        this.panelOrder = step;
        this.connection = connection;
        this.vdbSourceVdb = vdb;
        this.newVDBVersion = this.vdbSourceVdb != null;
        try {
            this.init();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private VdbManager getVdbManager() {
        return ModelManager.getVdbManager(this.connection);
    }

    private void init() throws Exception {
        this.pnlOuter.setLayout(new BorderLayout());
        this.vacbConnectorBindingEditPanel = new VdbAssignConnBindPanel(this.connection);
        JPanel migratePanel = new JPanel();
        GridBagLayout migrateLayout = new GridBagLayout();
        migrateLayout.setConstraints(this.vdbBindings, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        migrateLayout.setConstraints(this.migratedBindings, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        migratePanel.setLayout(migrateLayout);
        migratePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(1, 0, 1, 0)));
        migratePanel.add(this.vdbBindings);
        migratePanel.add(this.migratedBindings);
        this.migrateBtnGroup.add(this.vdbBindings);
        this.migrateBtnGroup.add(this.migratedBindings);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                VdbWizardEditConnBindPanel.this.runMigrateBindings();
            }
        };
        this.vdbBindings.addActionListener(listener);
        this.migratedBindings.addActionListener(listener);
        this.pnlOuter.add((Component)this.vacbConnectorBindingEditPanel, "Center");
        if (this.newVDBVersion) {
            this.pnlOuter.add((Component)migratePanel, "South");
        }
        this.setMainContent(this.pnlOuter);
        String hdr = "Assign Connector Bindings to the Physical Models.";
        String[] paragraphs = new String[]{"Select a Binding from the table at the left, then select one or more rows in the Model table at the right, then click the Assign button.", "To remove an assignment, select the row in the Model table and click the Unassign button."};
        this.setStepText(this.panelOrder, true, hdr, paragraphs);
    }

    private void runMigrateBindings() {
        this.vacbConnectorBindingEditPanel.switchConnectorBindings(!this.vdbBindings.isSelected());
    }

    void useBindingsFromPreviousVDB() {
        VDBDefn rve = this.getVDB();
        try {
            Map bindings = this.getVdbManager().migrateConnectorBindingNames(this.vdbSourceVdb, rve);
            this.vacbConnectorBindingEditPanel.setMigratedBindings(bindings);
            this.runMigrateBindings();
        }
        catch (Exception e) {
            ExceptionUtility.showMessage("Failed while retrieving the Models to Bindings map", e);
            this.editCBPInitSuccessful = false;
        }
    }

    public boolean getEditCBPInitSuccessful() {
        if (!this.vacbConnectorBindingEditPanel.getVdbACBPSuccessful()) {
            this.editCBPInitSuccessful = false;
        }
        return this.editCBPInitSuccessful;
    }

    public void setVDB(VDBDefn rmcVersionEntry) {
        this.vdbDefn = rmcVersionEntry;
    }

    public void loadAdditionalBindings() {
        if (this.vdbDefn.getConnectorBindings() != null) {
            this.vacbConnectorBindingEditPanel.setVDBVersion(this.vdbDefn);
        }
    }

    public VDBDefn getVDB() {
        return this.vdbDefn;
    }

    public void setModels(Collection colModels) {
        ArrayList<ModelWrapper> arylModelWrappers = new ArrayList<ModelWrapper>();
        Iterator it = colModels.iterator();
        while (it.hasNext()) {
            arylModelWrappers.add(new ModelWrapper((BasicModelInfo)it.next()));
        }
        this.vacbConnectorBindingEditPanel.setModels(arylModelWrappers);
    }

    public void updateMultiSource(Map multiSourceInfo) {
        this.vacbConnectorBindingEditPanel.updateMultiSource(multiSourceInfo);
    }

    public Map getModelsToConnBindsMap() {
        return this.vacbConnectorBindingEditPanel.getModelsToConnectorBindingsMap();
    }

    public void updateSelectionForModelsTable() {
        this.vacbConnectorBindingEditPanel.updateSelectionForModelsTable();
    }

    public boolean hasBindingAssigned(String modelName) {
        Map bindingMap = this.getModelsToConnBindsMap();
        boolean found = false;
        boolean assigned = false;
        Iterator it = bindingMap.entrySet().iterator();
        while (it.hasNext() && !found) {
            Map.Entry me = it.next();
            String thisModel = (String)me.getKey();
            if (!thisModel.equals(modelName)) continue;
            found = true;
            Collection uuids = (Collection)me.getValue();
            Iterator it2 = uuids.iterator();
            while (!assigned && it2.hasNext()) {
                String uuid = (String)it2.next();
                if (uuid == null || (uuid = uuid.trim()).length() <= 0) continue;
                assigned = true;
            }
        }
        return assigned;
    }

    @Override
    public void resolveForwardButton() {
        AbstractButton forwardButton = this.getWizardInterface().getForwardButton();
        forwardButton.setEnabled(true);
    }
}

