/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.vdb;

import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.tree.directory.DirectoryEntry;
import com.metamatrix.common.tree.directory.DirectoryEntryView;
import com.metamatrix.common.tree.directory.FileSystemView;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.ui.util.BasicWizardSubpanelContainer;
import com.metamatrix.console.ui.util.WizardInterface;
import com.metamatrix.console.ui.views.vdb.VdbConnBindPanel;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.metadata.runtime.api.VirtualDatabase;
import com.metamatrix.metadata.runtime.api.VirtualDatabaseID;
import com.metamatrix.platform.admin.api.EntitlementMigrationReport;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.DialogWindow;
import com.metamatrix.toolbox.ui.widget.DirectoryChooserPanel;
import com.metamatrix.toolbox.ui.widget.TextFieldWidget;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class VdbWizardEntitlementsPanel
extends BasicWizardSubpanelContainer
implements ComponentListener {
    String sVdbName = "";
    String sDescription = "";
    VirtualDatabase vdbSourceVdb = null;
    VirtualDatabase vdbNewVdb = null;
    private EntitlementMigrationReport emrEntitlementReport = null;
    GridLayout gridLayout1 = new GridLayout();
    JPanel pnlOuter = new JPanel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    private VdbConnBindPanel pnlConnectorBinding = null;
    private JEditorPane pnlEditor = null;
    private JTabbedPane tpnVdbStuff = new JTabbedPane();
    private JPanel pnlReportOuter = new JPanel();
    private ButtonWidget btnWriteReportToFile = new ButtonWidget("Save to File");
    private JPanel pnlButtons = new JPanel();
    JTextArea txaDescription = new JTextArea();
    JLabel lblDescription = new JLabel();
    TextFieldWidget txfName = new TextFieldWidget();
    JLabel lblName = new JLabel();
    JScrollPane jScrollPane2 = new JScrollPane();
    private ConnectionInfo connection;
    private int iLimit = 200;

    public VdbWizardEntitlementsPanel(VirtualDatabase vdb, WizardInterface wizardInterface, ConnectionInfo connection, int stepNum) {
        super(wizardInterface);
        this.connection = connection;
        this.setSourceVdb(vdb);
        try {
            this.jbInit(stepNum);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.setSourceVdb(vdb);
        if (this.getSourceVdb() != null) {
            this.setVdbName(this.getSourceVdb().getName());
            this.txfName.setText(this.getSourceVdb().getName());
            this.setDescription(this.getSourceVdb().getDescription());
            this.txaDescription.setText(this.getSourceVdb().getDescription());
        }
        this.txfName.setEditable(false);
        this.txaDescription.setLineWrap(true);
        this.txaDescription.setWrapStyleWord(true);
    }

    private VirtualDatabase getSourceVdb() {
        return this.vdbSourceVdb;
    }

    private void setSourceVdb(VirtualDatabase vdb) {
        this.vdbSourceVdb = vdb;
    }

    public void setNewVdb(VirtualDatabase vdb) {
        this.vdbNewVdb = vdb;
        this.pnlConnectorBinding.setVirtualDatabase(this.getNewVdb());
    }

    private VirtualDatabase getNewVdb() {
        return this.vdbNewVdb;
    }

    public void setEntitlementMigrationReport(EntitlementMigrationReport emrEntitlementReport) {
        String sReport = "";
        this.emrEntitlementReport = emrEntitlementReport;
        sReport = this.getEntitlementMigrationReport().getEntries().size() > this.iLimit ? this.createEntitlementMigrationStatsOnlyOutputAsString(this.getEntitlementMigrationReport()) : this.createEntitlementMigrationFullReportOutputAsString(this.getEntitlementMigrationReport());
        this.pnlEditor.setText(sReport);
    }

    public EntitlementMigrationReport getEntitlementMigrationReport() {
        if (this.emrEntitlementReport != null) {
            return this.emrEntitlementReport;
        }
        return this.getEmptyMigrationReport();
    }

    public String getVdbName() {
        this.getDataFromPanel();
        return this.sVdbName;
    }

    public String getDescription() {
        this.getDataFromPanel();
        return this.sDescription;
    }

    public void setVdbName(String sVdbName) {
        this.sVdbName = sVdbName;
    }

    public void setDescription(String sDesc) {
        this.sDescription = sDesc;
    }

    public void getDataFromPanel() {
        this.setVdbName(this.txfName.getText());
        this.setDescription(this.txaDescription.getText());
    }

    public void putDataIntoPanel() {
        this.txfName.setText(this.getVdbName());
        this.txaDescription.setText(this.getDescription());
    }

    public void setupListening() {
        this.txfName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent de) {
                VdbWizardEntitlementsPanel.this.resolveForwardButton();
            }

            @Override
            public void insertUpdate(DocumentEvent de) {
                VdbWizardEntitlementsPanel.this.resolveForwardButton();
            }

            @Override
            public void removeUpdate(DocumentEvent de) {
                VdbWizardEntitlementsPanel.this.resolveForwardButton();
            }
        });
        this.addComponentListener(this);
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.setInitialPostRealizeState();
        this.removeComponentListener(this);
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    public void setInitialPostRealizeState() {
        AbstractButton forwardButton = this.getWizardInterface().getForwardButton();
        forwardButton.setEnabled(true);
        this.txfName.requestFocus();
    }

    @Override
    public void resolveForwardButton() {
        AbstractButton forwardButton = this.getWizardInterface().getForwardButton();
        if (this.txfName.getText().trim().equals("")) {
            forwardButton.setEnabled(false);
        } else {
            forwardButton.setEnabled(true);
        }
    }

    @Override
    public void postRealize() {
        this.txfName.requestFocus();
        AbstractButton forwardButton = this.getWizardInterface().getForwardButton();
        forwardButton.setEnabled(true);
    }

    private void jbInit(int stepNum) throws Exception {
        this.createPanel();
        this.setupListening();
        this.setMainContent(this.pnlOuter);
        this.setStepText(stepNum, "View Roles and/or Connector Binding Migration Results");
    }

    private void createPanel() {
        this.pnlConnectorBinding = new VdbConnBindPanel(this.connection);
        this.pnlConnectorBinding.getEditButton().setVisible(false);
        this.pnlEditor = new JEditorPane();
        this.pnlEditor.setContentType("text/html");
        this.pnlEditor.setEditable(false);
        JScrollPane scpReport = new JScrollPane();
        this.pnlReportOuter.setLayout(new BorderLayout());
        this.pnlReportOuter.add((Component)scpReport, "Center");
        this.pnlButtons.add(this.btnWriteReportToFile);
        this.pnlReportOuter.add((Component)this.pnlButtons, "South");
        this.btnWriteReportToFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                VdbWizardEntitlementsPanel.this.writeToFile();
            }
        });
        Dimension dimButtonSize = this.btnWriteReportToFile.getPreferredSize();
        this.btnWriteReportToFile.setPreferredSize(new Dimension(100, dimButtonSize.height));
        this.tpnVdbStuff.addTab("Role Migration Report", this.pnlReportOuter);
        scpReport.setViewportView(this.pnlEditor);
        scpReport.setPreferredSize(new Dimension(600, 350));
        this.tpnVdbStuff.addTab("Connector Bindings", this.pnlConnectorBinding);
        this.gridLayout1.setVgap(7);
        this.gridLayout1.setRows(2);
        this.gridLayout1.setColumns(1);
        this.gridLayout1.setColumns(1);
        this.pnlOuter.setLayout(new BorderLayout());
        this.pnlOuter.add((Component)this.tpnVdbStuff, "Center");
    }

    private EntitlementMigrationReport getEmptyMigrationReport() {
        String sourceNameVers = null;
        VirtualDatabase srcVdb = this.getSourceVdb();
        if (srcVdb != null) {
            VirtualDatabaseID srcVdbID = (VirtualDatabaseID)srcVdb.getID();
            sourceNameVers = srcVdbID.getName();
        } else {
            sourceNameVers = "source";
        }
        String targetNameVers = null;
        VirtualDatabase tgtVdb = this.getNewVdb();
        if (tgtVdb != null) {
            VirtualDatabaseID tgtVdbID = (VirtualDatabaseID)tgtVdb.getID();
            targetNameVers = tgtVdbID.getName() + " Version " + tgtVdbID.getVersion();
        } else {
            targetNameVers = "targetVDB";
        }
        EntitlementMigrationReport emptyReport = new EntitlementMigrationReport(sourceNameVers, targetNameVers);
        return emptyReport;
    }

    private String createEntitlementMigrationStatsOnlyOutputAsString(EntitlementMigrationReport emr) {
        String SUCCEEDED = "Succeeded";
        String sMigratedStatus = "";
        int iSucceeded = 0;
        int iTotalEntries = emr.getEntries().size();
        for (List lstEntry : emr.getEntries()) {
            sMigratedStatus = (String)lstEntry.get(0);
            if (!sMigratedStatus.trim().equals(SUCCEEDED)) continue;
            ++iSucceeded;
        }
        StringBuffer sbReport = new StringBuffer(128);
        String sTitleFontSizeStandalone = "<FONT size= +1>";
        String sSubtitleFontSizeStandalone = "<FONT size= +0>";
        String sSmallFontSizeStandalone = "<FONT size= -1>";
        String sEndFont = "</FONT>";
        StringBuffer sbHead = new StringBuffer("<html> <head> </head> <body>");
        sbHead.append("<DIV ALIGN=CENTER>");
        sbHead.append(sTitleFontSizeStandalone);
        sbHead.append("Roles Migration Report<br>");
        sbHead.append(sEndFont);
        sbHead.append(sSubtitleFontSizeStandalone);
        sbHead.append("Source VDB: ");
        sbHead.append(emr.getSourceVDBID());
        sbHead.append("&nbsp&nbsp&nbsp&nbsp");
        sbHead.append(" Target VDB: ");
        sbHead.append(emr.getTargetVDBID());
        sbHead.append("<br>");
        sbHead.append(" <table> ");
        sbHead.append("<th>");
        sbHead.append(sSmallFontSizeStandalone);
        sbHead.append("Succeeded");
        sbHead.append(sEndFont);
        sbHead.append("</th>");
        sbHead.append("<th>");
        sbHead.append(sSmallFontSizeStandalone);
        sbHead.append("Failed");
        sbHead.append(sEndFont);
        sbHead.append("</th>");
        sbHead.append("<th>");
        sbHead.append(sSmallFontSizeStandalone);
        sbHead.append("Total");
        sbHead.append(sEndFont);
        sbHead.append("</th>");
        StringBuffer sbRow = new StringBuffer();
        sbRow.append("<tr>");
        sbRow.append("<td ");
        sbRow.append("ALIGN='CENTER'");
        sbRow.append(" >");
        sbRow.append(sSmallFontSizeStandalone);
        sbRow.append(iSucceeded);
        sbRow.append(sEndFont);
        sbRow.append("</td>");
        sbRow.append("<td ");
        sbRow.append("ALIGN='CENTER'");
        sbRow.append(" >");
        sbRow.append(sSmallFontSizeStandalone);
        sbRow.append(iTotalEntries - iSucceeded);
        sbRow.append(sEndFont);
        sbRow.append("</td>");
        sbRow.append("<td ");
        sbRow.append("ALIGN='CENTER'");
        sbRow.append(" >");
        sbRow.append(sSmallFontSizeStandalone);
        sbRow.append(iTotalEntries);
        sbRow.append(sEndFont);
        sbRow.append("</td>");
        sbRow.append("</tr>");
        sbHead.append(sbRow);
        sbRow.delete(0, sbRow.length());
        sbRow.append("<tr>");
        sbRow.append("<td colspan='3'");
        sbRow.append("ALIGN='CENTER'");
        sbRow.append(" >");
        sbRow.append(sSmallFontSizeStandalone);
        sbRow.append("<i>To see details, click Save to File and review the file.</i>");
        sbRow.append(sEndFont);
        sbRow.append("</td>");
        sbRow.append("</tr>");
        sbHead.append(sbRow);
        sbHead.append(" </table> ");
        sbReport.append(sbHead);
        StringBuffer sbTail = new StringBuffer("</body> </html>");
        sbReport.append(sbTail);
        return sbReport.toString();
    }

    private String createEntitlementMigrationFullReportOutputAsString(EntitlementMigrationReport emr) {
        StringBuffer sbReport = new StringBuffer(4096);
        String sTitleFontSizeStandalone = "<FONT size= +1>";
        String sSubtitleFontSizeStandalone = "<FONT size= +0>";
        String sSmallFontSizeStandalone = "<FONT size= -1>";
        String sEndFont = "</FONT>";
        StringBuffer sbHead = new StringBuffer("<html> <head> </head> <body>");
        sbHead.append("<DIV ALIGN=CENTER>");
        sbHead.append(sTitleFontSizeStandalone);
        sbHead.append("Roles Migration Report<br>");
        sbHead.append(sEndFont);
        sbHead.append(sSubtitleFontSizeStandalone);
        sbHead.append("Source VDB: ");
        sbHead.append(emr.getSourceVDBID());
        sbHead.append("&nbsp&nbsp&nbsp&nbsp");
        sbHead.append(" Target VDB: ");
        sbHead.append(emr.getTargetVDBID());
        sbHead.append(sEndFont);
        sbHead.append("</DIV>");
        sbHead.append(" <table> ");
        sbHead.append("<th>");
        sbHead.append(sSmallFontSizeStandalone);
        sbHead.append("Migrated");
        sbHead.append(sEndFont);
        sbHead.append("</th>");
        sbHead.append("<th>");
        sbHead.append(sSmallFontSizeStandalone);
        sbHead.append("Resource");
        sbHead.append(sEndFont);
        sbHead.append("</th>");
        sbHead.append("<th>");
        sbHead.append(sSmallFontSizeStandalone);
        sbHead.append("Source Policy ID");
        sbHead.append(sEndFont);
        sbHead.append("</th>");
        sbHead.append("<th>");
        sbHead.append(sSmallFontSizeStandalone);
        sbHead.append("Target Policy ID");
        sbHead.append(sEndFont);
        sbHead.append("</th>");
        sbHead.append("<th>");
        sbHead.append(sSmallFontSizeStandalone);
        sbHead.append("Actions");
        sbHead.append(sEndFont);
        sbHead.append("</th>");
        sbHead.append("<th>");
        sbHead.append(sSmallFontSizeStandalone);
        sbHead.append("Reason");
        sbHead.append(sEndFont);
        sbHead.append("</th>");
        StringBuffer sbTail = new StringBuffer("</table>");
        sbTail.append(sEndFont);
        sbTail.append(" + </body> </html>");
        sbReport.append(sbHead);
        StringBuffer sbRow = new StringBuffer(1024);
        Iterator it = emr.getEntries().iterator();
        while (it.hasNext()) {
            sbRow.delete(0, sbRow.length());
            List lstEntry = (List)it.next();
            sbRow.append("<tr  >");
            sbRow.append("<td ");
            sbRow.append("ALIGN='CENTER'");
            sbRow.append(" >");
            sbRow.append(sSmallFontSizeStandalone);
            sbRow.append(lstEntry.get(0));
            sbRow.append(sEndFont);
            sbRow.append("</td>");
            sbRow.append("<td ");
            sbRow.append("ALIGN='LEFT'");
            sbRow.append(" >");
            sbRow.append(sSmallFontSizeStandalone);
            sbRow.append(lstEntry.get(1));
            sbRow.append(sEndFont);
            sbRow.append("</td>");
            sbRow.append("<td ");
            sbRow.append("ALIGN='CENTER'");
            sbRow.append(" >");
            sbRow.append(sSmallFontSizeStandalone);
            sbRow.append(lstEntry.get(2));
            sbRow.append(sEndFont);
            sbRow.append("</td>");
            sbRow.append("<td ");
            sbRow.append("ALIGN='CENTER'");
            sbRow.append(" >");
            sbRow.append(sSmallFontSizeStandalone);
            sbRow.append(lstEntry.get(3));
            sbRow.append(sEndFont);
            sbRow.append("</td>");
            sbRow.append("<td ");
            sbRow.append("ALIGN='LEFT'");
            sbRow.append(" >");
            sbRow.append(sSmallFontSizeStandalone);
            sbRow.append(lstEntry.get(4));
            sbRow.append(sEndFont);
            sbRow.append("</td>");
            sbRow.append("<td ");
            sbRow.append("ALIGN='LEFT'");
            sbRow.append(" >");
            sbRow.append(sSmallFontSizeStandalone);
            sbRow.append(lstEntry.get(5));
            sbRow.append(sEndFont);
            sbRow.append("</td>");
            sbRow.append("</tr>");
            sbReport.append(sbRow);
        }
        sbReport.append(sbTail);
        return sbReport.toString();
    }

    private void writeToFile() {
        DirectoryChooserPanel pnlChooser = new DirectoryChooserPanel((DirectoryEntryView)new FileSystemView(), 1);
        pnlChooser.setAcceptButtonLabel("Save");
        DialogWindow.show(this, "Save Roles Migration Report", pnlChooser);
        if (pnlChooser.getSelectedButton() == pnlChooser.getAcceptButton()) {
            DirectoryEntry result = (DirectoryEntry)pnlChooser.getSelectedTreeNode();
            try {
                this.getEntitlementMigrationReport().writeReport(result.getNamespace());
            }
            catch (Exception theException) {
                theException.printStackTrace();
                ExceptionUtility.showMessage(theException.getMessage(), theException);
                LogManager.logError((String)"SYSTEMLOGGING", (Throwable)theException, (String)(this.getClass() + ":writeFile"));
            }
        }
    }
}

