/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.vdb;

import com.metamatrix.common.log.LogManager;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.VdbManager;
import com.metamatrix.console.ui.util.BasicWizardSubpanelContainer;
import com.metamatrix.console.ui.util.WizardInterface;
import com.metamatrix.metadata.runtime.api.VirtualDatabase;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.CheckBox;
import com.metamatrix.toolbox.ui.widget.TextFieldWidget;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;

public class VdbWizardEntitlementsSelectPanel
extends BasicWizardSubpanelContainer {
    private JPanel pnlOuter = new JPanel();
    private ButtonWidget btnBack = new ButtonWidget();
    private JPanel pnlBlather = new JPanel();
    private BorderLayout borderLayout1 = new BorderLayout();
    private BorderLayout borderLayout2 = new BorderLayout();
    private BorderLayout borderLayout4 = new BorderLayout();
    private JPanel pnlWorkSpace = new JPanel();
    private ButtonWidget btnCancel = new ButtonWidget();
    private JLabel lblBlather = new JLabel();
    private JPanel pnlButtons = new JPanel();
    private GridLayout gridLayout1 = new GridLayout();
    private JPanel pnlRealButtons = new JPanel();
    private Border border1;
    private Border border3;
    private TextFieldWidget txvVersion = new TextFieldWidget();
    private JLabel lblVersion = new JLabel();
    private TextFieldWidget txfName = new TextFieldWidget();
    private JLabel lblName = new JLabel();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JPanel pnlWorkspaceOuter = new JPanel();
    private BorderLayout borderLayout3 = new BorderLayout();
    private JTextArea txaConfirmationMessage = new JTextArea();
    private Border border5;
    private TextFieldWidget txfStatus = new TextFieldWidget();
    private JLabel lblStatus = new JLabel();
    private Border border6;
    private String sVdbName = "";
    private short siStatus = 0;
    private AbstractButton radioNoRolesImport = new JRadioButton(" Do not Import or Migrate Roles");
    private AbstractButton radioImportVdbRoles = new JRadioButton(" Import Role Definitions contained in the VDB");
    private AbstractButton radioMigrateVdbRoles = new JRadioButton(" Migrate Roles from the previous VDB version");
    private CheckBox cbxViewVdbRolesReport = new CheckBox(" View Incoming Roles Report", 0);
    private String INCOMPLETE_VDB_MESSAGE = "Please note: Since Connector Bindings were not specified for all of the models, the VDB will have an initial status of Incomplete, until you specify all Bindings.  ";
    private String INACTIVE_VDB_MESSAGE = "Please note: Connector Bindings have been specified for all of the models.  The VDB will have an initial status of Inactive.  ";
    private String ROLE_IMPORT_MESSAGE = "\n\nPlease select the desired role import option.  \n\nIf roles are used at your installation, they must be defined for a VDB before applications can use it.";
    private String ROLE_IMPORT_OR_MIGRATE_MESSAGE = "\n\nPlease select the desired role import or migration option.  \n\nIf roles are used at your installation, they must be defined for a VDB before applications can use it.";
    private String NO_ROLES_AVAILABLE_TEXT = "No roles are available for import.";
    VirtualDatabase vdbSourceVdb = null;
    boolean showMigrationOption = false;
    boolean roleImportOnly = false;
    boolean showVdbRolesImportOption = false;

    public VdbWizardEntitlementsSelectPanel(WizardInterface wizardInterface, int stepNum) {
        super(wizardInterface);
        this.showMigrationOption = false;
        this.showVdbRolesImportOption = true;
        try {
            this.jbInit();
            this.setWizardStuff(stepNum);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public VdbWizardEntitlementsSelectPanel(VirtualDatabase vdb, ConnectionInfo connection, WizardInterface wizardInterface, int stepNum) {
        super(wizardInterface);
        this.showMigrationOption = true;
        this.vdbSourceVdb = vdb;
        VdbManager vdbManager = new VdbManager(connection);
        try {
            this.showVdbRolesImportOption = vdbManager.vdbHasDataRoles(this.vdbSourceVdb.getVirtualDatabaseID());
        }
        catch (Exception e1) {
            String msg = "Error getting VDB dataroles status";
            LogManager.logError((String)"ROLES", (Throwable)e1, (String)msg);
        }
        try {
            this.jbInit();
            this.setWizardStuff(stepNum);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public VdbWizardEntitlementsSelectPanel(VirtualDatabase vdb, ConnectionInfo connection, WizardInterface wizardInterface, int stepNum, boolean showRolesImportOption) {
        super(wizardInterface);
        this.showMigrationOption = true;
        this.vdbSourceVdb = vdb;
        this.showVdbRolesImportOption = showRolesImportOption;
        try {
            this.jbInit();
            this.setWizardStuff(stepNum);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public VirtualDatabase getSourceVdb() {
        return this.vdbSourceVdb;
    }

    private void setWizardStuff(int stepNum) {
        this.setMainContent(this.pnlWorkspaceOuter);
        this.setStepText(stepNum, true, "Select the desired Role import or migration option.", null);
    }

    public String getVdbName() {
        return this.sVdbName;
    }

    public short getStatus() {
        return this.siStatus;
    }

    public void setVdbName(String sVdbName) {
        this.sVdbName = sVdbName;
    }

    public void setStatus(short siStatus) {
        this.siStatus = siStatus;
    }

    public void putDataIntoPanel() {
        this.txfName.setText(this.getVdbName());
        short siStatus = this.getStatus();
        StringBuffer messageBuffer = new StringBuffer();
        if (siStatus == 1) {
            messageBuffer.append(this.INCOMPLETE_VDB_MESSAGE);
            this.txfStatus.setText("Incomplete");
        } else {
            messageBuffer.append(this.INACTIVE_VDB_MESSAGE);
            this.txfStatus.setText("Inactive");
        }
        if (this.showMigrationOption) {
            messageBuffer.append(this.ROLE_IMPORT_OR_MIGRATE_MESSAGE);
        } else {
            messageBuffer.append(this.ROLE_IMPORT_MESSAGE);
        }
        this.txaConfirmationMessage.setText(messageBuffer.toString());
    }

    public boolean isSelectedNoEntitlementsImport() {
        return this.radioNoRolesImport.isSelected();
    }

    public boolean isSelectedImportEntitlementsFromVdb() {
        return this.radioImportVdbRoles.isSelected();
    }

    public boolean isSelectedMigrateEntitlements() {
        return this.radioMigrateVdbRoles.isSelected();
    }

    public boolean isSelectedViewEntitlementsReport() {
        return this.cbxViewVdbRolesReport.isSelected();
    }

    public void processMigrateEntitlementsCheckBoxAction() {
        if (this.isSelectedMigrateEntitlements() || this.isSelectedImportEntitlementsFromVdb()) {
            this.cbxViewVdbRolesReport.setEnabled(true);
        } else {
            if (this.cbxViewVdbRolesReport.isSelected()) {
                this.cbxViewVdbRolesReport.doClick();
            }
            this.cbxViewVdbRolesReport.setEnabled(false);
        }
    }

    public CheckBox getViewEntitlementsReportCbx() {
        return this.cbxViewVdbRolesReport;
    }

    private void jbInit() throws Exception {
        this.border1 = new EmptyBorder(10, 10, 10, 10);
        this.border1 = new EmptyBorder(10, 10, 10, 10);
        this.border3 = new EmptyBorder(35, 10, 35, 10);
        this.border5 = new EmptyBorder(10, 10, 10, 10);
        this.border6 = new EmptyBorder(10, 10, 10, 10);
        this.pnlOuter.setLayout(this.borderLayout2);
        this.btnBack.setText("< Back");
        this.pnlBlather.setLayout(this.borderLayout1);
        this.borderLayout2.setVgap(5);
        this.pnlWorkSpace.setLayout(this.gridBagLayout1);
        this.btnCancel.setFont(new Font("Dialog", 1, 12));
        this.btnCancel.setText("Finish");
        this.lblBlather.setFont(new Font("Dialog", 1, 12));
        this.lblBlather.setBorder(this.border1);
        this.lblBlather.setText("Step 4: Click Finish to create this new Virtual Database");
        this.pnlButtons.setLayout(this.borderLayout4);
        this.gridLayout1.setColumns(3);
        this.gridLayout1.setHgap(50);
        this.pnlRealButtons.setLayout(this.gridLayout1);
        this.pnlWorkSpace.setBorder(this.border3);
        this.lblVersion.setHorizontalAlignment(4);
        this.lblVersion.setText("Version: ");
        this.lblName.setHorizontalAlignment(4);
        this.lblName.setText("Name:  ");
        this.txvVersion.setText("1  ");
        this.txvVersion.setColumns(3);
        if (this.getSourceVdb() != null) {
            this.txfName.setText(this.getSourceVdb().getName());
        }
        this.pnlWorkspaceOuter.setLayout(this.borderLayout3);
        this.txaConfirmationMessage.setBorder(this.border5);
        this.txaConfirmationMessage.setFont(new Font("Dialog", 1, 12));
        this.txaConfirmationMessage.setText("");
        this.txaConfirmationMessage.setLineWrap(true);
        this.txaConfirmationMessage.setWrapStyleWord(true);
        this.txaConfirmationMessage.setEditable(false);
        this.txaConfirmationMessage.setBackground(new JPanel().getBackground());
        this.txfStatus.setColumns(3);
        this.txfStatus.setText("Incomplete");
        this.txfStatus.setFont(new Font("SansSerif", 1, 12));
        this.lblStatus.setText("Status: ");
        this.lblStatus.setHorizontalAlignment(4);
        this.pnlButtons.setBorder(this.border6);
        this.txfName.setEditable(false);
        this.txfStatus.setEditable(false);
        this.txvVersion.setEditable(false);
        this.pnlRealButtons.add((Component)this.btnBack, null);
        this.pnlRealButtons.add((Component)this.btnCancel, null);
        this.pnlWorkspaceOuter.add((Component)this.pnlWorkSpace, "Center");
        this.cbxViewVdbRolesReport.setEnabled(true);
        this.radioNoRolesImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (VdbWizardEntitlementsSelectPanel.this.radioNoRolesImport.isSelected()) {
                    VdbWizardEntitlementsSelectPanel.this.processMigrateEntitlementsCheckBoxAction();
                }
            }
        });
        this.radioImportVdbRoles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (VdbWizardEntitlementsSelectPanel.this.radioImportVdbRoles.isSelected()) {
                    VdbWizardEntitlementsSelectPanel.this.processMigrateEntitlementsCheckBoxAction();
                }
            }
        });
        this.radioMigrateVdbRoles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (VdbWizardEntitlementsSelectPanel.this.radioMigrateVdbRoles.isSelected()) {
                    VdbWizardEntitlementsSelectPanel.this.processMigrateEntitlementsCheckBoxAction();
                }
            }
        });
        GridLayout gridLayout1 = new GridLayout();
        JPanel pnlRadios = new JPanel(gridLayout1);
        pnlRadios.setBorder(new EtchedBorder(1));
        gridLayout1.setVgap(7);
        gridLayout1.setRows(4);
        gridLayout1.setColumns(1);
        ButtonGroup group = new ButtonGroup();
        group.add(this.radioNoRolesImport);
        if (this.showVdbRolesImportOption) {
            group.add(this.radioImportVdbRoles);
        }
        if (this.showMigrationOption) {
            group.add(this.radioMigrateVdbRoles);
        }
        if (this.showVdbRolesImportOption) {
            this.radioImportVdbRoles.setSelected(true);
        } else if (this.showMigrationOption) {
            this.radioMigrateVdbRoles.setSelected(true);
        } else {
            this.radioNoRolesImport.setSelected(true);
        }
        JPanel viewRolesRptPanel = new JPanel();
        JLabel dummyLabel = new JLabel(" ");
        viewRolesRptPanel.add(dummyLabel);
        viewRolesRptPanel.add(this.cbxViewVdbRolesReport);
        pnlRadios.add(this.radioNoRolesImport);
        if (!this.showVdbRolesImportOption && !this.showMigrationOption) {
            pnlRadios.add(new JLabel(this.NO_ROLES_AVAILABLE_TEXT));
        }
        if (this.showVdbRolesImportOption) {
            pnlRadios.add(this.radioImportVdbRoles);
        }
        if (this.showMigrationOption) {
            pnlRadios.add(this.radioMigrateVdbRoles);
        }
        if (this.showVdbRolesImportOption || this.showMigrationOption) {
            pnlRadios.add(viewRolesRptPanel);
        }
        this.pnlWorkSpace.add((Component)this.txaConfirmationMessage, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.pnlWorkSpace.add((Component)this.lblName, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 0), 49, 4));
        this.pnlWorkSpace.add((Component)this.txfName, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 1), 177, 0));
        this.pnlWorkSpace.add((Component)pnlRadios, new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 5, 0), 0, 0));
        int iFinalYCoordinate = 3;
        this.pnlWorkSpace.add((Component)new JPanel(), new GridBagConstraints(0, iFinalYCoordinate, 0, 0, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void setShowVdbRolesImportOptionEnabled(boolean showOption) {
        this.showVdbRolesImportOption = showOption;
        if (showOption) {
            this.radioImportVdbRoles.setText(" Import Role Definitions contained in the VDB");
            this.cbxViewVdbRolesReport.setEnabled(true);
        } else {
            this.radioImportVdbRoles.setText(" Import Role Definitions contained in the VDB [None available]");
            if (this.showMigrationOption || this.showVdbRolesImportOption) {
                this.cbxViewVdbRolesReport.setEnabled(true);
            } else {
                this.cbxViewVdbRolesReport.setEnabled(false);
            }
        }
        this.radioImportVdbRoles.setEnabled(showOption);
        if (showOption) {
            this.radioImportVdbRoles.setSelected(true);
        } else if (this.showMigrationOption) {
            this.radioMigrateVdbRoles.setSelected(true);
        } else {
            this.radioNoRolesImport.setSelected(true);
        }
    }
}

