/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.vdb;

import com.metamatrix.console.ui.util.BasicWizardSubpanelContainer;
import com.metamatrix.console.ui.util.WizardInterface;
import com.metamatrix.console.ui.util.property.GuiComponentFactory;
import com.metamatrix.console.ui.util.property.TypeConstants;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.metadata.runtime.api.VirtualDatabase;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import com.metamatrix.toolbox.ui.widget.TextFieldWidget;
import com.metamatrix.toolbox.ui.widget.text.DefaultTextFieldModel;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class VdbWizardIdPanel
extends BasicWizardSubpanelContainer
implements TypeConstants {
    String sVdbName = "";
    String sDescription = "";
    private int TEXTAREA_MAXLENGTH = 255;
    VirtualDatabase vdbSourceVdb = null;
    boolean NEW_VDB = true;
    boolean NEW_VDB_VERSION = false;
    boolean idInitSuccessful = true;
    private String sAllowedCharacters = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_";
    JPanel pnlOuter = new JPanel();
    DefaultTextFieldModel dtfmTextModel = new DefaultTextFieldModel();
    JTextArea txaDescription = new JTextArea(this.dtfmTextModel);
    LabelWidget lblDescription = new LabelWidget();
    TextFieldWidget txfName = GuiComponentFactory.createTextField("vdbname");
    LabelWidget lblName = new LabelWidget();
    private int panelOrder;
    private static final String FINDC = ".";

    public VdbWizardIdPanel(int step, VirtualDatabase vdb, WizardInterface wizardInterface) {
        super(wizardInterface);
        this.panelOrder = step;
        this.NEW_VDB_VERSION = true;
        this.NEW_VDB = false;
        this.setSourceVdb(vdb);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.setSourceVdb(vdb);
        this.sVdbName = this.getSourceVdb().getName();
        this.txfName.setEditable(false);
        this.setDescription(this.getSourceVdb().getDescription());
        this.putDataIntoPanel();
    }

    public VdbWizardIdPanel(int step, WizardInterface wizardInterface) {
        super(wizardInterface);
        this.NEW_VDB_VERSION = false;
        this.NEW_VDB = true;
        this.panelOrder = step;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.enableForwardButton(false);
        this.txfName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent ev) {
                VdbWizardIdPanel.this.checkNextButtonEnabling();
            }

            @Override
            public void insertUpdate(DocumentEvent ev) {
                VdbWizardIdPanel.this.checkNextButtonEnabling();
            }

            @Override
            public void removeUpdate(DocumentEvent ev) {
                VdbWizardIdPanel.this.checkNextButtonEnabling();
            }
        });
        this.getWizardInterface().getForwardButton().setEnabled(this.sVdbName.trim().length() > 0);
    }

    private VirtualDatabase getSourceVdb() {
        return this.vdbSourceVdb;
    }

    private void setSourceVdb(VirtualDatabase vdb) {
        this.vdbSourceVdb = vdb;
    }

    public String getVdbName() {
        return this.sVdbName;
    }

    public String getDescription() {
        return this.sDescription;
    }

    public void setVdbName(String svdbName) {
        if (this.NEW_VDB_VERSION) {
            return;
        }
        if (svdbName.indexOf(FINDC) > 0) {
            int l = svdbName.indexOf(FINDC);
            this.sVdbName = svdbName.substring(0, l);
        } else {
            this.sVdbName = svdbName;
        }
    }

    public void setDescription(String sDesc) {
        this.sDescription = sDesc;
    }

    public void getDataFromPanel() {
        this.sVdbName = this.getTextValue();
        this.sDescription = this.txaDescription.getText();
    }

    public void putDataIntoPanel() {
        this.txfName.setText(this.sVdbName);
        this.txaDescription.setText(this.sDescription);
        this.checkNextButtonEnabling();
    }

    private void checkNextButtonEnabling() {
        String nameText = this.getTextValue();
        this.getWizardInterface().getForwardButton().setEnabled(nameText.trim().length() > 0);
    }

    private String getTextValue() {
        return this.txfName.getText();
    }

    @Override
    public void postRealize() {
        this.txfName.requestFocus();
    }

    private void jbInit() throws Exception {
        this.dtfmTextModel.setMaximumLength(this.TEXTAREA_MAXLENGTH);
        this.createPanel();
        this.setMainContent(this.pnlOuter);
        if (this.NEW_VDB) {
            this.setStepText(this.panelOrder, "Specify a name and a description for this Virtual Database.");
        } else if (this.NEW_VDB_VERSION) {
            this.setStepText(this.panelOrder, true, "Modify the description for this new version of a Virtual Database.", null);
        }
    }

    public boolean getIdInitSuccessful() {
        return this.idInitSuccessful;
    }

    private void createPanel() {
        GridBagLayout layout = new GridBagLayout();
        this.pnlOuter.setLayout(layout);
        this.txaDescription.setText("");
        this.txaDescription.setColumns(30);
        this.txaDescription.setRows(4);
        this.txaDescription.setLineWrap(true);
        this.txaDescription.setWrapStyleWord(true);
        this.txaDescription.setPreferredSize(new Dimension(450, 100));
        this.txaDescription.setMinimumSize(new Dimension(250, 100));
        try {
            this.txfName.setValidCharacters(this.sAllowedCharacters);
        }
        catch (Exception e) {
            ExceptionUtility.showMessage("Failed setting VDB Name field", e);
            this.idInitSuccessful = false;
        }
        this.lblDescription.setText("Description:");
        this.txfName.setText("");
        this.lblName.setText("*Name:");
        this.setBoldFont(this.lblName);
        LabelWidget requiredFieldLabel = new LabelWidget("*Required field");
        this.setBoldFont(requiredFieldLabel);
        this.pnlOuter.add(this.lblName);
        this.pnlOuter.add(this.txfName);
        this.pnlOuter.add(this.lblDescription);
        this.pnlOuter.add(this.txaDescription);
        this.pnlOuter.add(requiredFieldLabel);
        layout.setConstraints(this.lblName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        layout.setConstraints(this.txfName, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        layout.setConstraints(this.lblDescription, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        layout.setConstraints(this.txaDescription, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        layout.setConstraints(requiredFieldLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 12, 0, new Insets(15, 5, 5, 5), 0, 0));
    }

    private void setBoldFont(LabelWidget label) {
        Font tempFont = label.getFont();
        Font newFont = new Font(tempFont.getName(), 1, tempFont.getSize());
        label.setFont(newFont);
    }
}

