/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.vdb;

import com.metamatrix.common.tree.TreeNode;
import com.metamatrix.common.tree.directory.DirectoryEntryView;
import com.metamatrix.common.tree.directory.FileSystemView;
import com.metamatrix.console.ConsolePlugin;
import com.metamatrix.console.ui.util.BasicWizardSubpanelContainer;
import com.metamatrix.console.ui.util.WizardInterface;
import com.metamatrix.toolbox.ui.widget.DirectoryChooserPanel;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;

public class VdbWizardSaveMaterializationFilesPanel
extends BasicWizardSubpanelContainer {
    private static final String TITLE = ConsolePlugin.Util.getString("VdbWizardSaveMaterializationFilesPanel.title");
    private static final String FILES_DESC = ConsolePlugin.Util.getString("VdbWizardSaveMaterializationFilesPanel.filesDesc");
    private static final String CONNECTION_PROPERTIES_FILE = ConsolePlugin.Util.getString("VdbWizardSaveMaterializationFilesPanel.connectionPropertiesFile");
    private static final String CREATE_SCRIPT_FILE = ConsolePlugin.Util.getString("VdbWizardSaveMaterializationFilesPanel.createScriptFile");
    private static final String LOAD_SCRIPT_FILE = ConsolePlugin.Util.getString("VdbWizardSaveMaterializationFilesPanel.loadScriptFile");
    private static final String SWAP_SCRIPT_FILE = ConsolePlugin.Util.getString("VdbWizardSaveMaterializationFilesPanel.swapScriptFile");
    private static final String TRUNCATE_SCRIPT_FILE = ConsolePlugin.Util.getString("VdbWizardSaveMaterializationFilesPanel.truncateScriptFile");
    private static final int FILE_TYPES_INSET = 40;
    private static final int FILE_NAMES_INSET = 20;
    private DirectoryChooserPanel chooser;
    private JLabel connectionPropsLabel;
    private JLabel createScriptLabel;
    private JLabel loadScriptLabel;
    private JLabel swapScriptLabel;
    private JLabel truncateScriptLabel;
    private JLabel connectionPropsFile;
    private JLabel createScriptFile;
    private JLabel loadScriptFile;
    private JLabel swapScriptFile;
    private JLabel truncateScriptFile;

    public VdbWizardSaveMaterializationFilesPanel(WizardInterface wizardInterface, int stepNum, String initialDirectory) {
        super(wizardInterface);
        super.setStepText(stepNum, TITLE);
        JPanel thePanel = this.createPanel(initialDirectory);
        super.setMainContent(thePanel);
    }

    private JPanel createPanel(String initialDirectory) {
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        panel.setLayout(layout);
        JPanel filesPanel = new JPanel();
        filesPanel.setBorder(new TitledBorder(FILES_DESC));
        panel.add(filesPanel);
        layout.setConstraints(filesPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        GridBagLayout filesLayout = new GridBagLayout();
        filesPanel.setLayout(filesLayout);
        this.connectionPropsLabel = new LabelWidget(CONNECTION_PROPERTIES_FILE);
        filesPanel.add(this.connectionPropsLabel);
        filesLayout.setConstraints(this.connectionPropsLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 40, 0, 0), 0, 0));
        this.connectionPropsFile = new LabelWidget();
        filesPanel.add(this.connectionPropsFile);
        filesLayout.setConstraints(this.connectionPropsFile, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 20, 0, 0), 0, 0));
        this.createScriptLabel = new LabelWidget(CREATE_SCRIPT_FILE);
        filesPanel.add(this.createScriptLabel);
        filesLayout.setConstraints(this.createScriptLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 40, 0, 0), 0, 0));
        this.createScriptFile = new LabelWidget();
        filesPanel.add(this.createScriptFile);
        filesLayout.setConstraints(this.createScriptFile, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 0), 0, 0));
        this.loadScriptLabel = new LabelWidget(LOAD_SCRIPT_FILE);
        filesPanel.add(this.loadScriptLabel);
        filesLayout.setConstraints(this.loadScriptLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 40, 0, 0), 0, 0));
        this.loadScriptFile = new LabelWidget();
        filesPanel.add(this.loadScriptFile);
        filesLayout.setConstraints(this.loadScriptFile, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 0), 0, 0));
        this.swapScriptLabel = new LabelWidget(SWAP_SCRIPT_FILE);
        filesPanel.add(this.swapScriptLabel);
        filesLayout.setConstraints(this.swapScriptLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 40, 0, 0), 0, 0));
        this.swapScriptFile = new LabelWidget();
        filesPanel.add(this.swapScriptFile);
        filesLayout.setConstraints(this.swapScriptFile, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 0), 0, 0));
        this.truncateScriptLabel = new LabelWidget(TRUNCATE_SCRIPT_FILE);
        filesPanel.add(this.truncateScriptLabel);
        filesLayout.setConstraints(this.truncateScriptLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 40, 4, 0), 0, 0));
        this.truncateScriptFile = new LabelWidget();
        filesPanel.add(this.truncateScriptFile);
        filesLayout.setConstraints(this.truncateScriptFile, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 4, 0), 0, 0));
        FileSystemView fileSystemView = new FileSystemView();
        if (initialDirectory != null && initialDirectory.length() > 0) {
            try {
                fileSystemView.setHome((TreeNode)fileSystemView.lookup(initialDirectory));
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        this.chooser = new DirectoryChooserPanel((DirectoryEntryView)fileSystemView, 1);
        this.chooser.setShowAcceptButton(false);
        this.chooser.setShowCancelButton(false);
        this.chooser.setShowDetailsButton(false);
        this.chooser.setShowFilterComboBox(false);
        this.chooser.setShowNewFolderButton(true);
        this.chooser.setFileNameFieldVisible(false);
        this.chooser.setShowPassThruFilter(false);
        this.chooser.setFilenameSelectionAllowed(false);
        this.chooser.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ev) {
                JTextComponent textField = (JTextComponent)ev.getSource();
                String textEntered = textField.getText().trim();
                VdbWizardSaveMaterializationFilesPanel.this.chooserStateChanged(textEntered);
            }
        });
        panel.add(this.chooser);
        layout.setConstraints(this.chooser, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
        return panel;
    }

    public void setConnectionPropsFileName(String name) {
        this.connectionPropsFile.setText(name);
        this.connectionPropsLabel.setText(this.connectionPropsLabel.getText() + ':');
    }

    public void setCreateScriptFileName(String name) {
        this.createScriptFile.setText(name);
        this.createScriptLabel.setText(this.createScriptLabel.getText() + ':');
    }

    public void setLoadScriptFileName(String name) {
        this.loadScriptFile.setText(name);
        this.loadScriptLabel.setText(this.loadScriptLabel.getText() + ':');
    }

    public void setSwapScriptFileName(String name) {
        this.swapScriptFile.setText(name);
        this.swapScriptLabel.setText(this.swapScriptLabel.getText() + ':');
    }

    public void setTruncateScriptFileName(String name) {
        this.truncateScriptFile.setText(name);
        this.truncateScriptLabel.setText(this.truncateScriptLabel.getText() + ':');
    }

    public String getDirectoryName() {
        String directoryName = this.chooser.getParentDirectoryEntry().toString();
        return directoryName;
    }

    private void chooserStateChanged(String textEntered) {
        String dirName = this.getDirectoryName();
        boolean enabling = dirName != null && dirName.length() > 0;
        this.enableForwardButton(enabling);
    }
}

