/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.vdb;

import com.metamatrix.console.ui.util.BasicWizardSubpanelContainer;
import com.metamatrix.console.ui.util.WizardInterface;
import com.metamatrix.console.ui.views.vdb.AllMaterializationFilesDisplayInfo;
import com.metamatrix.console.ui.views.vdb.MaterializationInfoPanel;
import com.metamatrix.console.ui.views.vdb.ViewErrorPanel;
import com.metamatrix.toolbox.ui.widget.CheckBox;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JPanel;

public class VdbWizardWrittenMaterializationFilesPanel
extends BasicWizardSubpanelContainer {
    private JPanel thePanel;
    private boolean overwrite = false;
    protected boolean alreadyWritten;

    public VdbWizardWrittenMaterializationFilesPanel(WizardInterface wizardInterface, int stepNum, boolean alreadyWritten) {
        super(wizardInterface);
        this.alreadyWritten = alreadyWritten;
        String title = alreadyWritten ? "Materialization Files Written" : "Materialization Files to be Written";
        super.setStepText(stepNum, title);
        this.thePanel = this.createPanel();
        super.setMainContent(this.thePanel);
    }

    private JPanel createPanel() {
        JPanel panel = new JPanel();
        return panel;
    }

    public void setResults(Object info) {
        this.thePanel.removeAll();
        GridLayout layout = new GridLayout(2, 1);
        this.thePanel.setLayout(layout);
        JPanel contents = new JPanel();
        if (info instanceof AllMaterializationFilesDisplayInfo) {
            contents = new MaterializationInfoPanel((AllMaterializationFilesDisplayInfo)info, this.alreadyWritten);
        } else if (info instanceof Throwable) {
            contents = new ViewErrorPanel((Throwable)info);
        }
        this.thePanel.add(contents);
        if (!this.alreadyWritten) {
            CheckBox overwriteCheckBox = new CheckBox("Overwrite files if they exist?");
            overwriteCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    VdbWizardWrittenMaterializationFilesPanel.this.overwrite = e.getStateChange() == 1;
                }
            });
            JPanel overwriteCheckBoxPanel = new JPanel();
            overwriteCheckBoxPanel.add(overwriteCheckBox);
            this.thePanel.add(overwriteCheckBoxPanel);
        }
    }

    public boolean getOverwrite() {
        return this.overwrite;
    }
}

