/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.vdb;

import com.metamatrix.console.ui.views.vdb.ModelVisibilityInfo;
import com.metamatrix.toolbox.ui.widget.table.DefaultTableModel;
import java.util.Vector;

class VisibilityTableModel
extends DefaultTableModel {
    private static final String[] COLUMN_HEADERS = new String[]{"Name", "Type", "Visible", "Multiple Source"};
    private static final Vector COLUMN_HEADERS_VECTOR = new Vector(COLUMN_HEADERS.length);

    public VisibilityTableModel(ModelVisibilityInfo[] data) {
        super(COLUMN_HEADERS_VECTOR);
        this.populateModel(data);
    }

    public void populateModel(ModelVisibilityInfo[] data) {
        int i;
        int numRows = this.getRowCount();
        for (i = numRows - 1; i >= 0; --i) {
            this.removeRow(i);
        }
        for (i = 0; i < data.length; ++i) {
            Object[] rowData = new Object[]{data[i].getModelName(), data[i].getModelType(), new Boolean(data[i].isVisible()), new Boolean(data[i].isMultipleSourcesSelected())};
            this.addRow(rowData);
        }
    }

    public boolean publicCheckedForRow(int rowNum) {
        Boolean b = (Boolean)this.getValueAt(rowNum, 2);
        return b;
    }

    public boolean anyPublic() {
        boolean publicFound = false;
        int i = 0;
        int numRows = this.getRowCount();
        while (!publicFound && i < numRows) {
            publicFound = this.publicCheckedForRow(i);
            if (publicFound) continue;
            ++i;
        }
        return publicFound;
    }

    public boolean multipleSourceCheckedForRow(int rowNum) {
        Boolean b = (Boolean)this.getValueAt(rowNum, 3);
        return b;
    }

    public Class getColumnClass(int index) {
        Class cls;
        switch (index) {
            case 2: 
            case 3: {
                cls = Boolean.class;
                break;
            }
            default: {
                cls = String.class;
            }
        }
        return cls;
    }

    static {
        for (int i = 0; i < COLUMN_HEADERS.length; ++i) {
            COLUMN_HEADERS_VECTOR.add(COLUMN_HEADERS[i]);
        }
    }
}

