/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.util;

import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.ui.layout.Workspace;
import com.metamatrix.console.ui.layout.WorkspacePanel;
import com.metamatrix.console.util.AutoRefreshable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;

public class AutoRefresher
implements ActionListener {
    public static final int DEFAULT_DELAY = 60;
    private Timer timer;
    private int refreshRate;
    private boolean isAutoRefreshEnabled;
    private boolean busy = false;
    private AutoRefreshable refTarget = null;
    private ConnectionInfo connection;

    public AutoRefresher(AutoRefreshable refTarget, ConnectionInfo conn) {
        this(refTarget, 60, true, conn);
    }

    public AutoRefresher(AutoRefreshable refTarget, int refreshRateSeconds, ConnectionInfo conn) {
        this(refTarget, refreshRateSeconds, true, conn);
    }

    public AutoRefresher(AutoRefreshable refTarget, int refreshRateSeconds, boolean isAutoRefreshEnabled, ConnectionInfo conn) {
        this.setRefreshTarget(refTarget);
        this.setRefreshRate(refreshRateSeconds);
        this.setAutoRefreshEnabled(isAutoRefreshEnabled);
        this.connection = conn;
    }

    public void init() {
        this.setTimer(new Timer(this.getRefreshRate() * 1000, this));
    }

    public void startTimer() {
        if (!this.getTimer().isRunning() && this.isAutoRefreshEnabled()) {
            this.getTimer().start();
        }
    }

    public void refresh(final boolean setIsStale) {
        if (!this.isTargetCurrentPanel(this.refTarget)) {
            return;
        }
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    if (!ModelManager.getSessionManager(AutoRefresher.this.connection).isSignedOnUserSessionValid()) {
                        AutoRefresher.this.setAutoRefreshEnabled(false);
                        return;
                    }
                    AutoRefresher.this.getTimer().stop();
                    if (setIsStale) {
                        AutoRefresher.this.refTarget.refresh();
                    }
                }
                catch (Exception e) {
                    AutoRefresher.this.setAutoRefreshEnabled(false);
                }
                if (AutoRefresher.this.isAutoRefreshEnabled()) {
                    AutoRefresher.this.startTimer();
                }
            }
        };
        thread.start();
    }

    private boolean isTargetCurrentPanel(AutoRefreshable refTarget) {
        return refTarget instanceof WorkspacePanel && Workspace.getInstance().getCurrentPanel().equals(refTarget);
    }

    public void refresh() {
        this.refresh(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isBusy()) {
            this.refresh();
        }
    }

    public void setRefreshTarget(AutoRefreshable ref) {
        this.refTarget = ref;
    }

    public int getRefreshRate() {
        return this.refreshRate;
    }

    public void setRefreshRate(int seconds) {
        this.refreshRate = seconds;
        boolean started = false;
        if (this.getTimer() != null) {
            this.getTimer().removeActionListener(this);
            if (this.getTimer().isRunning()) {
                started = true;
            }
        }
        this.setTimer(new Timer(this.getRefreshRate() * 1000, this));
        if (started) {
            this.startTimer();
        }
    }

    public boolean isAutoRefreshEnabled() {
        return this.isAutoRefreshEnabled;
    }

    public void setAutoRefreshEnabled(boolean isAutoRefreshEnabled) {
        this.isAutoRefreshEnabled = isAutoRefreshEnabled;
        if (!isAutoRefreshEnabled && this.getTimer() != null && this.getTimer().isRunning()) {
            this.getTimer().stop();
        }
        if (isAutoRefreshEnabled && this.getTimer() != null) {
            this.startTimer();
        }
    }

    protected Timer getTimer() {
        return this.timer;
    }

    private void setTimer(Timer timer) {
        if (this.timer != null) {
            this.timer.removeActionListener(this);
        }
        this.timer = timer;
    }

    public boolean isBusy() {
        return this.busy;
    }

    public synchronized void setBusy(boolean busy) {
        this.busy = busy;
    }
}

