/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.util;

import java.io.Serializable;
import java.util.Date;

public class DaysHoursMinutesSeconds
implements Serializable {
    private int days;
    private int hours;
    private int minutes;
    private int seconds;
    private float secondsWithDecimal;

    public static void printMethodCallDurationMessage(String methodName, Date startingTime, Date endingTime) {
        long startingTimeAsLong = startingTime.getTime();
        long endingTimeAsLong = endingTime.getTime();
        long timeDiffInMilliseconds = endingTimeAsLong - startingTimeAsLong;
        DaysHoursMinutesSeconds dhms = new DaysHoursMinutesSeconds(timeDiffInMilliseconds);
        String timeAsString = dhms.toDisplayString(true);
        String message = ">>>>Call to " + methodName + " took " + timeAsString;
        System.err.println(message);
    }

    public DaysHoursMinutesSeconds(int d, int h, int m, int s) {
        this.days = d;
        this.hours = h;
        this.minutes = m;
        this.seconds = s;
        this.secondsWithDecimal = this.seconds;
    }

    public DaysHoursMinutesSeconds(int d, int h, int m) {
        this(d, h, m, 0);
    }

    public DaysHoursMinutesSeconds(int seconds) {
        int numDays = seconds / 86400;
        int remainingSeconds = seconds - numDays * 86400;
        int numHours = remainingSeconds / 3600;
        int numMinutes = (remainingSeconds -= numHours * 3600) / 60;
        this.days = numDays;
        this.hours = numHours;
        this.minutes = numMinutes;
        seconds = remainingSeconds -= numMinutes * 60;
        this.secondsWithDecimal = seconds;
    }

    public DaysHoursMinutesSeconds(long milliseconds) {
        int numDays = (int)(milliseconds / 86400000L);
        long remainingMilliseconds = milliseconds - (long)(numDays * 86400000);
        int numHours = (int)(remainingMilliseconds / 3600000L);
        int numMinutes = (int)((remainingMilliseconds -= (long)(numHours * 3600000)) / 60000L);
        this.days = numDays;
        this.hours = numHours;
        this.minutes = numMinutes;
        this.secondsWithDecimal = (float)(remainingMilliseconds -= (long)(numMinutes * 60000)) / 1000.0f;
        this.seconds = (int)this.secondsWithDecimal;
    }

    public int getDays() {
        return this.days;
    }

    public int getHours() {
        return this.hours;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public float getSecondsWithDecimal() {
        return this.secondsWithDecimal;
    }

    public String toDisplayString(boolean includeSeconds) {
        String str = "";
        if (this.days > 0) {
            str = str + this.days;
            str = this.days == 1 ? str + " day, " : str + " days, ";
        }
        if (this.days > 0 || this.hours > 0) {
            str = str + this.hours;
            str = this.hours == 1 ? str + " hour, " : str + " hours, ";
        }
        if (this.days > 0 || this.hours > 0 || this.minutes > 0 || !includeSeconds) {
            str = str + this.minutes;
            str = this.minutes == 1 ? str + " minute" : str + " minutes";
            if (includeSeconds) {
                str = str + ", ";
            }
        }
        if (includeSeconds) {
            float intSecondsAsFloat = this.seconds;
            if (intSecondsAsFloat == this.secondsWithDecimal) {
                str = str + this.seconds;
                str = this.seconds == 1 ? str + " second" : str + " seconds";
            } else {
                str = str + this.secondsWithDecimal + " seconds";
            }
        }
        return str;
    }

    public String toString() {
        String str = "DaysHoursMinutesSeconds: days=" + this.days + ",hours=" + this.hours + ",minutes=" + this.minutes + ",seconds=" + this.seconds;
        return str;
    }
}

