/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.util;

import com.metamatrix.console.ui.dialog.PendingChangesDialog;
import com.metamatrix.console.ui.util.CenteredOptionPane;
import com.metamatrix.console.util.StaticUtilities;
import java.awt.Component;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class DialogUtility {
    public static final String CONFIRM_DELETE_HDR = "Confirm Deletion";
    public static final int YES = 0;
    public static final int NO = 1;
    public static final int CANCEL = 2;
    private static Component defaultComponent = null;

    public static void setDefaultComponent(Component c) {
        defaultComponent = c;
    }

    public static JFrame getDefaultComponent() {
        return (JFrame)defaultComponent;
    }

    public static boolean yesNoDialog(Component c, Object message, String title) {
        int i;
        if (c == null) {
            c = defaultComponent;
        }
        return (i = JOptionPane.showConfirmDialog(c, message, title, 0)) == 0;
    }

    public static int displayYesNoDialog(Component c, String header, String message) {
        String formattedMessage = StaticUtilities.insertLineBreaks(message, 70, 130);
        Component comp = c;
        if (comp == null) {
            comp = defaultComponent;
        }
        int val = CenteredOptionPane.showConfirmDialog(comp, formattedMessage, header, 0);
        int response = -1;
        switch (val) {
            case 0: {
                response = 0;
                break;
            }
            case 1: {
                response = 1;
            }
        }
        return response;
    }

    public static int showPendingChangesDialog(String msg, String url, String userName) {
        PendingChangesDialog dlg = new PendingChangesDialog((JFrame)defaultComponent, msg, url, userName);
        dlg.show();
        int response = dlg.getResponse();
        return response;
    }
}

