/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.util;

import com.metamatrix.api.exception.ComponentNotFoundException;
import com.metamatrix.api.exception.MetaMatrixException;
import com.metamatrix.api.exception.MultipleException;
import com.metamatrix.api.exception.MultipleRuntimeException;
import com.metamatrix.api.exception.security.AuthorizationException;
import com.metamatrix.api.exception.security.LogonException;
import com.metamatrix.common.application.exception.ApplicationInitializationException;
import com.metamatrix.console.ConsolePlugin;
import com.metamatrix.console.ui.ViewManager;
import com.metamatrix.console.ui.dialog.ErrorDialog;
import com.metamatrix.console.util.ExternalException;
import com.metamatrix.console.util.RuntimeExternalException;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.core.MetaMatrixCoreException;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.toolbox.preference.UserPreferences;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.UnknownHostException;
import java.util.Iterator;
import javax.naming.NamingException;

public class ExceptionUtility {
    public static final String ERROR_DIALOG_DIR_KEY = "metamatrix.console.errordialogdirectory";
    public static final String MSG_HOST_NOT_FOUND = ConsolePlugin.Util.getString("ExceptionUtility.hostNotFoundMsg");
    public static final String MSG_COMP_NOT_FOUND = ConsolePlugin.Util.getString("ExceptionUtility.compNotFoundMsg");
    public static final String MSG_QUERY_SERVICE_NOT_FOUND = ConsolePlugin.Util.getString("ExceptionUtility.queryServiceNotFoundMsg");
    public static final String MSG_AUTHORIZATION_FAILURE = ConsolePlugin.Util.getString("ExceptionUtility.authFailureMsg");
    public static final String MSG_EXTERNAL_FAILURE = ConsolePlugin.Util.getString("ExceptionUtility.externalFailMsg");
    public static final String MSG_ILLEGAL_REQUEST = ConsolePlugin.Util.getString("ExceptionUtility.illegalReqstMsg");
    public static final String MSG_CANNOT_INITIALIZE = ConsolePlugin.Util.getString("ExceptionUtility.cannotInitMsg");
    public static final String MSG_CALLBACK_PROBLEM = ConsolePlugin.Util.getString("ExceptionUtility.callbackProbMsg");
    public static final String MSG_UNSPECIFIED_FAILURE = ConsolePlugin.Util.getString("ExceptionUtility.unspecFailureMsg");
    public static final String TITLE_DEFAULT = ConsolePlugin.Util.getString("ExceptionUtility.titleDefMsg");

    public static void showMessage(String text, String comment, Throwable thr) {
        boolean messageDisplayed = false;
        Exception ex = null;
        if (thr != null) {
            Throwable encryptEx;
            if (thr instanceof NoClassDefFoundError) {
                comment = "Unable to locate class for: " + comment;
                ExceptionUtility.showUnspecifiedFailureMessage(text, comment, thr);
            }
            if (thr instanceof Exception) {
                ex = (Exception)thr;
            }
            if (ex instanceof RuntimeExternalException) {
                ex = ((RuntimeExternalException)ex).getTheException();
            }
            if (ex instanceof MetaMatrixRuntimeException) {
                Throwable t = ((MetaMatrixRuntimeException)ex).getChild();
                if (t instanceof Exception) {
                    MetaMatrixCoreException coreException;
                    Throwable cause;
                    Exception nestedException = (Exception)t;
                    if (nestedException instanceof MetaMatrixCoreException && (cause = (coreException = (MetaMatrixCoreException)nestedException).getCause()) instanceof UnknownHostException) {
                        ExceptionUtility.showUnknownHostException(text, MSG_HOST_NOT_FOUND + ":  Unknown host:  " + cause.getMessage(), cause);
                        messageDisplayed = true;
                    }
                } else {
                    ExceptionUtility.showUnspecifiedFailureMessage(text, comment, t);
                }
            }
            if (ex instanceof ComponentNotFoundException) {
                ExceptionUtility.showCompNotFoundFailureMessage(text, comment, ex);
                messageDisplayed = true;
            } else if (ExceptionUtility.containsExceptionContainingString(ex, "class not compatible", true) != null || ExceptionUtility.containsExceptionContainingString(ex, "unmarshal", true) != null) {
                ExceptionUtility.showUnavailableMessage(text, ex);
                messageDisplayed = true;
            } else if (ex instanceof AuthorizationException || ex instanceof LogonException) {
                ExceptionUtility.showAuthorizationFailureMessage(text, comment, ex);
                messageDisplayed = true;
            } else if (ex instanceof ExternalException) {
                Throwable licenseEx = ExceptionUtility.containsExceptionContainingString(ex, "License exception", true);
                if (licenseEx != null && licenseEx instanceof Exception) {
                    ExceptionUtility.showExternalFailureMessage("License Error", "License error.  Please ensure that required licenses are correctly installed.", (Exception)licenseEx);
                } else {
                    Throwable t = ExceptionUtility.unRollException(ex);
                    if (t instanceof ApplicationInitializationException) {
                        Throwable encryptEx2 = ExceptionUtility.containsExceptionContainingString(t, "decrypt", true);
                        if (encryptEx2 != null) {
                            ExceptionUtility.showExternalFailureMessage("Password Encryption Problem", "Password Encryption Problem.  Please ensure that connector binding passwords were updated after the VDB was deployed from the repository.", (Exception)encryptEx2);
                        } else {
                            ExceptionUtility.showExternalFailureMessage(text, comment, ex);
                        }
                    } else {
                        ExceptionUtility.showExternalFailureMessage(text, comment, ex);
                    }
                }
                messageDisplayed = true;
            } else if (ex instanceof ApplicationInitializationException && (encryptEx = ExceptionUtility.containsExceptionContainingString(ex, "decrypt", true)) != null) {
                ExceptionUtility.showExternalFailureMessage("Password Encryption Problem", "Password Encryption Problem.  Please ensure that connector binding passwords were updated after the VDB was deployed from the repository.", (Exception)encryptEx);
            }
        }
        if (!messageDisplayed) {
            ExceptionUtility.showUnspecifiedFailureMessage(text, comment, thr);
        }
    }

    public static void showMessage(String text, Throwable t) {
        ExceptionUtility.showMessage(text, "", t);
    }

    private static void showDialog(String text, String cmmnt, Throwable t, boolean increaseSize, boolean showlasterror) {
        String fileName;
        String comment = cmmnt;
        if (comment == null) {
            comment = "";
        }
        StaticUtilities.endWait(ViewManager.getMainFrame());
        int index = comment.toLowerCase().indexOf("start server side stack trace");
        String initialDirectory = ExceptionUtility.getInitialErrorDialogSaveDirectory();
        ErrorDialog.setDisplayLastException(showlasterror);
        ErrorDialog errDlg = new ErrorDialog(ViewManager.getMainFrame(), TITLE_DEFAULT, text, index == -1 ? comment : comment.substring(0, index), t, initialDirectory);
        if (increaseSize) {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            int width = (int)((double)screenSize.width * 0.5);
            int height = (int)((double)screenSize.height * 0.25);
            errDlg.setSize(width, height);
        }
        errDlg.show();
        if (errDlg.isSuccessfullySaved() && (fileName = errDlg.getSavedFileName().trim()) != null && fileName.length() > 0) {
            ExceptionUtility.setInitialErrorDialogSaveDirectory(fileName);
        }
    }

    private static void showDialog(String text, String cmmnt, Throwable t, boolean increaseSize) {
        String fileName;
        String comment = cmmnt;
        if (comment == null) {
            comment = "";
        }
        StaticUtilities.endWait(ViewManager.getMainFrame());
        int index = comment.toLowerCase().indexOf("start server side stack trace");
        String initialDirectory = ExceptionUtility.getInitialErrorDialogSaveDirectory();
        ErrorDialog errDlg = new ErrorDialog(ViewManager.getMainFrame(), TITLE_DEFAULT, text, index == -1 ? comment : comment.substring(0, index), t, initialDirectory);
        if (increaseSize) {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            int width = (int)((double)screenSize.width * 0.5);
            int height = (int)((double)screenSize.height * 0.25);
            errDlg.setSize(width, height);
        }
        errDlg.show();
        if (errDlg.isSuccessfullySaved() && (fileName = errDlg.getSavedFileName().trim()) != null && fileName.length() > 0) {
            ExceptionUtility.setInitialErrorDialogSaveDirectory(fileName);
        }
    }

    private static String getInitialErrorDialogSaveDirectory() {
        String dir = (String)UserPreferences.getInstance().getValue(ERROR_DIALOG_DIR_KEY);
        return dir;
    }

    private static void setInitialErrorDialogSaveDirectory(String fileName) {
        String directoryName = null;
        int index = fileName.lastIndexOf(File.separatorChar);
        try {
            directoryName = fileName.substring(0, index);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (directoryName != null) {
            UserPreferences.getInstance().setValue(ERROR_DIALOG_DIR_KEY, directoryName);
            UserPreferences.getInstance().saveChanges();
        }
    }

    private static void showDialog(String text, String comment, Throwable t) {
        ExceptionUtility.showDialog(text, comment, t, true);
    }

    public static void showQueryServiceNotAvailableFailureMessage(String text, Exception e) {
        ExceptionUtility.showQueryServiceNotAvailableFailureMessage(text, "", e);
    }

    public static void showCompNotFoundFailureMessage(String text, Exception e) {
        ExceptionUtility.showCompNotFoundFailureMessage(text, "", e);
    }

    public static void showAuthorizationFailureMessage(String text, Exception e) {
        ExceptionUtility.showAuthorizationFailureMessage(text, "", e);
    }

    public static void showExternalFailureMessage(String text, Exception e) {
        ExceptionUtility.showExternalFailureMessage(text, "", e);
    }

    public static void showIllegalRequestMessage(String text, Exception e) {
        ExceptionUtility.showDialog(text, MSG_ILLEGAL_REQUEST, e);
    }

    public static void showCannotInitializeMessage(Exception e) {
        ExceptionUtility.showCannotInitializeMessage("", "", e);
    }

    public static void showCannotInitializeMessage(String text, Exception e) {
        ExceptionUtility.showDialog(text, MSG_CANNOT_INITIALIZE, e);
    }

    public static void showCallbackExceptionMessage(String text, Exception e) {
        ExceptionUtility.showDialog(text, MSG_CALLBACK_PROBLEM, e);
    }

    public static void showUnspecifiedFailureMessage(String text, Throwable e) {
        ExceptionUtility.showDialog(text, MSG_UNSPECIFIED_FAILURE, e);
    }

    public static void showCompNotFoundFailureMessage(String text, String cmmnt, Exception e) {
        String comment = cmmnt;
        if (comment == null) {
            comment = "";
        }
        String sComment = "";
        sComment = comment.trim().equals("") ? MSG_COMP_NOT_FOUND : comment;
        ExceptionUtility.showDialog(text, sComment, e);
    }

    public static void showQueryServiceNotAvailableFailureMessage(String text, String cmmnt, Exception e) {
        String comment = cmmnt;
        if (comment == null) {
            comment = "";
        }
        String sComment = "";
        sComment = comment.trim().equals("") ? MSG_QUERY_SERVICE_NOT_FOUND : comment;
        ExceptionUtility.showDialog(text, sComment, e);
    }

    public static void showAuthorizationFailureMessage(String text, String cmmnt, Exception e) {
        String comment = cmmnt;
        if (comment == null) {
            comment = "";
        }
        String sComment = "";
        sComment = comment.trim().equals("") ? MSG_AUTHORIZATION_FAILURE : comment;
        ExceptionUtility.showDialog(text, sComment, e);
    }

    public static void showExternalFailureMessage(String text, String cmmnt, Exception e) {
        String comment = cmmnt;
        if (comment == null) {
            comment = "";
        }
        String sComment = "";
        sComment = comment.trim().equals("") ? MSG_EXTERNAL_FAILURE : comment;
        ExceptionUtility.showDialog(text, sComment, e);
    }

    public static void showExternalFailureMessage(String text, String cmmnt, Exception e, boolean showlasterror) {
        String comment = cmmnt;
        if (comment == null) {
            comment = "";
        }
        String sComment = "";
        sComment = comment.trim().equals("") ? MSG_EXTERNAL_FAILURE : comment;
        ExceptionUtility.showDialog(text, sComment, e, true, showlasterror);
    }

    public static void showUnavailableMessage(String text, Exception ex) {
        String comment = ConsolePlugin.Util.getString("ExceptionUtility.serverUnavailableMsg");
        ExceptionUtility.showDialog(text, comment, ex, true);
    }

    private static void showUnknownHostException(String text, String cmmnt, Throwable e) {
        String comment = cmmnt;
        if (comment == null) {
            comment = "";
        }
        String sComment = "";
        sComment = comment.trim().equals("") ? MSG_HOST_NOT_FOUND : comment;
        ExceptionUtility.showDialog(text, sComment, e);
    }

    public static void showIllegalRequestMessage(String text, String cmmnt, Exception e) {
        String comment = cmmnt;
        if (comment == null) {
            comment = "";
        }
        String sComment = "";
        sComment = comment.trim().equals("") ? MSG_ILLEGAL_REQUEST : comment;
        ExceptionUtility.showDialog(text, sComment, e);
    }

    public static void showCannotInitializeMessage(String text, String cmmnt, Exception e) {
        String comment = cmmnt;
        if (comment == null) {
            comment = "";
        }
        String sComment = "";
        sComment = comment.trim().equals("") ? MSG_CANNOT_INITIALIZE : comment;
        ExceptionUtility.showDialog(text, sComment, e);
    }

    public static void showCallbackExceptionMessage(String text, String cmmnt, Exception e) {
        String comment = cmmnt;
        if (comment == null) {
            comment = "";
        }
        String sComment = "";
        sComment = comment.trim().equals("") ? MSG_CALLBACK_PROBLEM : comment;
        ExceptionUtility.showDialog(text, sComment, e);
    }

    public static void showUnspecifiedFailureMessage(String text, String cmmnt, Throwable t) {
        String comment = cmmnt;
        if (comment == null) {
            comment = "";
        }
        String sComment = "";
        sComment = comment.trim().equals("") ? MSG_UNSPECIFIED_FAILURE : comment;
        ExceptionUtility.showDialog(text, sComment, t);
    }

    public static boolean containsExceptionOfType(Throwable ex, Class cls) {
        Throwable obj = ex;
        boolean done = false;
        boolean found = false;
        while (!found && !done) {
            if (cls.isAssignableFrom(obj.getClass())) {
                found = true;
                continue;
            }
            if (obj instanceof MetaMatrixException) {
                if ((obj = ((MetaMatrixException)obj).getChild()) != null) continue;
                done = true;
                continue;
            }
            done = true;
        }
        return found;
    }

    public static Throwable containsExceptionContainingString(Throwable ex, String searchingFor, boolean ignoreCase) {
        int searchingForLen = searchingFor.length();
        Throwable result = null;
        Throwable currentThrowable = ex;
        boolean matchFound = false;
        boolean done = false;
        while (!matchFound && !done && currentThrowable != null) {
            String message = currentThrowable.getMessage();
            if (message != null) {
                int highestStartingIndex = message.length() - searchingForLen;
                int loc = 0;
                while (!matchFound && loc <= highestStartingIndex) {
                    matchFound = message.regionMatches(ignoreCase, loc, searchingFor, 0, searchingForLen);
                    if (matchFound) {
                        result = currentThrowable;
                        continue;
                    }
                    ++loc;
                }
            }
            if (matchFound) continue;
            if (currentThrowable instanceof MetaMatrixException) {
                currentThrowable = ((MetaMatrixException)currentThrowable).getChild();
                continue;
            }
            if (currentThrowable instanceof NamingException) {
                currentThrowable = ((NamingException)currentThrowable).getRootCause();
                continue;
            }
            done = true;
        }
        return result;
    }

    public static MetaMatrixException containsExceptionHavingCode(Throwable ex, String code) {
        MetaMatrixException result = null;
        Throwable currentThrowable = ex;
        boolean done = false;
        while (!done) {
            if (currentThrowable instanceof MetaMatrixException) {
                MetaMatrixException mex = (MetaMatrixException)currentThrowable;
                String curCode = mex.getCode();
                if (code.equalsIgnoreCase(curCode)) {
                    result = mex;
                    done = true;
                    continue;
                }
                currentThrowable = mex.getChild();
                continue;
            }
            done = true;
        }
        return result;
    }

    public static Throwable unRollException(Throwable throwable) {
        Throwable result = throwable;
        if (throwable == null) {
            return result;
        }
        if (throwable instanceof MetaMatrixException) {
            result = ExceptionUtility.unRollException(((MetaMatrixException)throwable).getChild());
        } else if (throwable instanceof MetaMatrixRuntimeException) {
            result = ExceptionUtility.unRollException(((MetaMatrixRuntimeException)throwable).getChild());
        } else if (throwable instanceof MultipleException) {
            Iterator iter = ((MultipleException)throwable).getExceptions().iterator();
            while (iter.hasNext()) {
                result = ExceptionUtility.unRollException((Throwable)iter.next());
            }
        } else if (throwable instanceof MultipleRuntimeException) {
            Iterator iter = ((MultipleRuntimeException)throwable).getThrowables().iterator();
            while (iter.hasNext()) {
                result = ExceptionUtility.unRollException((Throwable)iter.next());
            }
        } else if (throwable instanceof InvocationTargetException) {
            result = ExceptionUtility.unRollException(((InvocationTargetException)throwable).getTargetException());
        }
        if (result == null) {
            result = throwable;
            return result;
        }
        return result;
    }
}

