/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.util;

import com.metamatrix.console.util.HashedListEntry;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class HashedList {
    private boolean bAllowDupes = false;
    private Hashtable htHash = null;
    public static final String ROOT = "ROOT";

    public Hashtable getHashtable() {
        if (this.htHash == null) {
            this.htHash = new Hashtable();
            this.htHash.put(ROOT, new Vector());
        }
        return this.htHash;
    }

    public void put(HashedListEntry hleEntry) {
        if (hleEntry.getHLConcatenatedKey() == null) {
            Vector v = (Vector)this.getHashtable().get(ROOT);
            v.add(hleEntry);
        } else if (this.getHashtable().containsKey(hleEntry.getHLConcatenatedKey())) {
            Vector v = (Vector)this.htHash.get(hleEntry.getHLConcatenatedKey());
            if (v.contains(hleEntry)) {
                if (this.bAllowDupes) {
                    v.add(hleEntry);
                }
            } else {
                v.add(hleEntry);
            }
        } else {
            Vector<HashedListEntry> v = new Vector<HashedListEntry>();
            v.add(hleEntry);
            this.getHashtable().put(hleEntry.getHLConcatenatedKey(), v);
        }
    }

    public List getList(HashedListEntry hleEntry) {
        return this.getList(hleEntry.getHLConcatenatedKey());
    }

    public List getList(String sKey) {
        return (Vector)this.getHashtable().get(sKey);
    }

    public void remove(HashedListEntry hleEntry) {
        List lstValues = this.getList(hleEntry.getHLConcatenatedKey());
        lstValues.remove(hleEntry);
        if (lstValues.size() == 0) {
            this.removeList(hleEntry.getHLConcatenatedKey());
        }
    }

    public void removeList(HashedListEntry hleEntry) {
        this.removeList(hleEntry.getHLConcatenatedKey());
    }

    public void removeList(String sKey) {
        this.getHashtable().remove(sKey);
    }

    public void setAllowDupes(boolean b) {
        this.bAllowDupes = b;
    }

    public boolean getAllowDupes() {
        return this.bAllowDupes;
    }
}

