/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.util;

import java.io.Serializable;
import java.util.Date;
import java.util.GregorianCalendar;

public class QCDate
implements Serializable {
    public static final int MONDAY = 0;
    public static final int TUESDAY = 1;
    public static final int WEDNESDAY = 2;
    public static final int THURSDAY = 3;
    public static final int FRIDAY = 4;
    public static final int SATURDAY = 5;
    public static final int SUNDAY = 6;
    public static final String[] MONTH_ABBREVS = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    public static final int BASE_YEAR = 1912;
    public static final int MAX_YEAR = 2099;
    public static final int[] NUM_DAYS_BEFORE_MONTH_NON_LEAP_YEAR = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};
    private int year;
    private int month;
    private int day;

    public QCDate() {
    }

    public QCDate(int aYear, int aMonth, int aDay) {
        this.year = aYear;
        this.month = aMonth;
        this.day = aDay;
    }

    public QCDate(GregorianCalendar aCal) {
        this(aCal.get(1), aCal.get(2) + 1, aCal.get(5));
    }

    public QCDate(Date aDate) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(aDate);
        this.year = cal.get(1);
        this.month = cal.get(2) + 1;
        this.day = cal.get(5);
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public Object clone() {
        return new QCDate(this.year, this.month, this.day);
    }

    public boolean equals(QCDate anotherDate) {
        return this.year == anotherDate.year && this.month == anotherDate.month && this.day == anotherDate.day;
    }

    public boolean isGreaterThan(QCDate anotherDate) {
        return this.year > anotherDate.year || this.year == anotherDate.year && this.month > anotherDate.month || this.year == anotherDate.year && this.month == anotherDate.month && this.day > anotherDate.day;
    }

    public boolean isLessThan(QCDate anotherDate) {
        return this.year < anotherDate.year || this.year == anotherDate.year && this.month < anotherDate.month || this.year == anotherDate.year && this.month == anotherDate.month && this.day < anotherDate.day;
    }

    public static int numberOfDaysInMonth(int aYear, int aMonth) {
        if (aYear < 1912 || aYear > 2099) {
            System.err.println("Illegal year passed to QCDate.numberOfDaysInMonth()");
            return -1;
        }
        if (aMonth == 2) {
            if (aYear % 4 == 0) {
                return 29;
            }
            return 28;
        }
        if (aMonth == 4 || aMonth == 6 || aMonth == 9 || aMonth == 11) {
            return 30;
        }
        return 31;
    }

    public static boolean legalDate(int aYear, int aMonth, int aDay) {
        boolean legal = true;
        if (aYear < 1912 || aYear > 2099) {
            legal = false;
        } else if (aMonth < 1 || aMonth > 12) {
            legal = false;
        } else if (aDay < 1 || aDay > QCDate.numberOfDaysInMonth(aYear, aMonth)) {
            legal = false;
        }
        return legal;
    }

    public static boolean leapYear(int aYear) {
        return aYear % 4 == 0;
    }

    public static int dayNumberWithinYear(int aYear, int aMonth, int aDay) {
        if (!QCDate.legalDate(aYear, aMonth, aDay)) {
            System.err.println("Illegal date passed to QCDate.dayNumberWithinYear()");
            return -1;
        }
        int numDaysBeforeMonth = NUM_DAYS_BEFORE_MONTH_NON_LEAP_YEAR[aMonth - 1];
        if (aMonth > 2 && QCDate.leapYear(aYear)) {
            ++numDaysBeforeMonth;
        }
        int result = numDaysBeforeMonth + aDay;
        return result;
    }

    public static int dayNumberWithinYear(QCDate aDate) {
        return QCDate.dayNumberWithinYear(aDate.year, aDate.month, aDate.day);
    }

    public static int dayNumber(int aYear, int aMonth, int aDay) {
        if (!QCDate.legalDate(aYear, aMonth, aDay)) {
            System.err.println("Illegal date passed to QCDate.dayNumber()");
            return -1;
        }
        int numDaysBeforeCurYearExclFeb29 = 365 * (aYear - 1912);
        int numDaysCurYear = QCDate.dayNumberWithinYear(aYear, aMonth, aDay);
        int numLeapDaysPriorToCurYear = (aYear + 3 - 1912) / 4;
        int dayNum = numDaysBeforeCurYearExclFeb29 + numLeapDaysPriorToCurYear + numDaysCurYear;
        return dayNum;
    }

    public static int dayNumber(QCDate aDate) {
        return QCDate.dayNumber(aDate.year, aDate.month, aDate.day);
    }

    public static int weekdayNumber(int aYear, int aMonth, int aDay) {
        if (!QCDate.legalDate(aYear, aMonth, aDay)) {
            System.err.println("illegal date passed to QCDate.weekdayNumber()");
            return -1;
        }
        int numAllDays = QCDate.dayNumber(aYear, aMonth, aDay);
        int numSaturdays = (numAllDays + 1) / 7;
        int numSundays = numAllDays / 7;
        return numAllDays - (numSaturdays + numSundays);
    }

    public static int weekdayNumber(QCDate aDate) {
        return QCDate.weekdayNumber(aDate.year, aDate.month, aDate.day);
    }

    public static int dayOfWeek(int aYear, int aMonth, int aDay) {
        if (!QCDate.legalDate(aYear, aMonth, aDay)) {
            System.err.println("Illegal date passed to QCDate.dayOfWeek()");
            return -1;
        }
        return (QCDate.dayNumber(aYear, aMonth, aDay) - 1) % 7;
    }

    public static int dayOfWeek(QCDate aDate) {
        return QCDate.dayOfWeek(aDate.year, aDate.month, aDate.day);
    }

    public static boolean isWeekday(QCDate aDate) {
        int dayOfWeek = QCDate.dayOfWeek(aDate);
        boolean saturday = dayOfWeek == 5;
        boolean sunday = dayOfWeek == 6;
        return !saturday && !sunday;
    }

    public static boolean isWeekend(QCDate aDate) {
        return !QCDate.isWeekday(aDate);
    }

    public static int weekNumber(int aYear, int aMonth, int aDay) {
        if (!QCDate.legalDate(aYear, aMonth, aDay)) {
            System.err.println("illegal date passed to QCDate.weekNumber()");
            return -1;
        }
        int d = (QCDate.dayNumber(aYear, aMonth, aDay) - 1) / 7 + 1;
        return d;
    }

    public static int weekNumber(QCDate aDate) {
        return QCDate.weekNumber(aDate.year, aDate.month, aDate.day);
    }

    public static int monthNumber(int aYear, int aMonth) {
        if (!QCDate.legalDate(aYear, aMonth, 1)) {
            System.err.println("Illegal date passed to QCDate.monthNumber()");
            return -1;
        }
        return (aYear - 1912) * 12 + aMonth;
    }

    public static int monthNumber(QCDate aDate) {
        return QCDate.monthNumber(aDate.year, aDate.month);
    }

    public static int quarterNumber(int aYear, int aMonth) {
        if (!QCDate.legalDate(aYear, aMonth, 1)) {
            System.err.println("illegal date passed to QCDate.quarterNumber()");
            return -1;
        }
        int qtrsBeforeCurYear = 4 * (aYear - 1912);
        int qtrOfCurYear = (aMonth - 1) / 3 + 1;
        return qtrsBeforeCurYear + qtrOfCurYear;
    }

    public static int quarterNumber(QCDate aDate) {
        return QCDate.quarterNumber(aDate.year, aDate.month);
    }

    public static int yearNumber(int aYear) {
        return aYear + 1 - 1912;
    }

    public static int yearNumber(QCDate aDate) {
        return QCDate.yearNumber(aDate.year);
    }

    public static QCDate dateOfDayNumber(int aDayNumber) {
        boolean curMonthAllFits;
        boolean curYearAllFits;
        boolean isLeapYear;
        int DAY_NUMBER_OF_DEC_31_1998 = QCDate.dayNumber(1998, 12, 31);
        if (aDayNumber < 1 || aDayNumber > QCDate.dayNumber(2099, 12, 31)) {
            System.err.println("Illegal date passed to dateOfDayNumber");
            return null;
        }
        QCDate date = new QCDate();
        int curYear = 1912;
        int daysAccumulated = 0;
        if (aDayNumber > DAY_NUMBER_OF_DEC_31_1998) {
            curYear = 1999;
            daysAccumulated = DAY_NUMBER_OF_DEC_31_1998;
        }
        int numDaysInCurYear = (isLeapYear = QCDate.leapYear(curYear)) ? 366 : 365;
        boolean bl = curYearAllFits = daysAccumulated + numDaysInCurYear < aDayNumber;
        while (curYearAllFits) {
            numDaysInCurYear = (isLeapYear = QCDate.leapYear(++curYear)) ? 366 : 365;
            curYearAllFits = (daysAccumulated += numDaysInCurYear) + numDaysInCurYear < aDayNumber;
        }
        date.year = curYear;
        int month = 1;
        int numDaysInMonth = QCDate.numberOfDaysInMonth(curYear, month);
        boolean bl2 = curMonthAllFits = daysAccumulated + numDaysInMonth < aDayNumber;
        while (curMonthAllFits) {
            curMonthAllFits = (daysAccumulated += numDaysInMonth) + (numDaysInMonth = QCDate.numberOfDaysInMonth(curYear, ++month)) < aDayNumber;
        }
        date.month = month;
        date.day = aDayNumber - daysAccumulated;
        return date;
    }

    public static QCDate dateOfWeekNumber(int aWeekNumber) {
        return QCDate.dateOfDayNumber((aWeekNumber - 1) * 7 + 1);
    }

    public static QCDate dateOfMonthNumber(int aMonthNumber) {
        int year = (aMonthNumber - 1) / 12 + 1912;
        int month = (aMonthNumber - 1) % 12 + 1;
        return new QCDate(year, month, 1);
    }

    public static QCDate dateOfQuarterNumber(int aQuarterNumber) {
        int year = (aQuarterNumber - 1) / 4 + 1912;
        int quarter = (aQuarterNumber - 1) % 4 + 1;
        int month = 3 * (quarter - 1) + 1;
        return new QCDate(year, month, 1);
    }

    public static QCDate dateOfYearNumber(int aYearNumber) {
        return new QCDate(aYearNumber - 1 + 1912, 1, 1);
    }

    public String toShortString() {
        int yearLastTwo = this.year % 100;
        String yearString = new Integer(yearLastTwo).toString();
        if (yearLastTwo < 10) {
            yearString = "0" + yearString;
        }
        return this.month + "/" + this.day + "/" + yearString;
    }

    public String toDayMonthYearLastTwoString() {
        String dayString = new Integer(this.day).toString();
        if (this.day < 10) {
            dayString = "0" + dayString;
        }
        String yearString = new Integer(this.year).toString();
        String yearLastTwo = yearString.substring(2, 4);
        return dayString + " " + MONTH_ABBREVS[this.month - 1] + " " + yearLastTwo;
    }

    public String toMonthYearString() {
        String yearString = new Integer(this.year).toString();
        String monthString = MONTH_ABBREVS[this.month - 1];
        return monthString + " " + yearString;
    }

    public String toMonthYearLastTwoString() {
        String yearString = new Integer(this.year).toString();
        String yearLastTwo = yearString.substring(2, 4);
        String monthString = MONTH_ABBREVS[this.month - 1];
        return monthString + " " + yearLastTwo;
    }

    public String toMonthString() {
        String monthString = MONTH_ABBREVS[this.month - 1];
        return monthString;
    }

    public String toMonthDayYearString() {
        String monthString = MONTH_ABBREVS[this.month - 1];
        String dayString = new Integer(this.day).toString();
        String yearString = new Integer(this.year).toString();
        String str = monthString + " " + dayString + ", " + yearString;
        return str;
    }

    public String toNumericMDYString() {
        String str = "";
        if (this.month < 10) {
            str = str + "0";
        }
        str = str + this.month + "/";
        if (this.day < 10) {
            str = str + "0";
        }
        str = str + this.day + "/" + this.year;
        return str;
    }

    public GregorianCalendar toGregorian(int hours, int minutes) {
        return new GregorianCalendar(this.year - 1900, this.month - 1, this.day, hours, minutes);
    }

    public GregorianCalendar toGregorian(int hours) {
        return this.toGregorian(hours, 0);
    }

    public QCDate nextDate() {
        int dayNumber = QCDate.dayNumber(this);
        QCDate next = QCDate.dateOfDayNumber(dayNumber + 1);
        return next;
    }

    public String toString() {
        String str = "QCDate:" + this.month + "/" + this.day + "/" + this.year;
        return str;
    }
}

