/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.util;

import com.metamatrix.console.util.QCDate;
import com.metamatrix.console.util.QCGregorianCalendar;
import com.metamatrix.console.util.QCTime;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Date;
import java.util.GregorianCalendar;

public class QCDateTime
implements Serializable {
    private QCDate date;
    private QCTime time;

    public QCDateTime(QCDate aDate, QCTime aTime) {
        this.date = aDate;
        this.time = aTime;
    }

    public QCDateTime(GregorianCalendar dt, boolean ignoreTime) {
        this(new QCDate(dt), ignoreTime ? null : new QCTime(dt.get(11), dt.get(12), dt.get(13)));
    }

    public QCDateTime(QCDate aDate) {
        this(aDate, null);
    }

    public QCDateTime(QCTime aTime) {
        this(null, aTime);
    }

    public QCDateTime(Date dt, boolean ignoreTime) {
        QCGregorianCalendar greg = new QCGregorianCalendar();
        greg.setTimeInMillis(dt.getTime());
        this.date = new QCDate(dt);
        this.time = null;
        if (!ignoreTime) {
            this.time = new QCTime(greg.get(11), greg.get(12), greg.get(13));
        }
    }

    public QCDateTime(Date dt, boolean ignoreTime, boolean ignoreSeconds) {
        this(dt, ignoreTime);
        if (!ignoreTime && ignoreSeconds) {
            this.time.zeroOutSeconds();
        }
    }

    public QCDate getDate() {
        return this.date;
    }

    public QCTime getTime() {
        return this.time;
    }

    public boolean equals(QCDateTime anotherDateTime) {
        if (this.time == null && anotherDateTime.time != null) {
            return false;
        }
        if (this.time != null && anotherDateTime.time == null) {
            return false;
        }
        if (this.time == null && anotherDateTime.time == null) {
            return this.date.equals(anotherDateTime.date);
        }
        return this.date.equals(anotherDateTime.date) && this.time.equals(anotherDateTime.time);
    }

    public boolean isGreaterThan(QCDateTime anotherDateTime) {
        if (this.time == null && anotherDateTime.time != null) {
            return this.date.isGreaterThan(anotherDateTime.date);
        }
        if (this.time != null && anotherDateTime.time == null) {
            return this.date.isGreaterThan(anotherDateTime.date);
        }
        if (this.time == null && anotherDateTime.time == null) {
            return this.date.isGreaterThan(anotherDateTime.date);
        }
        return this.date.isGreaterThan(anotherDateTime.date) || this.date.equals(anotherDateTime.date) && this.time.isGreaterThan(anotherDateTime.time);
    }

    public boolean isLessThan(QCDateTime anotherDateTime) {
        if (this.time == null && anotherDateTime.time != null) {
            return this.date.isLessThan(anotherDateTime.date);
        }
        if (this.time != null && anotherDateTime.time == null) {
            return this.date.isLessThan(anotherDateTime.date);
        }
        if (this.time == null && anotherDateTime.time == null) {
            return this.date.isLessThan(anotherDateTime.date);
        }
        return this.date.isLessThan(anotherDateTime.date) || this.date.equals(anotherDateTime.date) && this.time.isLessThan(anotherDateTime.time);
    }

    public static int intervalNumber(QCDateTime startingDT, QCDateTime curDT, int blockInt) {
        if (startingDT.getTime() == null || curDT.getTime() == null) {
            return -1;
        }
        if (60 % blockInt != 0) {
            return -1;
        }
        int dayDiff = 0;
        if (startingDT.getDate() != null && curDT.getDate() != null) {
            dayDiff = QCDate.dayNumber(curDT.getDate()) - QCDate.dayNumber(startingDT.getDate());
        }
        int startingTimeMinutes = 60 * startingDT.getTime().getHour() + startingDT.getTime().getMinute();
        int intervalOfStartingDay = startingTimeMinutes / blockInt + 1;
        int curTimeMinutes = 60 * curDT.getTime().getHour() + curDT.getTime().getMinute();
        int intervalOfCurDay = curTimeMinutes / blockInt + 1;
        int intervalsPerDay = 24 * (60 / blockInt);
        return 1 + (intervalOfCurDay - intervalOfStartingDay) + intervalsPerDay * dayDiff;
    }

    public QCDateTime addSeconds(int numSeconds) {
        int NUM_SECONDS_PER_DAY = 86400;
        int numSecondsCurDay = this.time.getSecond() + 60 * this.time.getMinute() + 3600 * this.time.getHour();
        int dayDelta = 0;
        numSecondsCurDay += numSeconds;
        if (numSeconds >= 0) {
            while (numSecondsCurDay >= NUM_SECONDS_PER_DAY) {
                ++dayDelta;
                numSecondsCurDay -= NUM_SECONDS_PER_DAY;
            }
        } else {
            while (numSecondsCurDay < 0) {
                --dayDelta;
                numSecondsCurDay += NUM_SECONDS_PER_DAY;
            }
        }
        int newDayNumber = QCDate.dayNumber(this.date) + dayDelta;
        QCDate newDate = QCDate.dateOfDayNumber(newDayNumber);
        QCTime newTime = new QCTime(numSecondsCurDay);
        return new QCDateTime(newDate, newTime);
    }

    public GregorianCalendar toGregorian() {
        GregorianCalendar cal = null;
        if (this.date != null) {
            cal = this.time == null ? new GregorianCalendar(this.date.getYear(), this.date.getMonth() - 1, this.date.getDay()) : new GregorianCalendar(this.date.getYear(), this.date.getMonth() - 1, this.date.getDay(), this.time.getHour(), this.time.getMinute(), this.time.getSecond());
        }
        return cal;
    }

    public GregorianCalendar setGregorian() {
        return this.toGregorian();
    }

    public Timestamp toTimestamp() {
        GregorianCalendar cal = this.toGregorian();
        QCGregorianCalendar gCal = new QCGregorianCalendar(cal);
        long millis = gCal.getTimeInMillis() + (long)this.getTime().fractionalSecondAsMillis();
        Timestamp ts = new Timestamp(millis);
        return ts;
    }

    public QCDateTime adjustForStartOfSpan() {
        QCDate newDate = null;
        QCTime newTime = null;
        if (this.date != null || this.time != null) {
            if (this.date == null) {
                newTime = this.time;
                newDate = new QCDate(new Date());
            } else if (this.time == null) {
                newDate = this.date;
                newTime = new QCTime(0, 0);
            } else {
                newTime = this.time;
                newDate = this.date;
            }
        }
        QCDateTime newDateTime = new QCDateTime(newDate, newTime);
        return newDateTime;
    }

    public QCDateTime adjustForEndOfSpan() {
        QCDate newDate = null;
        QCTime newTime = null;
        if (this.date != null || this.time != null) {
            if (this.date == null) {
                newTime = this.time;
                newDate = new QCDate(new Date());
            } else if (this.time == null) {
                newDate = this.date;
                newTime = new QCTime(23, 59, 59.999);
            } else {
                newTime = this.time;
                newDate = this.date;
            }
        }
        QCDateTime newDateTime = new QCDateTime(newDate, newTime);
        return newDateTime;
    }

    public static QCDateTime dateTimeOfInterval(QCDateTime startingDT, int blockInt, int intervalNum) {
        if (60 % blockInt != 0) {
            return null;
        }
        return startingDT.addSeconds((intervalNum - 1) * (blockInt * 60));
    }

    public static int minutesNumber(QCDateTime aDateTime) {
        int dayNumber = QCDate.dayNumber(aDateTime.getDate());
        int minutesNumberInDay = QCTime.minutesNumber(aDateTime.getTime());
        int totalMinutes = (dayNumber - 1) * 1440 + minutesNumberInDay;
        return totalMinutes;
    }

    public static int roundedMinutesNumber(QCDateTime aDateTime) {
        int dayNumber = QCDate.dayNumber(aDateTime.getDate());
        int minutesNumberInDay = QCTime.roundedMinutesNumber(aDateTime.getTime());
        int totalMinutes = (dayNumber - 1) * 1440 + minutesNumberInDay;
        return totalMinutes;
    }

    public static int secondsNumber(QCDateTime aDateTime) {
        int dayNumber = QCDate.dayNumber(aDateTime.getDate());
        int secondsNumberInDay = QCTime.iSecondsNumber(aDateTime.getTime());
        int totalSeconds = (dayNumber - 1) * 86400 + secondsNumberInDay;
        return totalSeconds;
    }

    public String toString() {
        String str = "QCDateTime: date=" + this.date + ",time=" + this.time;
        return str;
    }

    public String toMonthDayYearHourMinuteString() {
        String str = "";
        if (this.date != null) {
            str = str + this.date.toMonthDayYearString();
            if (this.time != null) {
                str = str + " ";
            }
        }
        if (this.time != null) {
            str = str + this.time.toHourMinuteString();
        }
        return str;
    }
}

