/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.util;

import com.metamatrix.console.util.StaticUtilities;
import java.io.Serializable;

public class QCTime
implements Serializable {
    private int hour;
    private int minute;
    private int second;
    private double secondsWithFraction;

    public QCTime(int anHour, int aMinute, int aSecond) {
        if (anHour < 0 || anHour > 23 || aMinute < 0 || aMinute > 59 || aSecond < 0 || aSecond > 59) {
            throw new RuntimeException("illegal param passed into QCTime constructor");
        }
        this.hour = anHour;
        this.minute = aMinute;
        this.second = aSecond;
        this.secondsWithFraction = aSecond;
    }

    public QCTime(int anHour, int aMinute, double aSecond) {
        if (anHour < 0 || anHour > 23 || aMinute < 0 || aMinute > 59 || aSecond < 0.0 || aSecond >= 60.0) {
            throw new RuntimeException("illegal param passed into QCTime constructor");
        }
        this.hour = anHour;
        this.minute = aMinute;
        this.secondsWithFraction = aSecond;
        this.second = (int)this.secondsWithFraction;
    }

    public QCTime(int anHour, int aMinute) {
        this(anHour, aMinute, 0);
    }

    public QCTime(int totSeconds) {
        int NUM_SECONDS_PER_DAY = 86400;
        if (totSeconds >= NUM_SECONDS_PER_DAY || totSeconds < 0) {
            throw new RuntimeException("illegal param passed into QCTime constructor");
        }
        this.hour = totSeconds / 3600;
        this.minute = (totSeconds -= this.hour * 60 * 60) / 60;
        this.secondsWithFraction = totSeconds -= this.minute * 60;
        this.second = totSeconds;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getSecond() {
        return this.second;
    }

    public double getSecondsWithFraction() {
        return this.secondsWithFraction;
    }

    public void zeroOutSeconds() {
        this.second = 0;
        this.secondsWithFraction = 0.0;
    }

    public boolean equals(QCTime anotherTime) {
        return this.hour == anotherTime.hour && this.minute == anotherTime.minute && this.secondsWithFraction == anotherTime.secondsWithFraction;
    }

    public boolean isGreaterThan(QCTime anotherTime) {
        double temp2;
        double temp1 = QCTime.dSecondsNumber(this);
        return temp1 > (temp2 = QCTime.dSecondsNumber(anotherTime));
    }

    public boolean isLessThan(QCTime anotherTime) {
        double temp2;
        double temp1 = QCTime.dSecondsNumber(this);
        return temp1 < (temp2 = QCTime.dSecondsNumber(anotherTime));
    }

    public static int iSecondsNumber(QCTime aTime) {
        return aTime.hour * 60 * 60 + aTime.minute * 60 + aTime.second;
    }

    public static double dSecondsNumber(QCTime aTime) {
        return (double)(aTime.hour * 60 * 60 + aTime.minute * 60) + aTime.secondsWithFraction;
    }

    public static int minutesNumber(QCTime aTime) {
        return aTime.hour * 60 + aTime.minute;
    }

    public static int roundedMinutesNumber(QCTime aTime) {
        int min = aTime.hour * 60 + aTime.minute;
        if (aTime.second >= 30) {
            ++min;
        }
        return min;
    }

    public String toHourMinuteString() {
        String hourString = new Integer(this.hour).toString();
        if (this.hour < 10) {
            hourString = "0" + hourString;
        }
        String minuteString = new Integer(this.minute).toString();
        if (this.minute < 10) {
            minuteString = "0" + minuteString;
        }
        return hourString + ":" + minuteString;
    }

    public String toHourMinuteAMPMString() {
        int ourHour = this.hour;
        String suffix = "AM";
        if (ourHour == 0) {
            ourHour = 12;
        } else {
            if (ourHour >= 12) {
                suffix = "PM";
            }
            if (ourHour >= 13) {
                ourHour -= 12;
            }
        }
        String minuteString = new Integer(this.minute).toString();
        if (this.minute < 10) {
            minuteString = "0" + minuteString;
        }
        String str = ourHour + ":" + minuteString + suffix;
        return str;
    }

    public String toHourMinuteSecondMillisecondString() {
        String str = "";
        if (this.hour < 10) {
            str = str + "0";
        }
        str = str + this.hour + ":";
        if (this.minute < 10) {
            str = str + "0";
        }
        str = str + this.minute + ":";
        if (this.second < 10) {
            str = str + "0";
        }
        str = str + StaticUtilities.roundToNumDecimalPlaces(this.secondsWithFraction, 3);
        return str;
    }

    public int fractionalSecondAsMillis() {
        double fraction = this.secondsWithFraction - (double)this.second;
        int millis = (int)(fraction * 1000.0);
        if (millis > 999) {
            millis = 999;
        } else if (millis < 0) {
            millis = 0;
        }
        return millis;
    }

    public String toString() {
        String str = "QCTime: " + this.hour + ":" + this.minute + ":" + this.second + "(" + this.secondsWithFraction + ")";
        return str;
    }
}

