/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.util;

import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.properties.UnmodifiableProperties;
import com.metamatrix.common.util.ApplicationInfo;
import com.metamatrix.console.util.ExternalException;
import com.metamatrix.console.util.SavedUDDIRegistryInfo;
import com.metamatrix.console.util.StaticQuickSorter;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.toolbox.preference.UserPreferences;
import java.awt.Cursor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class StaticProperties {
    private static final String DEFAULT_FILENAME = "preferences.prop";
    private static final String BLANK = "";
    public static final String DEFAULT_USERNAME = "default.username";
    private static final String ERR_LOG_FILE_PROP_NAME = "metamatrix.stderr.file";
    private static final String OUT_LOG_FILE_PROP_NAME = "metamatrix.stdout.file";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    private static List urls = null;
    private static String currentSystemURL;
    private static File logDirectory;
    public static final String DATA_SESSION = "data.session";
    public static final String DATA_SUMMARY = "data.summary";
    public static final String DATA_QUERY = "data.query";
    public static final String DATA_TRANSACTION = "data.transaction";
    public static final String DATA_SYSLOG = "data.syslog";
    public static final String DATA_RESOURCE_POOLS = "data.resource_pools";
    public static final String REFRESH_ENABLED_SESSION = "refresh_enabled.session";
    public static final String REFRESH_RATE_SESSION = "refresh_rate.session";
    public static final String REFRESH_ENABLED_QUERY = "refresh_enabled.query";
    public static final String REFRESH_RATE_QUERY = "refresh_rate.query";
    public static final String REFRESH_ENABLED_SUMMARY = "refresh_enabled.summary";
    public static final String REFRESH_RATE_SUMMARY = "refresh_rate.summary";
    public static final String REFRESH_ENABLED_TRANSACTION = "refresh_enabled.transaction";
    public static final String REFRESH_RATE_TRANSACTION = "refresh_rate.transaction";
    public static final String REFRESH_ENABLED_SYSLOG = "refresh_enabled.syslog";
    public static final String REFRESH_RATE_SYSLOG = "refresh_rate.syslog";
    public static final String REFRESH_ENABLED_RESOURCE_POOLS = "refresh_enabled.resource_pools";
    public static final String REFRESH_RATE_RESOURCE_POOLS = "refresh_rate.resource_pools";
    public static final String CONN_URL = "connection.url.name.";
    public static final String CONN_DEFAULT = "connection_default";
    public static final String CONN_USE_LAST_URL = "connection.use_last_url_as_default";
    public static final String DATEFORMAT = "dateformat";
    public static final String TIMEFORMAT = "timeformat";
    public static final String UDDI_REGISTRY_NAME = "uddi.registry.name.";
    public static final int UDDI_REGISTRY_NAME_STR_LEN;
    public static final String UDDI_REGISTRY_USER = "uddi.registry.user.";
    public static final int UDDI_REGISTRY_USER_STR_LEN;
    public static final String UDDI_REGISTRY_HOST = "uddi.registry.host.";
    public static final int UDDI_REGISTRY_HOST_STR_LEN;
    public static final String UDDI_REGISTRY_PORT = "uddi.registry.port.";
    public static final int UDDI_REGISTRY_PORT_STR_LEN;
    public static final String MONDDCCYY = "MMM dd, yyyy";
    public static final String DDMONCCYY = "dd MMM yyyy";
    public static final String MMDDYY = "MM/dd/yy";
    public static final String DDMMYY = "dd/MM/yy";
    public static final String MM_DD_YY = "MM.dd.yy";
    public static final String DD_MM_YY = "dd.MM.yy";
    public static final String HHMMSS = "hh:mm:ss a";
    public static final String MIL_HHMMSS = "kk:mm:ss";
    public static final String GENERIC_LOG = "CONSOLE";
    public static final Cursor CURSOR_WAIT;
    public static final Cursor CURSOR_DEFAULT;
    public static final int MIN_REFRESH_RATE = 15;
    public static final int MAX_REFRESH_RATE = 3600;
    public static boolean summaryEnabled;
    public static int summaryRefreshRate;
    public static boolean sessionEnabled;
    public static int sessionRefreshRate;
    protected static boolean queryEnabled;
    protected static int queryRefreshRate;
    protected static boolean transactionEnabled;
    protected static int transactionRefreshRate;
    protected static boolean syslogEnabled;
    public static int syslogRefreshRate;
    public static boolean resourcePoolsEnabled;
    public static int resourcePoolsRefreshRate;
    private static String newDefaultURL;
    private static boolean useLastURLAsDefault;
    private static int numUDDIRegistries;
    static ApplicationInfo build;
    private static final String SIXTY = "60";

    public static String getVersion() {
        return build.getReleaseNumber() + ':' + build.getBuildDate();
    }

    public static String getDefaultURL() {
        return StaticProperties.getProperty(CONN_DEFAULT);
    }

    public static void setURLs(List theURLs, String defaultURL, boolean useLastLogin) {
        StaticProperties.setURLs(theURLs);
        newDefaultURL = defaultURL;
        useLastURLAsDefault = useLastLogin;
    }

    public static void setURLs(List theURLs) {
        Properties properties = StaticProperties.getProperties();
        ArrayList<String> connectionKeys = new ArrayList<String>();
        for (String string : properties.keySet()) {
            if (!string.startsWith(CONN_URL)) continue;
            connectionKeys.add(string);
        }
        for (String string : connectionKeys) {
            UserPreferences.getInstance().removeValue(string);
        }
        urls = theURLs;
        Iterator it = urls.iterator();
        int i = 1;
        while (it.hasNext()) {
            String url = (String)it.next();
            StringBuffer stringBuffer = new StringBuffer(CONN_URL);
            stringBuffer.append(i);
            StaticProperties.setProperty(stringBuffer.toString(), url);
            ++i;
        }
        StaticProperties.sortURLs();
    }

    public static void setCurrentURL(String systemURL) {
        currentSystemURL = systemURL;
        if (StaticProperties.getUseLastURLAsDefault()) {
            StaticProperties.setDefaultURL(systemURL);
        }
    }

    public static String getCurrentURL() {
        return currentSystemURL;
    }

    public static List getURLsCopy() {
        if (urls == null) {
            urls = new ArrayList(0);
        }
        ArrayList copy = new ArrayList(urls);
        return copy;
    }

    public static SavedUDDIRegistryInfo[] getUDDIRegistryInfo() {
        HashMap<Integer, SavedUDDIRegistryInfo> infoMap = new HashMap<Integer, SavedUDDIRegistryInfo>();
        Properties properties = StaticProperties.getProperties();
        for (Map.Entry<Object, Object> me : properties.entrySet()) {
            SavedUDDIRegistryInfo info;
            Integer index;
            String remainder;
            String string = (String)me.getKey();
            if (string.startsWith(UDDI_REGISTRY_NAME)) {
                remainder = string.substring(UDDI_REGISTRY_NAME_STR_LEN);
                index = null;
                try {
                    index = new Integer(remainder);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (index == null) continue;
                String name = (String)me.getValue();
                info = (SavedUDDIRegistryInfo)infoMap.get(index);
                if (info == null) {
                    info = new SavedUDDIRegistryInfo(name, null, null, null);
                    infoMap.put(index, info);
                    continue;
                }
                info.setName(name);
                continue;
            }
            if (string.startsWith(UDDI_REGISTRY_USER)) {
                remainder = string.substring(UDDI_REGISTRY_USER_STR_LEN);
                index = null;
                try {
                    index = new Integer(remainder);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (index == null) continue;
                String user = (String)me.getValue();
                info = (SavedUDDIRegistryInfo)infoMap.get(index);
                if (info == null) {
                    info = new SavedUDDIRegistryInfo(null, user, null, null);
                    infoMap.put(index, info);
                    continue;
                }
                info.setUserName(user);
                continue;
            }
            if (string.startsWith(UDDI_REGISTRY_HOST)) {
                remainder = string.substring(UDDI_REGISTRY_HOST_STR_LEN);
                index = null;
                try {
                    index = new Integer(remainder);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (index == null) continue;
                String host = (String)me.getValue();
                info = (SavedUDDIRegistryInfo)infoMap.get(index);
                if (info == null) {
                    info = new SavedUDDIRegistryInfo(null, null, host, null);
                    infoMap.put(index, info);
                    continue;
                }
                info.setHost(host);
                continue;
            }
            if (!string.startsWith(UDDI_REGISTRY_PORT)) continue;
            remainder = string.substring(UDDI_REGISTRY_PORT_STR_LEN);
            index = null;
            try {
                index = new Integer(remainder);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (index == null) continue;
            String port = (String)me.getValue();
            info = (SavedUDDIRegistryInfo)infoMap.get(index);
            if (info == null) {
                info = new SavedUDDIRegistryInfo(null, null, null, port);
                infoMap.put(index, info);
                continue;
            }
            info.setPort(port);
        }
        HashMap<Object, SavedUDDIRegistryInfo> revisedInfoMap = new HashMap<Object, SavedUDDIRegistryInfo>();
        for (Map.Entry<Object, Object> entry : infoMap.entrySet()) {
            SavedUDDIRegistryInfo info = (SavedUDDIRegistryInfo)entry.getValue();
            if (info.getUserName() == null || info.getHost() == null || info.getPort() == null) continue;
            revisedInfoMap.put(entry.getKey(), info);
        }
        SavedUDDIRegistryInfo[] savedUDDIRegistryInfoArray = new SavedUDDIRegistryInfo[revisedInfoMap.size()];
        int[] indices = new int[savedUDDIRegistryInfoArray.length];
        Iterator<Map.Entry<Object, Object>> it = revisedInfoMap.entrySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            Map.Entry<Object, Object> me = it.next();
            Integer intKey = (Integer)me.getKey();
            indices[i] = intKey;
            savedUDDIRegistryInfoArray[i] = (SavedUDDIRegistryInfo)me.getValue();
            ++i;
        }
        boolean done = false;
        while (!done) {
            done = true;
            for (int i2 = 0; i2 < indices.length - 1; ++i2) {
                if (indices[i2] <= indices[i2 + 1]) continue;
                done = false;
                int tempInt = indices[i2];
                indices[i2] = indices[i2 + 1];
                indices[i2 + 1] = tempInt;
                SavedUDDIRegistryInfo tempInfo = savedUDDIRegistryInfoArray[i2];
                savedUDDIRegistryInfoArray[i2] = savedUDDIRegistryInfoArray[i2 + 1];
                savedUDDIRegistryInfoArray[i2 + 1] = tempInfo;
            }
        }
        if (numUDDIRegistries < 0) {
            numUDDIRegistries = savedUDDIRegistryInfoArray.length;
        }
        return savedUDDIRegistryInfoArray;
    }

    /*
     * WARNING - void declaration
     */
    public static void setUDDIRegistryInfo(SavedUDDIRegistryInfo[] info) {
        void var4_8;
        Properties properties = StaticProperties.getProperties();
        ArrayList<String> tempList = new ArrayList<String>(properties.size());
        for (String string : properties.keySet()) {
            tempList.add(string);
        }
        for (String string : tempList) {
            if (!string.startsWith(UDDI_REGISTRY_NAME) && !string.startsWith(UDDI_REGISTRY_USER) && !string.startsWith(UDDI_REGISTRY_HOST) && !string.startsWith(UDDI_REGISTRY_PORT)) continue;
            UserPreferences.getInstance().removeValue(string);
        }
        boolean bl = false;
        while (var4_8 < info.length) {
            void index = var4_8 + true;
            String key = UDDI_REGISTRY_NAME + (int)index;
            StaticProperties.setProperty(key, info[var4_8].getName());
            key = UDDI_REGISTRY_USER + (int)index;
            StaticProperties.setProperty(key, info[var4_8].getUserName());
            key = UDDI_REGISTRY_HOST + (int)index;
            StaticProperties.setProperty(key, info[var4_8].getHost());
            key = UDDI_REGISTRY_PORT + (int)index;
            StaticProperties.setProperty(key, info[var4_8].getPort());
            ++var4_8;
        }
    }

    public static Properties getProperties() {
        return UserPreferences.getInstance().getProperties();
    }

    public static void loadBootStrap() throws ExternalException {
        String msg;
        PrintStream stream;
        File f;
        if (System.getProperty(OUT_LOG_FILE_PROP_NAME) != null) {
            f = new File(System.getProperty(OUT_LOG_FILE_PROP_NAME));
            try {
                f.createNewFile();
                stream = new PrintStream(new FileOutputStream(f));
                System.setOut(stream);
            }
            catch (IOException e) {
                msg = "Invalid value for property metamatrix.stdout.file = " + System.getProperty(OUT_LOG_FILE_PROP_NAME);
                LogManager.logError((String)"CONFIGURATION", (Throwable)e, (String)msg);
            }
        }
        if (System.getProperty(ERR_LOG_FILE_PROP_NAME) != null) {
            f = new File(System.getProperty(ERR_LOG_FILE_PROP_NAME));
            try {
                f.createNewFile();
                stream = new PrintStream(new FileOutputStream(f));
                System.setErr(stream);
            }
            catch (IOException e) {
                msg = "Invalid value for property metamatrix.stderr.file = " + System.getProperty(ERR_LOG_FILE_PROP_NAME);
                LogManager.logError((String)"CONFIGURATION", (Throwable)e, (String)msg);
            }
        }
        if (System.getProperty("prefFile") != null) {
            StaticProperties.loadBootStrap(System.getProperty("prefFile"));
        } else {
            StaticProperties.loadBootStrap(DEFAULT_FILENAME);
        }
    }

    public static void loadBootStrap(String fileName) throws ExternalException {
        Properties properties = StaticProperties.getProperties();
        StaticProperties.setupURLS(properties);
        if (!properties.contains(DATEFORMAT)) {
            StaticProperties.setProperty(DATEFORMAT, MONDDCCYY);
        }
        if (!properties.contains(TIMEFORMAT)) {
            StaticProperties.setProperty(TIMEFORMAT, HHMMSS);
        }
        if (properties.getProperty(REFRESH_RATE_SESSION) == null) {
            StaticProperties.setProperty(REFRESH_RATE_SESSION, SIXTY);
        }
        if (properties.getProperty(REFRESH_RATE_QUERY) == null) {
            StaticProperties.setProperty(REFRESH_RATE_QUERY, SIXTY);
        }
        if (properties.getProperty(REFRESH_RATE_SUMMARY) == null) {
            StaticProperties.setProperty(REFRESH_RATE_SUMMARY, SIXTY);
        }
        if (properties.getProperty(REFRESH_RATE_TRANSACTION) == null) {
            StaticProperties.setProperty(REFRESH_RATE_TRANSACTION, SIXTY);
        }
        if (properties.getProperty(REFRESH_RATE_SYSLOG) == null) {
            StaticProperties.setProperty(REFRESH_RATE_SYSLOG, SIXTY);
        }
        if (properties.getProperty(REFRESH_RATE_RESOURCE_POOLS) == null) {
            StaticProperties.setProperty(REFRESH_RATE_RESOURCE_POOLS, SIXTY);
        }
        if (properties.getProperty(REFRESH_ENABLED_SESSION) == null) {
            StaticProperties.setProperty(REFRESH_ENABLED_SESSION, SIXTY);
        }
        if (properties.getProperty(REFRESH_ENABLED_QUERY) == null) {
            StaticProperties.setProperty(REFRESH_ENABLED_QUERY, SIXTY);
        }
        if (properties.getProperty(REFRESH_ENABLED_SUMMARY) == null) {
            StaticProperties.setProperty(REFRESH_ENABLED_SUMMARY, SIXTY);
        }
        if (properties.getProperty(REFRESH_ENABLED_TRANSACTION) == null) {
            StaticProperties.setProperty(REFRESH_ENABLED_TRANSACTION, SIXTY);
        }
        if (properties.getProperty(REFRESH_ENABLED_SYSLOG) == null) {
            StaticProperties.setProperty(REFRESH_ENABLED_SYSLOG, SIXTY);
        }
        if (properties.getProperty(REFRESH_ENABLED_RESOURCE_POOLS) == null) {
            StaticProperties.setProperty(REFRESH_ENABLED_RESOURCE_POOLS, SIXTY);
        }
    }

    private static void setupURLS(Properties properties) {
        urls = new Vector(9);
        for (String string : properties.keySet()) {
            if (!string.startsWith(CONN_URL)) continue;
            String url = properties.getProperty(string);
            urls.add(url);
        }
        StaticProperties.sortURLs();
        newDefaultURL = properties.getProperty(CONN_DEFAULT);
        String boolString = properties.getProperty(CONN_USE_LAST_URL);
        if (boolString != null) {
            StaticProperties.setUseLastURLAsDefault(Boolean.valueOf(boolString));
        } else if (newDefaultURL == null || newDefaultURL.length() == 0) {
            StaticProperties.setUseLastURLAsDefault(true);
        }
    }

    public static void setUseLastURLAsDefault(boolean flag) {
        useLastURLAsDefault = flag;
    }

    public static boolean getUseLastURLAsDefault() {
        return useLastURLAsDefault;
    }

    private static void sortURLs() {
        Collection sortedURLs = StaticQuickSorter.quickStringCollectionSort(urls);
        urls = new ArrayList(sortedURLs);
    }

    public static void loadProperties() {
        StaticProperties.applyProperties(StaticProperties.getProperties());
    }

    public static void applyRefreshProperties(Properties props) {
        sessionEnabled = StaticProperties.getEnabledState(REFRESH_ENABLED_SESSION, props);
        sessionRefreshRate = StaticProperties.getIntegerValue(REFRESH_RATE_SESSION, props);
        summaryEnabled = StaticProperties.getEnabledState(REFRESH_ENABLED_SUMMARY, props);
        summaryRefreshRate = StaticProperties.getIntegerValue(REFRESH_RATE_SUMMARY, props);
        queryEnabled = StaticProperties.getEnabledState(REFRESH_ENABLED_QUERY, props);
        queryRefreshRate = StaticProperties.getIntegerValue(REFRESH_RATE_QUERY, props);
        transactionEnabled = StaticProperties.getEnabledState(REFRESH_ENABLED_TRANSACTION, props);
        transactionRefreshRate = StaticProperties.getIntegerValue(REFRESH_RATE_TRANSACTION, props);
        syslogEnabled = StaticProperties.getEnabledState(REFRESH_ENABLED_SYSLOG, props);
        syslogRefreshRate = StaticProperties.getIntegerValue(REFRESH_RATE_SYSLOG, props);
        resourcePoolsEnabled = StaticProperties.getEnabledState(REFRESH_ENABLED_RESOURCE_POOLS, props);
        resourcePoolsRefreshRate = StaticProperties.getIntegerValue(REFRESH_RATE_RESOURCE_POOLS, props);
    }

    private static boolean getEnabledState(String sPropertyKey, Properties props) {
        boolean bEnabledState = false;
        String sValue = props.getProperty(sPropertyKey);
        if (sValue != null && !sValue.trim().equals(BLANK)) {
            if (sValue.equals(TRUE)) {
                bEnabledState = true;
            } else if (sValue.equals(FALSE)) {
                bEnabledState = false;
            }
        }
        return bEnabledState;
    }

    private static int getIntegerValue(String sPropertyKey, Properties props) {
        int iValue = 0;
        String sValue = props.getProperty(sPropertyKey);
        if (sValue != null && !sValue.trim().equals(BLANK)) {
            iValue = new Integer(sValue);
        }
        return iValue;
    }

    public static void setDefaultURL(String url) {
        newDefaultURL = url;
        StaticProperties.setProperty(CONN_DEFAULT, url);
    }

    public static boolean isDefaultURL(String url) {
        return url.equalsIgnoreCase(newDefaultURL);
    }

    public static void applyProperties(Properties prop) {
        StaticProperties.applyRefreshProperties(prop);
        boolean unmodifiable = prop instanceof UnmodifiableProperties;
        StringBuffer sbDT = new StringBuffer();
        if (prop.getProperty(DATEFORMAT) != null && !prop.getProperty(DATEFORMAT).equals(BLANK)) {
            sbDT.append(prop.getProperty(DATEFORMAT));
        } else {
            if (!unmodifiable) {
                prop.setProperty(DATEFORMAT, MONDDCCYY);
            }
            sbDT.append(MONDDCCYY);
        }
        sbDT.append(" ");
        if (prop.getProperty(TIMEFORMAT) != null && !prop.getProperty(TIMEFORMAT).equals(BLANK)) {
            sbDT.append(prop.getProperty(TIMEFORMAT));
        } else {
            if (!unmodifiable) {
                prop.setProperty(DATEFORMAT, MONDDCCYY);
            }
            sbDT.append(HHMMSS);
        }
        StaticUtilities.setDateFormat(sbDT.toString());
    }

    public static void setProperty(String key, String value) {
        UserPreferences.getInstance().setValue(key, value);
    }

    public static String getProperty(String key) {
        return UserPreferences.getInstance().getProperties().getProperty(key);
    }

    public static void setUserName(String sUserName) {
        StaticProperties.setProperty(DEFAULT_USERNAME, sUserName);
    }

    public static void saveProperties() throws ExternalException {
        boolean useLastURL = StaticProperties.getUseLastURLAsDefault();
        if (useLastURL) {
            StaticProperties.setProperty(CONN_DEFAULT, StaticProperties.getCurrentURL());
        } else {
            StaticProperties.setProperty(CONN_DEFAULT, newDefaultURL);
        }
        StaticProperties.setProperty(CONN_USE_LAST_URL, new Boolean(useLastURL).toString());
        try {
            UserPreferences.getInstance().saveChanges();
            StaticProperties.loadProperties();
        }
        catch (Exception e) {
            throw new ExternalException("Error Saving Preference File", e);
        }
    }

    public static boolean getSummaryRefreshEnabled() {
        return summaryEnabled;
    }

    public static int getSummaryRefreshRate() {
        return summaryRefreshRate;
    }

    public static boolean getSessionRefreshEnabled() {
        return sessionEnabled;
    }

    public static int getSessionRefreshRate() {
        return sessionRefreshRate;
    }

    public static boolean getQueryRefreshEnabled() {
        return queryEnabled;
    }

    public static int getQueryRefreshRate() {
        return queryRefreshRate;
    }

    public static boolean getTransactionRefreshEnabled() {
        return transactionEnabled;
    }

    public static int getTransactionRefreshRate() {
        return transactionRefreshRate;
    }

    public static boolean getSysLogRefreshEnabled() {
        return syslogEnabled;
    }

    public static int getSysLogRefreshRate() {
        return syslogRefreshRate;
    }

    public static boolean getResourcePoolsRefreshEnabled() {
        return resourcePoolsEnabled;
    }

    public static int getResourcePoolsRefreshRate() {
        return resourcePoolsRefreshRate;
    }

    public static void setLogDirectory(File file) {
        logDirectory = file;
    }

    public static File getLogDirectory() {
        return logDirectory;
    }

    static {
        logDirectory = null;
        UDDI_REGISTRY_NAME_STR_LEN = UDDI_REGISTRY_NAME.length();
        UDDI_REGISTRY_USER_STR_LEN = UDDI_REGISTRY_USER.length();
        UDDI_REGISTRY_HOST_STR_LEN = UDDI_REGISTRY_HOST.length();
        UDDI_REGISTRY_PORT_STR_LEN = UDDI_REGISTRY_PORT.length();
        CURSOR_WAIT = Cursor.getPredefinedCursor(3);
        CURSOR_DEFAULT = Cursor.getPredefinedCursor(0);
        summaryEnabled = false;
        summaryRefreshRate = 0;
        sessionEnabled = false;
        sessionRefreshRate = 0;
        queryEnabled = false;
        queryRefreshRate = 0;
        transactionEnabled = false;
        transactionRefreshRate = 0;
        syslogEnabled = false;
        syslogRefreshRate = 0;
        resourcePoolsEnabled = false;
        resourcePoolsRefreshRate = 0;
        newDefaultURL = null;
        useLastURLAsDefault = true;
        numUDDIRegistries = -1;
        build = ApplicationInfo.getInstance();
    }
}

