/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.util;

import com.metamatrix.console.util.Compares;
import com.metamatrix.console.util.DefaultComparer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class StaticQuickSorter {
    public static Object[] quickSort(Object[] array, Compares comparator) {
        Object[] newArray = new Object[array.length];
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = array[i];
        }
        if (newArray.length > 1) {
            StaticQuickSorter.sort(newArray, 0, newArray.length - 1, comparator);
        }
        return newArray;
    }

    public static Object[] quickSort(Object[] array) {
        return StaticQuickSorter.quickSort(array, (Compares)new DefaultComparer());
    }

    public static Object[] quickSort(List list, Compares comparator) {
        Object[] array = new Object[list.size()];
        Iterator it = list.iterator();
        int loc = 0;
        while (it.hasNext()) {
            array[loc] = it.next();
            ++loc;
        }
        return StaticQuickSorter.quickSort(array, comparator);
    }

    public static Object[] quickSort(List list) {
        return StaticQuickSorter.quickSort(list, (Compares)new DefaultComparer());
    }

    public static String[] quickStringSort(String[] array) {
        int i;
        String[] result = new String[array.length];
        Object[] obj = new Object[array.length];
        for (i = 0; i < array.length; ++i) {
            obj[i] = array[i];
        }
        obj = StaticQuickSorter.quickSort(obj);
        for (i = 0; i < obj.length; ++i) {
            result[i] = (String)obj[i];
        }
        return result;
    }

    public static Collection quickStringCollectionSort(Collection strings) {
        Object[] unsorted = new Object[strings.size()];
        Iterator it = strings.iterator();
        int i = 0;
        while (it.hasNext()) {
            unsorted[i] = it.next();
            ++i;
        }
        Object[] sorted = StaticQuickSorter.quickSort(unsorted);
        return Arrays.asList(sorted);
    }

    private static void sort(Object[] array, int lo0, int hi0, Compares comparator) {
        int lo = lo0;
        int hi = hi0;
        if (hi0 > lo0) {
            Object mid = array[(lo0 + hi0) / 2];
            while (lo <= hi) {
                while (lo < hi0 && comparator.compare(array[lo], mid) < 0) {
                    ++lo;
                }
                while (hi > lo0 && comparator.compare(array[hi], mid) > 0) {
                    --hi;
                }
                if (lo > hi) continue;
                Object temp = array[hi];
                array[hi] = array[lo];
                array[lo] = temp;
                ++lo;
                --hi;
            }
            if (lo0 < hi) {
                StaticQuickSorter.sort(array, lo0, hi, comparator);
            }
            if (lo < hi0) {
                StaticQuickSorter.sort(array, lo, hi0, comparator);
            }
        }
    }

    public static int sortedStringArrayIndex(String[] array, String string) {
        int loc = -1;
        if (array.length > 0) {
            int low = 0;
            int high = array.length - 1;
            int current = (low + high) / 2;
            boolean continuing = true;
            while (continuing) {
                String curString = array[current];
                int compResult = string.compareToIgnoreCase(curString);
                if (compResult == 0) {
                    loc = current;
                    continuing = false;
                    continue;
                }
                if (high == low) {
                    continuing = false;
                    continue;
                }
                if (compResult < 0) {
                    if (current == 0) {
                        continuing = false;
                        continue;
                    }
                    high = current;
                    current = (low + high) / 2;
                    continue;
                }
                if (current == array.length - 1) {
                    continuing = false;
                    continue;
                }
                low = current == low && low == high - 1 ? high : current;
                current = (low + high) / 2;
            }
        }
        return loc;
    }

    public static int unsortedStringArrayIndex(String[] array, String string) {
        int matchLoc = -1;
        int loc = 0;
        while (matchLoc < 0 && loc < array.length) {
            if (array[loc].equals(string)) {
                matchLoc = loc;
                continue;
            }
            ++loc;
        }
        return matchLoc;
    }

    public static int stringArrayIndex(String[] array, String string) {
        return StaticQuickSorter.sortedStringArrayIndex(array, string);
    }
}

