/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.util;

import java.util.Iterator;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;

public class StaticTableUtilities {
    public static Object[] saveSelections(JTable table, int indexCol) {
        int numRows = table.getModel().getRowCount();
        ListSelectionModel lsm = table.getSelectionModel();
        Vector<Object> v = new Vector<Object>();
        for (int i = 0; i < numRows; ++i) {
            if (!lsm.isSelectedIndex(i)) continue;
            v.add(table.getModel().getValueAt(i, indexCol));
        }
        Object[] sel = new Object[v.size()];
        Iterator it = v.iterator();
        int i = 0;
        while (it.hasNext()) {
            sel[i] = it.next();
            ++i;
        }
        return sel;
    }

    public static void restoreSelections(JTable table, int indexCol, Object[] selections) {
        table.clearSelection();
        int numRows = table.getModel().getRowCount();
        for (int i = 0; i < numRows; ++i) {
            Object current = table.getModel().getValueAt(i, indexCol);
            boolean matchFound = false;
            int j = 0;
            while (!matchFound && j < selections.length) {
                if (selections[j].equals(current)) {
                    matchFound = true;
                    continue;
                }
                ++j;
            }
            if (!matchFound) continue;
            table.getSelectionModel().addSelectionInterval(i, i);
        }
    }

    public static int getColumnNumForTableColumn(JTable table, String columnName) {
        int numColumns = table.getColumnCount();
        int matchCol = -1;
        int col = 0;
        while (matchCol < 0 && col < numColumns) {
            String curColumnName = table.getColumnName(col);
            if (curColumnName.equals(columnName)) {
                matchCol = col;
                continue;
            }
            ++col;
        }
        return matchCol;
    }

    public static String tableContents(JTable table) {
        int numColumns = table.getColumnCount();
        int numRows = table.getRowCount();
        StringBuffer buf = new StringBuffer(10 * numRows * numColumns);
        buf.append("columns:");
        for (int j = 0; j < numColumns; ++j) {
            if (j > 0) {
                buf.append(',');
            }
            String colName = table.getColumnName(j);
            buf.append(" " + colName);
        }
        for (int i = 0; i < numRows; ++i) {
            buf.append('\n');
            buf.append("row " + i + ":");
            for (int j = 0; j < numColumns; ++j) {
                Object value;
                if (j > 0) {
                    buf.append(',');
                }
                if ((value = table.getModel().getValueAt(i, j)) == null) {
                    buf.append(" <null>");
                    continue;
                }
                buf.append(" " + value.toString());
            }
        }
        String str = buf.toString();
        return str;
    }
}

